/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import traben.flowing_fluids.FlowingFluids;

public class PlugWaterFeature {
    private static final Pair<Boolean, Runnable> defTrue = Pair.of((Object)true, null);
    private static final Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.DOWN};

    public static Set<BlockPos> findBlocks(ChunkAccess chunkAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = chunkAccess.getMinSectionY(); i < chunkAccess.getMaxSectionY(); ++i) {
            LevelChunkSection levelChunkSection = chunkAccess.getSection(chunkAccess.getSectionIndexFromSectionY(i));
            if (!levelChunkSection.maybeHas(PlugWaterFeature::isFluidSource)) continue;
            BlockPos blockPos = SectionPos.of((ChunkPos)chunkAccess.getPos(), (int)i).origin();
            for (int y = y1; y < y2; ++y) {
                for (int z = z1; z < z2; ++z) {
                    for (int x = x1; x < x2; ++x) {
                        BlockState blockState = levelChunkSection.getBlockState(x, y, z);
                        if (!PlugWaterFeature.isFluidSource(blockState)) continue;
                        set.add(mutableBlockPos.setWithOffset((Vec3i)blockPos, x, y, z).immutable());
                    }
                }
            }
        }
        return set;
    }

    public static void processChunk(LevelAccessor level, ChunkPos chunk, ChunkAccess chunkAccess) {
        boolean hasXNeg = level.hasChunk(chunk.x - 1, chunk.z);
        boolean hasXPos = level.hasChunk(chunk.x + 1, chunk.z);
        boolean hasZNeg = level.hasChunk(chunk.x, chunk.z - 1);
        boolean hasZPos = level.hasChunk(chunk.x, chunk.z + 1);
        Set<BlockPos> set = PlugWaterFeature.findBlocks(chunkAccess, 0, 0, 0, 16, 16, 16);
        if (hasXNeg) {
            set.addAll(PlugWaterFeature.findBlocks(level.getChunk(chunk.x - 1, chunk.z), 15, 0, 0, 16, 16, 16));
        }
        if (hasXPos) {
            set.addAll(PlugWaterFeature.findBlocks(level.getChunk(chunk.x + 1, chunk.z), 0, 0, 0, 1, 16, 16));
        }
        if (hasZNeg) {
            set.addAll(PlugWaterFeature.findBlocks(level.getChunk(chunk.x, chunk.z - 1), 0, 0, 15, 16, 16, 16));
        }
        if (hasZPos) {
            set.addAll(PlugWaterFeature.findBlocks(level.getChunk(chunk.x, chunk.z + 1), 0, 0, 0, 16, 16, 1));
        }
        if (set.isEmpty()) {
            return;
        }
        int minx = chunk.getMinBlockX();
        int minz = chunk.getMinBlockZ();
        int maxx = chunk.getMaxBlockX();
        int maxz = chunk.getMaxBlockZ();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int sea = level.getSeaLevel() - 5;
        HashSet doneSet = new HashSet();
        Supplier<Pair> testDo = () -> {
            if (mutableBlockPos.getX() < minx || mutableBlockPos.getX() > maxx) {
                return defTrue;
            }
            if (mutableBlockPos.getZ() < minz || mutableBlockPos.getZ() > maxz) {
                return defTrue;
            }
            if (set.contains(mutableBlockPos)) {
                return defTrue;
            }
            BlockState blockState = chunkAccess.getBlockState((BlockPos)mutableBlockPos);
            if (blockState.isAir() && blockState.getFluidState().isEmpty()) {
                BlockPos immutable = mutableBlockPos.immutable();
                doneSet.add(immutable);
                return Pair.of((Object)false, () -> PlugWaterFeature.fillBlock(chunkAccess, immutable, sea));
            }
            return null;
        };
        ArrayList<Runnable> runs = new ArrayList<Runnable>();
        for (BlockPos blockPos : set) {
            if (doneSet.contains(blockPos)) continue;
            boolean neighbourWater = false;
            runs.clear();
            for (Direction dir : dirs) {
                mutableBlockPos.setWithOffset((Vec3i)blockPos, dir);
                Pair result = testDo.get();
                if (result == null) continue;
                if (((Boolean)result.first()).booleanValue()) {
                    neighbourWater = true;
                    continue;
                }
                runs.add((Runnable)result.second());
            }
            if (!neighbourWater) continue;
            for (Runnable run : runs) {
                run.run();
            }
        }
    }

    private static boolean isFluidSource(BlockState state) {
        FluidState fluid = state.getFluidState();
        if (fluid.isEmpty() || !fluid.isSource()) {
            return false;
        }
        return FlowingFluids.config.isFluidAllowed(fluid);
    }

    private static void fillBlock(ChunkAccess chunk, BlockPos pos, int seaLevel) {
        Holder biome = chunk.getNoiseBiome(pos.getX(), pos.getY(), pos.getZ());
        BlockState blockState = biome.is(BiomeTags.IS_NETHER) ? Blocks.NETHERRACK.defaultBlockState() : (biome.is(BiomeTags.IS_END) ? Blocks.END_STONE.defaultBlockState() : (pos.getY() < 0 ? Blocks.DEEPSLATE.defaultBlockState() : (pos.getY() < seaLevel ? Blocks.STONE.defaultBlockState() : (biome.is(BiomeTags.HAS_VILLAGE_DESERT) || biome.is(BiomeTags.IS_BEACH) || biome.is(BiomeTags.IS_OCEAN) ? Blocks.SAND.defaultBlockState() : Blocks.MUD.defaultBlockState()))));
        if (FlowingFluids.config.announceWorldGenActions) {
            FlowingFluids.info("placed block during world gen: " + String.valueOf(blockState) + " at /tp @s " + pos.getX() + " " + pos.getY() + " " + pos.getZ());
        }
        ++FlowingFluids.waterPluggedThisSession;
        chunk.setBlockState(pos, blockState, false);
    }
}

