/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.Pair;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import traben.flowing_fluids.FlowingFluidsPlatform;
import traben.flowing_fluids.config.FFConfig;

public final class FlowingFluids {
    public static final String MOD_ID = "flowing_fluids";
    public static final Logger LOG = LoggerFactory.getLogger((String)"FlowingFluids");
    public static boolean isManeuveringFluids = false;
    public static boolean pistonTick = false;
    public static long debug_killFluidUpdatesUntilTime = 0L;
    public static int waterPluggedThisSession = 0;
    public static Set<Pair<Fluid, TagKey<Block>>> nonDisplacerTags = new HashSet<Pair<Fluid, TagKey<Block>>>();
    public static Set<Pair<Fluid, Block>> nonDisplacers = new HashSet<Pair<Fluid, Block>>();
    public static Set<TagKey<Biome>> infiniteBiomeTags = new HashSet<TagKey<Biome>>();
    public static Set<ResourceKey<Biome>> infiniteBiomes = new HashSet<ResourceKey<Biome>>();
    public static FFConfig config = new FFConfig();

    public static void info(String str) {
        LOG.info("[Flowing Fluids] {}", (Object)str);
    }

    public static void warn(String str) {
        LOG.warn("[Flowing Fluids] {}", (Object)str);
    }

    public static void error(String str) {
        LOG.error("[Flowing Fluids] {}", (Object)str);
    }

    public static void init() {
        FlowingFluids.info("initialising");
        infiniteBiomeTags.add((TagKey<Biome>)BiomeTags.IS_OCEAN);
        infiniteBiomeTags.add((TagKey<Biome>)BiomeTags.IS_RIVER);
        infiniteBiomeTags.add((TagKey<Biome>)BiomeTags.IS_BEACH);
        infiniteBiomes.add((ResourceKey<Biome>)Biomes.SWAMP);
        infiniteBiomes.add((ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
        nonDisplacerTags.add((Pair<Fluid, TagKey<Block>>)Pair.of((Object)Fluids.WATER, (Object)BlockTags.ICE));
        nonDisplacers.add((Pair<Fluid, Block>)Pair.of((Object)Fluids.WATER, (Object)Blocks.SPONGE));
        nonDisplacers.add((Pair<Fluid, Block>)Pair.of((Object)Fluids.LAVA, (Object)Blocks.OBSIDIAN));
        FlowingFluids.loadConfig();
    }

    public static void loadConfig() {
        File configFile = new File(FlowingFluidsPlatform.getConfigDirectory().toFile(), "flowing_fluids.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                config = (FFConfig)gson.fromJson((Reader)fileReader, FFConfig.class);
                fileReader.close();
            }
            catch (IOException iOException) {}
        } else {
            config = new FFConfig();
            FlowingFluids.saveConfig();
        }
    }

    public static void saveConfig() {
        File configFile = new File(FlowingFluidsPlatform.getConfigDirectory().toFile(), "flowing_fluids.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdirs();
        }
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            fileWriter.write(gson.toJson((Object)config));
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

