/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.config.FFConfig;

@Mixin(value={FlowingFluid.class})
public abstract class MixinFlowingFluid
extends Fluid {
    @Unique
    private static short ffCacheKey(BlockPos sourcePos, BlockPos spreadPos) {
        int i = spreadPos.getX() - sourcePos.getX();
        int j = spreadPos.getZ() - sourcePos.getZ();
        return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
    }

    @Unique
    private static boolean ff$handleWaterLoggedFlowAndReturnIfHandled(Level level, BlockPos posFrom, FluidState fluidState, int amount, BlockState thisState, BlockPos posTo, int destFluidAmount, boolean flowingDown) {
        boolean toIsWaterloggable;
        boolean fromIsWaterloggable;
        boolean bl = fromIsWaterloggable = thisState.getBlock() instanceof LiquidBlockContainer && thisState.getBlock() instanceof BucketPickup;
        if (fromIsWaterloggable && (flowingDown ? FlowingFluids.config.waterLogFlowMode.blocksFlowOutDown() : FlowingFluids.config.waterLogFlowMode.blocksFlowOutSides())) {
            return true;
        }
        Block blockTo = level.getBlockState(posTo).getBlock();
        boolean bl2 = toIsWaterloggable = blockTo instanceof LiquidBlockContainer && blockTo instanceof BucketPickup;
        if (toIsWaterloggable && FlowingFluids.config.waterLogFlowMode.blocksFlowIn(flowingDown)) {
            return true;
        }
        if (fromIsWaterloggable || toIsWaterloggable) {
            int totalAmount = destFluidAmount + amount;
            if (totalAmount < 8) {
                return true;
            }
            if (toIsWaterloggable && fromIsWaterloggable) {
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posFrom, fluidState.getType(), 0);
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posTo, fluidState.getType(), 8);
            } else if (toIsWaterloggable) {
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posFrom, fluidState.getType(), totalAmount - 8);
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posTo, fluidState.getType(), 8);
            } else {
                if (destFluidAmount > 0) {
                    return true;
                }
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posFrom, fluidState.getType(), 0);
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posTo, fluidState.getType(), 8);
            }
            return true;
        }
        return false;
    }

    protected boolean isRandomlyTicking() {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(this)) {
            return true;
        }
        return super.isRandomlyTicking();
    }

    protected void randomTick(ServerLevel level, BlockPos pos, FluidState state, RandomSource random) {
        super.randomTick(level, pos, state, random);
        if (FlowingFluids.config.enableMod && FlowingFluids.config.randomTickLevelingDistance > 0 && level.getChunkAt(pos).getFluidTicks().count() < 16 && FlowingFluids.config.isFluidAllowed(this) && !level.getFluidState(pos.above()).getType().isSame((Fluid)this)) {
            BiConsumer<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos> move;
            int amount = state.getAmount();
            if (amount <= this.getDropOff((LevelReader)level)) {
                return;
            }
            int amountLess = amount - 1;
            Direction randomDirection = FFFluidUtils.getCardinalsShuffle(level.getRandom()).get(0);
            if (level.getRandom().nextBoolean()) {
                move = (mbp, up) -> {
                    mbp.move(randomDirection);
                    up.move(randomDirection);
                };
            } else {
                Direction offStep = level.getRandom().nextBoolean() ? randomDirection.getClockWise() : randomDirection.getCounterClockWise();
                RandomSource rand = level.getRandom();
                move = (mbp, up) -> {
                    Direction dir = rand.nextBoolean() ? randomDirection : offStep;
                    mbp.move(dir);
                    up.move(dir);
                };
            }
            BlockPos.MutableBlockPos movingDir = pos.mutable();
            BlockPos.MutableBlockPos movingDirAbove = pos.above().mutable();
            for (int i = 0; i < FlowingFluids.config.randomTickLevelingDistance; ++i) {
                move.accept(movingDir, movingDirAbove);
                BlockState stateDir = level.getBlockState((BlockPos)movingDir);
                if (!(stateDir.getBlock() instanceof LiquidBlock)) {
                    return;
                }
                FluidState fluidStateDir = stateDir.getFluidState();
                if (!fluidStateDir.getType().isSame((Fluid)this)) {
                    return;
                }
                if (level.getFluidState((BlockPos)movingDirAbove).getType().isSame((Fluid)this)) {
                    return;
                }
                int amountDir = fluidStateDir.getAmount();
                if (amountDir > amount) {
                    return;
                }
                if (amountDir >= amountLess) continue;
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, (BlockPos)movingDir, this, amountDir + 1);
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, pos, this, amountLess);
                return;
            }
        }
    }

    @Shadow
    protected abstract int getDropOff(LevelReader var1);

    @Shadow
    protected abstract void spreadTo(LevelAccessor var1, BlockPos var2, BlockState var3, Direction var4, FluidState var5);

    @Shadow
    protected abstract int getSlopeFindDistance(LevelReader var1);

    @Shadow
    public abstract int getAmount(FluidState var1);

    @Inject(method={"getOwnHeight(Lnet/minecraft/world/level/material/FluidState;)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void ff$differentRenderHeight(FluidState state, CallbackInfoReturnable<Float> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(state) && FlowingFluids.config.fullLiquidHeight != FFConfig.LiquidHeight.REGULAR) {
            cir.setReturnValue((Object)(switch (FlowingFluids.config.fullLiquidHeight) {
                case FFConfig.LiquidHeight.BLOCK -> Float.valueOf((float)state.getAmount() / 8.0f);
                case FFConfig.LiquidHeight.SLAB -> Float.valueOf((float)state.getAmount() / 16.0f);
                case FFConfig.LiquidHeight.CARPET -> Float.valueOf(0.0625f);
                case FFConfig.LiquidHeight.REGULAR_LOWER_BOUND -> Float.valueOf(((float)state.getAmount() - 0.9f) * 0.8888889f / 7.0f);
                case FFConfig.LiquidHeight.BLOCK_LOWER_BOUND -> Float.valueOf(((float)state.getAmount() - 0.9f) / 7.0f);
                default -> Float.valueOf((float)state.getAmount() / 9.0f);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/FluidState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void ff$tickMixin(ServerLevel level, BlockPos blockPos, BlockState thisState, FluidState fluidState, CallbackInfo ci) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(fluidState)) {
            ci.cancel();
            if (FlowingFluids.config.dontTickAtLocation(blockPos, (LevelAccessor)level)) {
                level.scheduleTick(blockPos, (Fluid)this, 200 + level.random.nextInt(200));
                return;
            }
            if (System.currentTimeMillis() < FlowingFluids.debug_killFluidUpdatesUntilTime) {
                return;
            }
            FlowingFluids.isManeuveringFluids = true;
            boolean withinInfBiomeHeights = FlowingFluids.config.fastBiomeRefillAtSeaLevelOnly ? level.getSeaLevel() == blockPos.getY() || level.getSeaLevel() - 1 == blockPos.getY() : level.getSeaLevel() == blockPos.getY() && blockPos.getY() > 0;
            boolean isWaterAndInfiniteBiome = fluidState.is(FluidTags.WATER) && withinInfBiomeHeights && FFFluidUtils.matchInfiniteBiomes((Holder<Biome>)level.getBiome(blockPos)) && level.getBrightness(LightLayer.SKY, blockPos) > 0;
            boolean dontConsumeWater = isWaterAndInfiniteBiome && level.getSeaLevel() != blockPos.getY() && level.getRandom().nextFloat() < FlowingFluids.config.infiniteWaterBiomeNonConsumeChance;
            try {
                Direction dir;
                it.unimi.dsi.fastutil.Pair<Integer, Runnable> remainder;
                FlowingFluid flow;
                FluidState aboveF;
                int aboveAmount;
                BlockPos abovePos;
                BlockState above;
                BlockPos posDown = blockPos.below();
                int remainingAmount = this.flowing_fluids$checkAndFlowDown((Level)level, blockPos, fluidState, thisState, posDown, level.getBlockState(posDown), fluidState.getAmount());
                if (remainingAmount <= 0) {
                    return;
                }
                if (fluidState.getAmount() == 8 && thisState.liquid() && (above = level.getBlockState(abovePos = blockPos.above())).liquid() && (aboveAmount = (aboveF = above.getFluidState()).getAmount()) > 0 && FFFluidUtils.canFluidFlowFromPosToDirectionFitOverride(flow = (FlowingFluid)aboveF.getType(), (BlockGetter)level, abovePos, above, Direction.DOWN, blockPos, thisState) && (Integer)(remainder = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction((LevelAccessor)level, blockPos, aboveAmount, flow, 40, false, !FlowingFluids.pistonTick)).first() < aboveAmount) {
                    ((Runnable)remainder.second()).run();
                    if (!dontConsumeWater) {
                        FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, abovePos, (Fluid)flow, (Integer)remainder.first());
                    }
                    return;
                }
                if (remainingAmount > this.getDropOff((LevelReader)level)) {
                    this.ff$flowToSides((Level)level, blockPos, fluidState, remainingAmount, thisState);
                } else if (FlowingFluids.config.flowToEdges && (dir = this.flowing_fluids$getLowestSpreadableLookingFor4BlockDrops((Level)level, blockPos, fluidState, 1, true)) != null) {
                    BlockPos pos = blockPos.relative(dir);
                    this.flowing_fluids$setOrRemoveWaterAmountAt((Level)level, blockPos, 0, thisState, dir);
                    this.flowing_fluids$spreadTo2((LevelAccessor)level, pos, level.getBlockState(pos), dir, remainingAmount);
                }
            }
            finally {
                if (isWaterAndInfiniteBiome) {
                    if (level.getSeaLevel() == blockPos.getY()) {
                        FluidState below;
                        int amount;
                        if (level.getRandom().nextFloat() < FlowingFluids.config.infiniteWaterBiomeDrainSurfaceChance && (amount = level.getFluidState(blockPos).getAmount()) > 0 && (below = level.getFluidState(blockPos.below())).getAmount() == 8 && below.is(FluidTags.WATER)) {
                            level.setBlockAndUpdate(blockPos, FFFluidUtils.getBlockForFluidByAmount(this, amount - 1));
                        }
                    } else if (dontConsumeWater) {
                        level.setBlock(blockPos, thisState, 0);
                    }
                }
                FlowingFluids.isManeuveringFluids = false;
                FlowingFluids.pistonTick = false;
            }
        }
    }

    @Unique
    private void ff$flowToSides(Level level, BlockPos blockPos, FluidState fluidState, int amount, BlockState thisState) {
        int destFluidAmount;
        Direction dir = this.flowing_fluids$getLowestSpreadableLookingFor4BlockDrops(level, blockPos, fluidState, amount, false);
        if (dir == null) {
            return;
        }
        BlockPos posDir = blockPos.relative(dir);
        if (MixinFlowingFluid.ff$handleWaterLoggedFlowAndReturnIfHandled(level, blockPos, fluidState, amount, thisState, posDir, destFluidAmount = level.getFluidState(posDir).getAmount(), false)) {
            return;
        }
        int difference = amount - destFluidAmount;
        int averageLevel = destFluidAmount + difference / 2;
        boolean hasRemainder = difference % 2 != 0;
        int fromAmount = averageLevel;
        int toAmount = hasRemainder ? averageLevel + 1 : averageLevel;
        FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, blockPos, fluidState.getType(), fromAmount);
        FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posDir, fluidState.getType(), toAmount);
    }

    @Unique
    private int flowing_fluids$checkAndFlowDown(Level level, BlockPos blockPos, FluidState fluidState, BlockState thisState, BlockPos posDown, BlockState stateDown, int amount) {
        FluidState downFState = level.getFluidState(posDown);
        if (this.flowing_fluids$canSpreadTo(fluidState.getType(), fluidState.getAmount(), (BlockGetter)level, blockPos, thisState, Direction.DOWN, posDown, stateDown, downFState)) {
            BlockState block;
            if (!downFState.isEmpty() && !downFState.getType().isSame(fluidState.getType())) {
                this.flowing_fluids$setOrRemoveWaterAmountAt(level, blockPos, amount - 1, thisState, Direction.DOWN);
                this.flowing_fluids$spreadTo2((LevelAccessor)level, posDown, stateDown, Direction.DOWN, 1);
                return amount - 1;
            }
            if (FlowingFluids.config.easyPistonPump && FlowingFluids.config.enablePistonPushing && (block = level.getBlockState(posDown.below())).is(Blocks.MOVING_PISTON) && block.getValue((Property)DirectionalBlock.FACING) == Direction.UP) {
                level.scheduleTick(blockPos, (Fluid)this, 10);
                FlowingFluids.pistonTick = true;
                return amount;
            }
            int fluidDownAmount = downFState.getAmount();
            if (MixinFlowingFluid.ff$handleWaterLoggedFlowAndReturnIfHandled(level, blockPos, fluidState, amount, thisState, posDown, fluidDownAmount, true)) {
                return level.getFluidState(blockPos).getAmount();
            }
            int amountDestCanAccept = Math.min(8 - fluidDownAmount, amount);
            if (amountDestCanAccept > 0) {
                int destNewAmount = fluidDownAmount + amountDestCanAccept;
                int sourceNewAmount = amount - amountDestCanAccept;
                this.flowing_fluids$setOrRemoveWaterAmountAt(level, blockPos, sourceNewAmount, thisState, Direction.DOWN);
                this.flowing_fluids$spreadTo2((LevelAccessor)level, posDown, stateDown, Direction.DOWN, destNewAmount);
                return sourceNewAmount;
            }
        }
        return amount;
    }

    @Unique
    private void flowing_fluids$setOrRemoveWaterAmountAt(Level level, BlockPos blockPos, int amount, BlockState thisState, Direction direction) {
        if (amount > 0) {
            this.flowing_fluids$spreadTo2((LevelAccessor)level, blockPos, thisState, direction, amount);
        } else {
            FFFluidUtils.removeAllFluidAtPos((LevelAccessor)level, blockPos, this);
        }
    }

    @Inject(method={"getNewLiquid(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/material/FluidState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void flowing_fluids$validateLiquidMixin(ServerLevel level, BlockPos blockPos, BlockState blockState, CallbackInfoReturnable<FluidState> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(this)) {
            FluidState state = level.getFluidState(blockPos);
            cir.setReturnValue((Object)FFFluidUtils.getStateForFluidByAmount(state.getType(), state.getAmount()));
        }
    }

    @Unique
    @Nullable
    private Direction flowing_fluids$getLowestSpreadableLookingFor4BlockDrops(Level level, BlockPos blockPos, FluidState fluidState, int amount, boolean requiresSlope) {
        Short2ObjectOpenHashMap statesAtPos = new Short2ObjectOpenHashMap();
        AtomicBoolean anyFlowableNeighbours2LevelsLowerOrMore = new AtomicBoolean(requiresSlope);
        List<Direction> directionsCanSpreadToSortedByAmount = FFFluidUtils.getCardinalsShuffle(level.random).stream().sorted(Comparator.comparingInt(dir1 -> level.getFluidState(blockPos.relative(dir1)).getAmount())).filter(arg_0 -> this.lambda$flowing_fluids$getLowestSpreadableLookingFor4BlockDrops$3(blockPos, level, (Short2ObjectMap)statesAtPos, fluidState, amount, requiresSlope, anyFlowableNeighbours2LevelsLowerOrMore, arg_0)).toList();
        if (directionsCanSpreadToSortedByAmount.isEmpty()) {
            return null;
        }
        boolean requiresSlopeWithOverride = requiresSlope || !anyFlowableNeighbours2LevelsLowerOrMore.get();
        Direction spreadDirection = this.flowing_fluids$getValidDirectionFromDeepSpreadSearch(level, blockPos, fluidState, amount, requiresSlopeWithOverride, directionsCanSpreadToSortedByAmount, (Short2ObjectMap<Pair<BlockState, FluidState>>)statesAtPos);
        if (spreadDirection == null && !requiresSlopeWithOverride) {
            return directionsCanSpreadToSortedByAmount.get(0);
        }
        return spreadDirection;
    }

    @Unique
    @Nullable
    private Direction flowing_fluids$getValidDirectionFromDeepSpreadSearch(Level level, BlockPos blockPos, FluidState fluidState, int amount, boolean requiresSlope, List<Direction> directionsCanSpreadToSortedByAmount, Short2ObjectMap<Pair<BlockState, FluidState>> statesAtPos) {
        int slopeFindDistance = this.getSlopeFindDistance((LevelReader)level);
        if (slopeFindDistance < 1) {
            return null;
        }
        Short2BooleanOpenHashMap posCanFlowDown = new Short2BooleanOpenHashMap();
        posCanFlowDown.put(MixinFlowingFluid.ffCacheKey(blockPos, blockPos), false);
        return directionsCanSpreadToSortedByAmount.stream().map(arg_0 -> this.lambda$flowing_fluids$getValidDirectionFromDeepSpreadSearch$4(blockPos, level, amount, (Short2BooleanMap)posCanFlowDown, fluidState, requiresSlope, statesAtPos, slopeFindDistance, arg_0)).filter(pair -> !requiresSlope || (Integer)pair.getSecond() <= slopeFindDistance).min(Comparator.comparingInt(Pair::getSecond)).map(Pair::getFirst).orElse(null);
    }

    @Unique
    protected int flowing_fluids$getSlopeDistance(LevelReader level, BlockPos sourcePosForKey, int distance, Direction fromDir, Fluid sourceFluid, int sourceAmount, BlockPos newPos, Short2ObjectMap<Pair<BlockState, FluidState>> statesAtPos, Short2BooleanMap posCanFlowDown, boolean forceSlopeDownSameOrEmpty, int slopeFindDistance) {
        int smallest = 1000;
        int searchDistance = distance + 1;
        for (Direction searchDir : Direction.Plane.HORIZONTAL) {
            int next;
            if (searchDir == fromDir) continue;
            BlockPos searchPos = newPos.relative(searchDir);
            short searchKey = MixinFlowingFluid.ffCacheKey(sourcePosForKey, searchPos);
            Pair<BlockState, FluidState> searchStates = this.flowing_fluids$getSetPosCache(searchKey, level, statesAtPos, searchPos);
            if (!this.flowing_fluids$canSpreadToOptionallySameOrEmpty(sourceFluid, sourceAmount, (BlockGetter)level, newPos, level.getBlockState(newPos), searchDir, searchPos, (BlockState)searchStates.getFirst(), (FluidState)searchStates.getSecond(), forceSlopeDownSameOrEmpty)) continue;
            if (((FluidState)searchStates.getSecond()).getAmount() < sourceAmount - 2 || this.flowing_fluids$getSetFlowDownCache(searchKey, level, posCanFlowDown, searchPos, sourceFluid, forceSlopeDownSameOrEmpty)) {
                return searchDistance;
            }
            if (searchDistance >= slopeFindDistance || (next = this.flowing_fluids$getSlopeDistance(level, sourcePosForKey, searchDistance, searchDir.getOpposite(), sourceFluid, sourceAmount, searchPos, statesAtPos, posCanFlowDown, forceSlopeDownSameOrEmpty, slopeFindDistance)) >= smallest) continue;
            smallest = next;
        }
        return smallest;
    }

    @Unique
    private Pair<BlockState, FluidState> flowing_fluids$getSetPosCache(short key, LevelReader level, Short2ObjectMap<Pair<BlockState, FluidState>> statesAtPos, BlockPos pos) {
        return (Pair)statesAtPos.computeIfAbsent(key, sx -> {
            BlockState blockState = level.getBlockState(pos);
            return Pair.of((Object)blockState, (Object)blockState.getFluidState());
        });
    }

    @Unique
    private boolean flowing_fluids$getSetFlowDownCache(short key, LevelReader level, Short2BooleanMap boolAtPos, BlockPos pos, Fluid sourceFluid, boolean forceSlopeDownSameOrEmpty) {
        return boolAtPos.computeIfAbsent(key, sx -> {
            BlockPos posDown = pos.below();
            return this.flowing_fluids$canSpreadToOptionallySameOrEmpty(sourceFluid, 8, (BlockGetter)level, pos, level.getBlockState(pos), Direction.DOWN, posDown, level.getBlockState(posDown), level.getFluidState(posDown), forceSlopeDownSameOrEmpty);
        });
    }

    @Unique
    protected void flowing_fluids$spreadTo2(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, Direction direction, int amount) {
        this.spreadTo(levelAccessor, blockPos, blockState, direction, FFFluidUtils.getStateForFluidByAmount(this, amount));
    }

    @Unique
    private boolean flowing_fluids$canSpreadToOptionallySameOrEmpty(Fluid sourceFluid, int sourceAmount, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState2, boolean enforceSameFluidOrEmpty) {
        if (enforceSameFluidOrEmpty && !fluidState2.isEmpty() && !fluidState2.getType().isSame(sourceFluid)) {
            return false;
        }
        return this.flowing_fluids$canSpreadTo(sourceFluid, sourceAmount, blockGetter, blockPos, blockState, direction, blockPos2, blockState2, fluidState2);
    }

    @Unique
    private boolean flowing_fluids$canSpreadTo(Fluid sourceFluid, int sourceAmount, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState2) {
        return FFFluidUtils.canFluidFlowFromPosToDirection((FlowingFluid)sourceFluid, sourceAmount, blockGetter, blockPos, blockState, direction, blockPos2, blockState2, fluidState2);
    }

    private /* synthetic */ Pair lambda$flowing_fluids$getValidDirectionFromDeepSpreadSearch$4(BlockPos blockPos, Level level, int amount, Short2BooleanMap posCanFlowDown, FluidState fluidState, boolean requiresSlope, Short2ObjectMap statesAtPos, int slopeFindDistance, Direction dir) {
        BlockPos posDir = blockPos.relative(dir);
        short key = MixinFlowingFluid.ffCacheKey(blockPos, posDir);
        if (level.getFluidState(posDir).getAmount() < amount - 1 || this.flowing_fluids$getSetFlowDownCache(key, (LevelReader)level, posCanFlowDown, posDir, fluidState.getType(), requiresSlope)) {
            return Pair.of((Object)dir, (Object)0);
        }
        return Pair.of((Object)dir, (Object)this.flowing_fluids$getSlopeDistance((LevelReader)level, blockPos, 1, dir.getOpposite(), fluidState.getType(), amount + 1, posDir, (Short2ObjectMap<Pair<BlockState, FluidState>>)statesAtPos, posCanFlowDown, requiresSlope, slopeFindDistance));
    }

    private /* synthetic */ boolean lambda$flowing_fluids$getLowestSpreadableLookingFor4BlockDrops$3(BlockPos blockPos, Level level, Short2ObjectMap statesAtPos, FluidState fluidState, int amount, boolean requiresSlope, AtomicBoolean anyFlowableNeighbours2LevelsLowerOrMore, Direction dir) {
        BlockPos posDir = blockPos.relative(dir);
        short key = MixinFlowingFluid.ffCacheKey(blockPos, posDir);
        Pair<BlockState, FluidState> statesDir = this.flowing_fluids$getSetPosCache(key, (LevelReader)level, (Short2ObjectMap<Pair<BlockState, FluidState>>)statesAtPos, posDir);
        BlockState stateDir = (BlockState)statesDir.getFirst();
        FluidState fluidStateDir = (FluidState)statesDir.getSecond();
        int amountDir = fluidStateDir.getAmount();
        boolean canFlow = this.flowing_fluids$canSpreadToOptionallySameOrEmpty(fluidState.getType(), amount, (BlockGetter)level, blockPos, level.getBlockState(blockPos), dir, posDir, stateDir, fluidStateDir, requiresSlope);
        if (canFlow && !anyFlowableNeighbours2LevelsLowerOrMore.get()) {
            anyFlowableNeighbours2LevelsLowerOrMore.set(amountDir < amount - 1);
        }
        return canFlow;
    }
}

