/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.config;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import traben.flowing_fluids.FlowingFluids;

public class FFConfig {
    public boolean flowToEdges = true;
    public boolean enableMod = true;
    public boolean enableDisplacement = true;
    public boolean enablePistonPushing = true;
    public float rainRefillChance = 0.5f;
    public float oceanRiverSwampRefillChance = 1.0f;
    public float evaporationChance = 0.05f;
    public float evaporationNetherChance = 1.0f;
    public boolean printRandomTicks = false;
    public boolean hideFlowingTexture = true;
    public LiquidHeight fullLiquidHeight = LiquidHeight.REGULAR;
    public float farmlandDrainWaterChance = 0.1f;
    public boolean debugWaterLevelColours = false;
    public WaterLogFlowMode waterLogFlowMode = WaterLogFlowMode.IN_FROM_TOP_ELSE_OUT;
    public int waterFlowDistance = 4;
    public int lavaFlowDistance = 2;
    public int lavaNetherFlowDistance = 4;
    public int waterTickDelay = 2;
    public int lavaTickDelay = 15;
    public int lavaNetherTickDelay = 5;
    public int randomTickLevelingDistance = 32;
    public float drinkWaterToBreedAnimalChance = 0.1f;
    public boolean encloseAllFluidOnWorldGen = true;
    public boolean announceWorldGenActions = false;
    public boolean easyPistonPump = true;
    public boolean waterFlowAffectsBoats = false;
    public boolean waterFlowAffectsEntities = true;
    public boolean waterFlowAffectsPlayers = false;
    public boolean waterFlowAffectsItems = true;
    public float infiniteWaterBiomeNonConsumeChance = 0.01f;
    public float infiniteWaterBiomeDrainSurfaceChance = 0.1f;
    public int minWaterLevelForIce = 4;
    public boolean rainFillsWaterHigher = true;
    public int minLavaLevelForObsidian = 6;
    public CreateWaterWheelMode create_waterWheelMode = CreateWaterWheelMode.REQUIRE_FLOW_OR_RIVER;
    public boolean create_infinitePipes = false;
    public Set<String> fluidBlacklist = new ObjectOpenHashSet();
    public static int[] waterLevelColours = new int[]{ARGB.color((int)255, (int)0, (int)0, (int)255), ARGB.color((int)255, (int)0, (int)128, (int)255), ARGB.color((int)255, (int)0, (int)255, (int)192), ARGB.color((int)255, (int)0, (int)255, (int)0), ARGB.color((int)255, (int)255, (int)255, (int)0), ARGB.color((int)255, (int)255, (int)128, (int)0), ARGB.color((int)255, (int)255, (int)0, (int)0), ARGB.color((int)255, (int)255, (int)255, (int)255)};

    public boolean isFluidAllowed(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        if (this.fluidBlacklist.isEmpty() || fluid == Fluids.EMPTY) {
            return true;
        }
        return !this.fluidBlacklist.contains(BuiltInRegistries.FLUID.getKey((Object)fluid).toString());
    }

    public boolean isFluidAllowed(FluidState fluid) {
        return this.isFluidAllowed(fluid.getType());
    }

    public boolean isWaterAllowed() {
        return this.isFluidAllowed((Fluid)Fluids.WATER);
    }

    public FFConfig() {
    }

    public FFConfig(FriendlyByteBuf buffer) {
        FlowingFluids.info("- Decoding server config packet from server.");
        this.flowToEdges = buffer.readBoolean();
        this.enableMod = buffer.readBoolean();
        this.enableDisplacement = buffer.readBoolean();
        this.enablePistonPushing = buffer.readBoolean();
        this.rainRefillChance = buffer.readFloat();
        this.oceanRiverSwampRefillChance = buffer.readFloat();
        this.evaporationChance = buffer.readFloat();
        this.evaporationNetherChance = buffer.readFloat();
        this.printRandomTicks = buffer.readBoolean();
        this.hideFlowingTexture = buffer.readBoolean();
        this.fullLiquidHeight = (LiquidHeight)buffer.readEnum(LiquidHeight.class);
        this.farmlandDrainWaterChance = buffer.readFloat();
        this.debugWaterLevelColours = buffer.readBoolean();
        this.waterLogFlowMode = (WaterLogFlowMode)buffer.readEnum(WaterLogFlowMode.class);
        this.waterFlowDistance = buffer.readVarInt();
        this.lavaFlowDistance = buffer.readVarInt();
        this.lavaNetherFlowDistance = buffer.readVarInt();
        this.waterTickDelay = buffer.readVarInt();
        this.lavaTickDelay = buffer.readVarInt();
        this.lavaNetherTickDelay = buffer.readVarInt();
        this.randomTickLevelingDistance = buffer.readVarInt();
        this.drinkWaterToBreedAnimalChance = buffer.readFloat();
        this.encloseAllFluidOnWorldGen = buffer.readBoolean();
        this.announceWorldGenActions = buffer.readBoolean();
        this.easyPistonPump = buffer.readBoolean();
        this.waterFlowAffectsBoats = buffer.readBoolean();
        this.waterFlowAffectsEntities = buffer.readBoolean();
        this.waterFlowAffectsPlayers = buffer.readBoolean();
        this.waterFlowAffectsItems = buffer.readBoolean();
        this.infiniteWaterBiomeNonConsumeChance = buffer.readFloat();
        this.infiniteWaterBiomeDrainSurfaceChance = buffer.readFloat();
        this.minWaterLevelForIce = buffer.readVarInt();
        this.rainFillsWaterHigher = buffer.readBoolean();
        this.minLavaLevelForObsidian = buffer.readVarInt();
        this.create_waterWheelMode = (CreateWaterWheelMode)buffer.readEnum(CreateWaterWheelMode.class);
        this.create_infinitePipes = buffer.readBoolean();
        this.fluidBlacklist = (Set)buffer.readCollection(ObjectOpenHashSet::new, FriendlyByteBuf::readUtf);
    }

    public void encodeToByteBuffer(FriendlyByteBuf buffer) {
        FlowingFluids.info("- Encoding server config packet for client.");
        buffer.writeBoolean(this.flowToEdges);
        buffer.writeBoolean(this.enableMod);
        buffer.writeBoolean(this.enableDisplacement);
        buffer.writeBoolean(this.enablePistonPushing);
        buffer.writeFloat(this.rainRefillChance);
        buffer.writeFloat(this.oceanRiverSwampRefillChance);
        buffer.writeFloat(this.evaporationChance);
        buffer.writeFloat(this.evaporationNetherChance);
        buffer.writeBoolean(this.printRandomTicks);
        buffer.writeBoolean(this.hideFlowingTexture);
        buffer.writeEnum((Enum)this.fullLiquidHeight);
        buffer.writeFloat(this.farmlandDrainWaterChance);
        buffer.writeBoolean(this.debugWaterLevelColours);
        buffer.writeEnum((Enum)this.waterLogFlowMode);
        buffer.writeVarInt(this.waterFlowDistance);
        buffer.writeVarInt(this.lavaFlowDistance);
        buffer.writeVarInt(this.lavaNetherFlowDistance);
        buffer.writeVarInt(this.waterTickDelay);
        buffer.writeVarInt(this.lavaTickDelay);
        buffer.writeVarInt(this.lavaNetherTickDelay);
        buffer.writeVarInt(this.randomTickLevelingDistance);
        buffer.writeFloat(this.drinkWaterToBreedAnimalChance);
        buffer.writeBoolean(this.encloseAllFluidOnWorldGen);
        buffer.writeBoolean(this.announceWorldGenActions);
        buffer.writeBoolean(this.easyPistonPump);
        buffer.writeBoolean(this.waterFlowAffectsBoats);
        buffer.writeBoolean(this.waterFlowAffectsEntities);
        buffer.writeBoolean(this.waterFlowAffectsPlayers);
        buffer.writeBoolean(this.waterFlowAffectsItems);
        buffer.writeFloat(this.infiniteWaterBiomeNonConsumeChance);
        buffer.writeFloat(this.infiniteWaterBiomeDrainSurfaceChance);
        buffer.writeVarInt(this.minWaterLevelForIce);
        buffer.writeBoolean(this.rainFillsWaterHigher);
        buffer.writeVarInt(this.minLavaLevelForObsidian);
        buffer.writeEnum((Enum)this.create_waterWheelMode);
        buffer.writeBoolean(this.create_infinitePipes);
        buffer.writeCollection(this.fluidBlacklist, FriendlyByteBuf::writeUtf);
    }

    public static enum LiquidHeight {
        REGULAR,
        REGULAR_LOWER_BOUND,
        BLOCK,
        BLOCK_LOWER_BOUND,
        SLAB,
        CARPET;

    }

    public static enum WaterLogFlowMode {
        ONLY_IN,
        ONLY_OUT,
        IN_FROM_TOP_ELSE_OUT,
        OUT_DOWN_ELSE_IN,
        IGNORE;


        public boolean blocksFlowOutDown() {
            return this == ONLY_IN || this == IGNORE;
        }

        public boolean blocksFlowIn(boolean down) {
            if (down) {
                return this == ONLY_OUT || this == IGNORE;
            }
            return this == ONLY_OUT || this == IN_FROM_TOP_ELSE_OUT || this == IGNORE;
        }

        public boolean blocksFlowOutSides() {
            return this == ONLY_IN || this == OUT_DOWN_ELSE_IN || this == IGNORE;
        }
    }

    public static enum CreateWaterWheelMode {
        ALWAYS,
        REQUIRE_FLOW,
        REQUIRE_FLOW_OR_RIVER,
        REQUIRE_FLUID,
        REQUIRE_FULL_FLUID,
        REQUIRE_FLOW_OR_RIVER_OPPOSITE,
        REQUIRE_FLUID_OPPOSITE,
        REQUIRE_FULL_FLUID_OPPOSITE,
        ALWAYS_OPPOSITE;


        public boolean isCounterSpin() {
            return this.ordinal() > 4;
        }

        public boolean isRiver() {
            return this == REQUIRE_FLOW_OR_RIVER || this == REQUIRE_FLOW_OR_RIVER_OPPOSITE;
        }

        public boolean needsFullFluid() {
            return this == REQUIRE_FULL_FLUID || this == REQUIRE_FULL_FLUID_OPPOSITE;
        }

        public boolean always() {
            return this == ALWAYS || this == ALWAYS_OPPOSITE;
        }
    }
}

