/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.neoforge;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import traben.flowing_fluids.config.FFConfig;
import traben.flowing_fluids.config.FFConfigData;

public class FFConfigDataNeoForge
extends FFConfigData {
    public static final StreamCodec<FriendlyByteBuf, FFConfigData> CODEC = new StreamCodec<FriendlyByteBuf, FFConfigData>(){

        @NotNull
        public FFConfigData decode(@NotNull FriendlyByteBuf buf) {
            FFConfigData data = FFConfigDataNeoForge.read(buf);
            if (data.isValid()) {
                return data;
            }
            throw new RuntimeException("[Flowing Fluids] - Invalid Server Config data received");
        }

        public void encode(FriendlyByteBuf buf, FFConfigData value) {
            value.write(buf);
        }
    };

    public FFConfigDataNeoForge() {
    }

    public FFConfigDataNeoForge(FFConfig delegate) {
        super(delegate);
    }

    public static FFConfigData read(FriendlyByteBuf buffer) {
        FFConfigDataNeoForge packet;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            try {
                System.out.println("[Solid mobs] - Server Config packet received");
                packet = new FFConfigDataNeoForge(new FFConfig(buffer));
            }
            catch (Exception e) {
                System.out.println("[Solid mobs] - Server Config packet decoding failed because:\n" + String.valueOf(e));
                e.printStackTrace();
                packet = new FFConfigDataNeoForge(null);
            }
        } else {
            System.out.println("[Solid mobs] - received on server?????");
            packet = new FFConfigDataNeoForge(null);
        }
        return packet;
    }
}

