/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import traben.flowing_fluids.FlowingFluids;

public class FFFluidUtils {
    @NotNull
    public static class_2960 res(String fullPath) {
        return class_2960.method_60654((String)fullPath);
    }

    @NotNull
    public static class_2960 res(String namespace, String path) {
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static boolean canFluidFlowToNeighbourFromPos(class_1936 accessor, class_2338 pos, class_3609 fluid, int amount) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (!FFFluidUtils.canFluidFlowFromPosToDirection(fluid, amount, accessor, pos, direction)) continue;
            return true;
        }
        return false;
    }

    public static class_3610 getStateForFluidByAmount(class_3611 fluid, int amount) {
        if (amount < 1) {
            return class_3612.field_15906.method_15785();
        }
        if (fluid instanceof class_3609) {
            class_3609 flowing = (class_3609)fluid;
            return amount >= 8 ? flowing.method_15729(false) : flowing.method_15728(amount, false);
        }
        return amount >= 8 ? fluid.method_15785() : (class_3610)fluid.method_15785().method_47968((class_2769)class_3609.field_15900, (Comparable)Integer.valueOf(amount));
    }

    public static class_2680 getBlockForFluidByAmount(class_3611 fluid, int amount) {
        return FFFluidUtils.getStateForFluidByAmount(fluid, amount).method_15759();
    }

    public static boolean setFluidStateAtPosToNewAmount(class_1936 levelAccessor, class_2338 pos, class_3611 fluid, int newAmount) {
        if (newAmount < 1) {
            return FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, fluid);
        }
        class_2680 blockState = levelAccessor.method_8320(pos);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof class_2402) {
            class_2402 liquidBlockContainer = (class_2402)class_22482;
            if (newAmount == 8) {
                return liquidBlockContainer.method_10311(levelAccessor, pos, blockState, FFFluidUtils.getStateForFluidByAmount(fluid, newAmount));
            }
            class_2248 class_22483 = blockState.method_26204();
            if (class_22483 instanceof class_2263) {
                class_2263 bucketPickup = (class_2263)class_22483;
                bucketPickup.method_9700(null, levelAccessor, pos, blockState);
                return true;
            }
            if (!blockState.method_26188(fluid)) {
                return false;
            }
        }
        if (!blockState.method_26215() && fluid instanceof class_3609) {
            class_3609 flowingFluid = (class_3609)fluid;
            flowingFluid.method_15730(levelAccessor, pos, blockState);
        }
        return levelAccessor.method_8652(pos, FFFluidUtils.getStateForFluidByAmount(fluid, newAmount).method_15759(), 3);
    }

    public static boolean removeAllFluidAtPos(class_1936 levelAccessor, class_2338 pos, class_3611 fluid) {
        class_2248 class_22482;
        class_2680 blockState = levelAccessor.method_8320(pos);
        if (blockState.method_26204() instanceof class_2402 && (class_22482 = blockState.method_26204()) instanceof class_2263) {
            class_2263 bucketPickup = (class_2263)class_22482;
            bucketPickup.method_9700(null, levelAccessor, pos, blockState);
            return true;
        }
        if (!blockState.method_26215() && fluid instanceof class_3609) {
            class_3609 flowingFluid = (class_3609)fluid;
            flowingFluid.method_15730(levelAccessor, pos, blockState);
        }
        return levelAccessor.method_8652(pos, class_2246.field_10124.method_9564(), 3);
    }

    public static int removeAmountFromFluidAtPosWithRemainder(class_1936 levelAccessor, class_2338 pos, class_3611 fluid, int removeAmount) {
        class_3610 state = levelAccessor.method_8316(pos);
        if (state.method_15772().method_15780(fluid)) {
            int currentAmount = state.method_15761();
            if (currentAmount <= removeAmount) {
                FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, fluid);
                return removeAmount - currentAmount;
            }
            FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, currentAmount - removeAmount);
            return 0;
        }
        return removeAmount;
    }

    public static int addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull(class_1936 levelAccessor, class_2338 pos, class_3609 fluid, int addAmount) {
        Pair<Integer, Runnable> data = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, pos, addAmount, fluid);
        if ((Integer)data.first() != addAmount) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return addAmount;
    }

    public static int addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull(class_1936 levelAccessor, class_2338 pos, class_3609 fluid, int addAmount, boolean canSpreadUp, boolean canSpreadDown) {
        Pair<Integer, Runnable> data = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, pos, addAmount, fluid, 80, canSpreadUp, canSpreadDown);
        if ((Integer)data.first() != addAmount) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return addAmount;
    }

    public static int addAmountToFluidAtPosWithRemainder(class_1936 levelAccessor, class_2338 pos, class_3611 fluid, int addAmount) {
        class_3610 state = levelAccessor.method_8316(pos);
        if (state.method_15769() || state.method_15772().method_15780(fluid)) {
            int currentAmount = state.method_15761();
            if (currentAmount == 8) {
                return addAmount;
            }
            if (currentAmount + addAmount <= 8) {
                if (FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, currentAmount + addAmount)) {
                    return 0;
                }
            } else if (FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, 8)) {
                return currentAmount + addAmount - 8;
            }
        }
        return addAmount;
    }

    public static boolean canFluidFlowFromPosToDirection(class_3609 fluid, int amount, class_1936 levelAccessor, class_2338 fromPos, class_2350 direction) {
        class_2338 blockPos2 = fromPos.method_10093(direction);
        class_2680 blockState2 = levelAccessor.method_8320(blockPos2);
        class_3610 fluidState2 = blockState2.method_26227();
        return FFFluidUtils.canFluidFlowFromPosToDirection(fluid, amount, (class_1922)levelAccessor, fromPos, levelAccessor.method_8320(fromPos), direction, blockPos2, blockState2, fluidState2);
    }

    public static boolean canFluidFlowFromPosToDirection(class_3609 sourceFluid, int sourceAmount, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_3610 fluidState2) {
        return (fluidState2.method_15764(blockGetter, blockPos2, (class_3611)sourceFluid, direction) || FFFluidUtils.canFitIntoFluid((class_3611)sourceFluid, fluidState2, direction, sourceAmount, blockState2)) && sourceFluid.method_15732(direction, blockGetter, blockPos, blockState, blockPos2, blockState2) && sourceFluid.method_15754(blockGetter, blockPos2, blockState2, (class_3611)sourceFluid);
    }

    public static boolean canFluidFlowFromPosToDirectionFitOverride(class_3609 sourceFluid, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_2350 direction, class_2338 blockPos2, class_2680 blockState2) {
        return sourceFluid.method_15732(direction, blockGetter, blockPos, blockState, blockPos2, blockState2) && sourceFluid.method_15754(blockGetter, blockPos2, blockState2, (class_3611)sourceFluid);
    }

    private static boolean canFitIntoFluid(class_3611 thisFluid, class_3610 fluidStateTo, class_2350 direction, int amount, class_2680 blockStateTo) {
        if (fluidStateTo.method_15769()) {
            return true;
        }
        if (fluidStateTo.method_15772().method_15780(thisFluid)) {
            if (direction == class_2350.field_11033) {
                return fluidStateTo.method_15761() < 8;
            }
            return fluidStateTo.method_15761() < amount;
        }
        return false;
    }

    public static Pair<Integer, Runnable> placeConnectedFluidAmountAndPlaceAction(class_1936 levelAccessor, class_2338 blockPos, int amountToPlace, class_3609 fluid) {
        return FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, blockPos, amountToPlace, fluid, 80, true, true);
    }

    public static Pair<Integer, Runnable> placeConnectedFluidAmountAndPlaceAction(class_1936 levelAccessor, class_2338 blockPos, int amountToPlace, class_3609 fluid, int depth, boolean doUp, boolean doDown) {
        class_3610 originalState = levelAccessor.method_8316(blockPos);
        int originalAmount = originalState.method_15761();
        if (originalState.method_15772().method_15780((class_3611)fluid) && originalAmount > 0) {
            if (originalAmount + amountToPlace <= 8) {
                return Pair.of((Object)0, () -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, blockPos, (class_3611)fluid, originalAmount + amountToPlace));
            }
            ArrayList<class_2338> toCheck = new ArrayList<class_2338>();
            toCheck.add(blockPos);
            Consumer<class_2338> addSurroundingPositions = blockPos1 -> {
                class_2338 down;
                class_2338 up;
                for (class_2350 direction : FFFluidUtils.getCardinalsShuffle(levelAccessor.method_8409())) {
                    class_2338 offset = blockPos1.method_10093(direction);
                    if (toCheck.contains(offset)) continue;
                    toCheck.add(offset);
                }
                if (doUp && !toCheck.contains(up = blockPos1.method_10084())) {
                    toCheck.add(up);
                }
                if (doDown && !toCheck.contains(down = blockPos1.method_10074())) {
                    toCheck.add(down);
                }
            };
            addSurroundingPositions.accept(blockPos);
            ArrayList<Runnable> onSuccessPlacers = new ArrayList<Runnable>();
            int amountLeftToPlace = amountToPlace;
            for (int i = 0; i < toCheck.size(); ++i) {
                class_2338 pos = (class_2338)toCheck.get(i);
                if (toCheck.size() > depth) break;
                class_3610 state = levelAccessor.method_8316(pos);
                if (!fluid.method_15780(state.method_15772()) && (!state.method_15769() || !levelAccessor.method_8320(pos).method_26215())) continue;
                int space = 8 - state.method_15761();
                if (space > 0) {
                    if (space >= amountLeftToPlace) {
                        int newAmount = state.method_15761() + amountLeftToPlace;
                        onSuccessPlacers.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (class_3611)fluid, newAmount));
                        amountLeftToPlace = 0;
                        break;
                    }
                    onSuccessPlacers.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (class_3611)fluid, 8));
                    amountLeftToPlace -= space;
                }
                addSurroundingPositions.accept(pos);
            }
            if (amountLeftToPlace == amountToPlace) {
                return Pair.of((Object)amountToPlace, null);
            }
            return Pair.of((Object)amountLeftToPlace, () -> onSuccessPlacers.forEach(Runnable::run));
        }
        return Pair.of((Object)amountToPlace, null);
    }

    public static int collectConnectedFluidAmountAndRemove(class_1936 levelAccessor, class_2338 blockPos, int minAmountRequired, int maxAmountToFind, class_3609 fluid) {
        Pair<Integer, Runnable> data = FFFluidUtils.collectConnectedFluidAmountAndRemoveAction(levelAccessor, blockPos, minAmountRequired, maxAmountToFind, fluid);
        if ((Integer)data.first() != 0) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return 0;
    }

    public static Pair<Integer, Runnable> collectConnectedFluidAmountAndRemoveAction(class_1936 levelAccessor, class_2338 blockPos, int minAmountRequired, int maxAmountToFind, class_3609 fluid) {
        return FFFluidUtils.collectConnectedFluidAmountAndRemoveAction(levelAccessor, blockPos, minAmountRequired, maxAmountToFind, fluid, 40);
    }

    public static Pair<Integer, Runnable> collectConnectedFluidAmountAndRemoveAction(class_1936 levelAccessor, class_2338 blockPos, int minAmountRequired, int maxAmountToFind, class_3609 fluid, int depth) {
        class_3610 originalState = levelAccessor.method_8316(blockPos);
        int originalAmount = originalState.method_15761();
        if (originalState.method_15772().method_15780((class_3611)fluid) && originalAmount > 0) {
            if (originalAmount >= maxAmountToFind) {
                return Pair.of((Object)maxAmountToFind, () -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, blockPos, (class_3611)fluid, originalAmount - maxAmountToFind));
            }
            ArrayList<class_2338> toCheck = new ArrayList<class_2338>();
            toCheck.add(blockPos);
            for (class_2350 direction : class_2350.method_42014((class_5819)levelAccessor.method_8409())) {
                class_2338 offset = blockPos.method_10093(direction);
                toCheck.add(offset);
            }
            ArrayList<Runnable> onSuccessAirSetters = new ArrayList<Runnable>();
            int foundAmount = 0;
            for (int i = 0; i < toCheck.size(); ++i) {
                int amount;
                class_2338 pos = (class_2338)toCheck.get(i);
                if (toCheck.size() > depth) break;
                class_3610 state = levelAccessor.method_8316(pos);
                if (!fluid.method_15780(state.method_15772()) || (amount = state.method_15761()) <= 0) continue;
                if ((foundAmount += amount) > maxAmountToFind) {
                    int finalLevel = foundAmount - maxAmountToFind;
                    onSuccessAirSetters.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (class_3611)fluid, finalLevel));
                    foundAmount = maxAmountToFind;
                    break;
                }
                onSuccessAirSetters.add(() -> FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, (class_3611)fluid));
                if (foundAmount == maxAmountToFind) break;
                for (class_2350 direction : class_2350.method_42014((class_5819)levelAccessor.method_8409())) {
                    class_2338 offset = pos.method_10093(direction);
                    if (toCheck.contains(offset)) continue;
                    toCheck.add(offset);
                }
            }
            if (foundAmount < minAmountRequired) {
                return Pair.of((Object)0, null);
            }
            return Pair.of((Object)foundAmount, () -> onSuccessAirSetters.forEach(Runnable::run));
        }
        return Pair.of((Object)0, null);
    }

    public static List<class_2350> getCardinalsShuffle(class_5819 random) {
        return class_2350.class_2353.field_11062.method_43342(random);
    }

    private static boolean checkBlockIsNonDisplacer(class_3611 fluid, class_2680 state) {
        return FlowingFluids.nonDisplacerTags.stream().anyMatch(pair -> (pair.first() == class_3612.field_15906 || ((class_3611)pair.first()).method_15780(fluid)) && state.method_26164((class_6862)pair.second())) || FlowingFluids.nonDisplacers.stream().anyMatch(pair -> (pair.first() == class_3612.field_15906 || ((class_3611)pair.first()).method_15780(fluid)) && state.method_27852((class_2248)pair.second()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void displaceFluids(class_1937 level, class_2338 pos, class_2680 state, int flags, class_2818 levelChunk, class_2680 originalState) {
        block10: {
            class_3611 class_36112;
            if (!level.method_8608() && FlowingFluids.config.enableMod && FlowingFluids.config.enableDisplacement && !FlowingFluids.isManeuveringFluids && !originalState.method_26227().method_15769() && (class_36112 = originalState.method_26227().method_15772()) instanceof class_3609) {
                class_3609 flowSource = (class_3609)class_36112;
                if (!(state.method_26215() || !state.method_26227().method_15769() || (flags & 0x40) == 64 || state.method_26204() instanceof class_2402 && originalState.method_26204() instanceof class_2263 || FFFluidUtils.checkBlockIsNonDisplacer((class_3611)flowSource, state))) {
                    FlowingFluids.isManeuveringFluids = true;
                    try {
                        int amountRemaining = originalState.method_26227().method_15761();
                        for (class_2350 direction : FFFluidUtils.getCardinalsShuffle(level.method_8409())) {
                            class_2338 offset = pos.method_10093(direction);
                            class_2680 offsetState = level.method_8320(offset);
                            if (offsetState.method_26227().method_15772() instanceof class_3609) {
                                if ((amountRemaining = FFFluidUtils.addAmountToFluidAtPosWithRemainder((class_1936)level, offset, (class_3611)flowSource, amountRemaining)) != 0) continue;
                                break;
                            }
                            if (!offsetState.method_26215()) continue;
                            level.method_8652(offset, originalState.method_26227().method_15759(), 3);
                            amountRemaining = 0;
                            break;
                        }
                        if (amountRemaining <= 0) break block10;
                        class_2338.class_2339 posTraversing = new class_2338.class_2339(pos.method_10263(), pos.method_10264(), pos.method_10260());
                        int height = levelChunk.method_31600();
                        while (amountRemaining > 0 && posTraversing.method_10264() < height) {
                            posTraversing.method_10098(class_2350.field_11036);
                            class_2680 offsetState = level.method_8320((class_2338)posTraversing);
                            if (offsetState.method_26227().method_15772() instanceof class_3609) {
                                amountRemaining = FFFluidUtils.addAmountToFluidAtPosWithRemainder((class_1936)level, (class_2338)posTraversing, (class_3611)flowSource, amountRemaining);
                                continue;
                            }
                            if (offsetState.method_26215()) {
                                level.method_8652((class_2338)posTraversing, originalState.method_26227().method_15759(), 3);
                                amountRemaining = 0;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        FlowingFluids.isManeuveringFluids = false;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchInfiniteBiomes(class_6880<class_1959> biome) {
        if (FlowingFluids.infiniteBiomeTags.stream().anyMatch(arg_0 -> biome.method_40220(arg_0))) return true;
        if (!FlowingFluids.infiniteBiomes.stream().anyMatch(arg_0 -> biome.method_40225(arg_0))) return false;
        return true;
    }
}

