/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.Pair;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import traben.flowing_fluids.FlowingFluidsPlatform;
import traben.flowing_fluids.config.FFConfig;

public final class FlowingFluids {
    public static final String MOD_ID = "flowing_fluids";
    public static final Logger LOG = LoggerFactory.getLogger((String)"FlowingFluids");
    public static boolean isManeuveringFluids = false;
    public static boolean pistonTick = false;
    public static long debug_killFluidUpdatesUntilTime = 0L;
    public static int waterPluggedThisSession = 0;
    public static Set<Pair<class_3611, class_6862<class_2248>>> nonDisplacerTags = new HashSet<Pair<class_3611, class_6862<class_2248>>>();
    public static Set<Pair<class_3611, class_2248>> nonDisplacers = new HashSet<Pair<class_3611, class_2248>>();
    public static Set<class_6862<class_1959>> infiniteBiomeTags = new HashSet<class_6862<class_1959>>();
    public static Set<class_5321<class_1959>> infiniteBiomes = new HashSet<class_5321<class_1959>>();
    public static FFConfig config = new FFConfig();

    public static void info(String str) {
        LOG.info("[Flowing Fluids] {}", (Object)str);
    }

    public static void warn(String str) {
        LOG.warn("[Flowing Fluids] {}", (Object)str);
    }

    public static void error(String str) {
        LOG.error("[Flowing Fluids] {}", (Object)str);
    }

    public static void init() {
        FlowingFluids.info("initialising");
        infiniteBiomeTags.add((class_6862<class_1959>)class_6908.field_36509);
        infiniteBiomeTags.add((class_6862<class_1959>)class_6908.field_36511);
        infiniteBiomeTags.add((class_6862<class_1959>)class_6908.field_36510);
        infiniteBiomes.add((class_5321<class_1959>)class_1972.field_9471);
        infiniteBiomes.add((class_5321<class_1959>)class_1972.field_38748);
        nonDisplacerTags.add((Pair<class_3611, class_6862<class_2248>>)Pair.of((Object)class_3612.field_15910, (Object)class_3481.field_15467));
        nonDisplacers.add((Pair<class_3611, class_2248>)Pair.of((Object)class_3612.field_15910, (Object)class_2246.field_10258));
        nonDisplacers.add((Pair<class_3611, class_2248>)Pair.of((Object)class_3612.field_15908, (Object)class_2246.field_10540));
        FlowingFluids.loadConfig();
    }

    public static void loadConfig() {
        File configFile = new File(FlowingFluidsPlatform.getConfigDirectory().toFile(), "flowing_fluids.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                config = (FFConfig)gson.fromJson((Reader)fileReader, FFConfig.class);
                fileReader.close();
            }
            catch (IOException iOException) {}
        } else {
            config = new FFConfig();
            FlowingFluids.saveConfig();
        }
    }

    public static void saveConfig() {
        File configFile = new File(FlowingFluidsPlatform.getConfigDirectory().toFile(), "flowing_fluids.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdirs();
        }
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            fileWriter.write(gson.toJson((Object)config));
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

