/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import traben.flowing_fluids.FlowingFluids;

public class PlugWaterFeature {
    private static final Pair<Boolean, Runnable> defTrue = Pair.of((Object)true, null);
    private static final class_2350[] dirs = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11033};

    public static Set<class_2338> findBlocks(class_2791 chunkAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        HashSet<class_2338> set = new HashSet<class_2338>();
        for (int i = chunkAccess.method_32891(); i < chunkAccess.method_31597(); ++i) {
            class_2826 levelChunkSection = chunkAccess.method_38259(chunkAccess.method_31603(i));
            if (!levelChunkSection.method_19523(PlugWaterFeature::isFluidSource)) continue;
            class_2338 blockPos = class_4076.method_18681((class_1923)chunkAccess.method_12004(), (int)i).method_19767();
            for (int y = y1; y < y2; ++y) {
                for (int z = z1; z < z2; ++z) {
                    for (int x = x1; x < x2; ++x) {
                        class_2680 blockState = levelChunkSection.method_12254(x, y, z);
                        if (!PlugWaterFeature.isFluidSource(blockState)) continue;
                        set.add(mutableBlockPos.method_25504((class_2382)blockPos, x, y, z).method_10062());
                    }
                }
            }
        }
        return set;
    }

    public static void processChunk(class_1936 level, class_1923 chunk, class_2791 chunkAccess) {
        boolean hasXNeg = level.method_8393(chunk.field_9181 - 1, chunk.field_9180);
        boolean hasXPos = level.method_8393(chunk.field_9181 + 1, chunk.field_9180);
        boolean hasZNeg = level.method_8393(chunk.field_9181, chunk.field_9180 - 1);
        boolean hasZPos = level.method_8393(chunk.field_9181, chunk.field_9180 + 1);
        Set<class_2338> set = PlugWaterFeature.findBlocks(chunkAccess, 0, 0, 0, 16, 16, 16);
        if (hasXNeg) {
            set.addAll(PlugWaterFeature.findBlocks(level.method_8392(chunk.field_9181 - 1, chunk.field_9180), 15, 0, 0, 16, 16, 16));
        }
        if (hasXPos) {
            set.addAll(PlugWaterFeature.findBlocks(level.method_8392(chunk.field_9181 + 1, chunk.field_9180), 0, 0, 0, 1, 16, 16));
        }
        if (hasZNeg) {
            set.addAll(PlugWaterFeature.findBlocks(level.method_8392(chunk.field_9181, chunk.field_9180 - 1), 0, 0, 15, 16, 16, 16));
        }
        if (hasZPos) {
            set.addAll(PlugWaterFeature.findBlocks(level.method_8392(chunk.field_9181, chunk.field_9180 + 1), 0, 0, 0, 16, 16, 1));
        }
        if (set.isEmpty()) {
            return;
        }
        int minx = chunk.method_8326();
        int minz = chunk.method_8328();
        int maxx = chunk.method_8327();
        int maxz = chunk.method_8329();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int sea = level.method_8615() - 5;
        HashSet doneSet = new HashSet();
        Supplier<Pair> testDo = () -> {
            if (mutableBlockPos.method_10263() < minx || mutableBlockPos.method_10263() > maxx) {
                return defTrue;
            }
            if (mutableBlockPos.method_10260() < minz || mutableBlockPos.method_10260() > maxz) {
                return defTrue;
            }
            if (set.contains(mutableBlockPos)) {
                return defTrue;
            }
            class_2680 blockState = chunkAccess.method_8320((class_2338)mutableBlockPos);
            if (blockState.method_26215() && blockState.method_26227().method_15769()) {
                class_2338 immutable = mutableBlockPos.method_10062();
                doneSet.add(immutable);
                return Pair.of((Object)false, () -> PlugWaterFeature.fillBlock(chunkAccess, immutable, sea));
            }
            return null;
        };
        ArrayList<Runnable> runs = new ArrayList<Runnable>();
        for (class_2338 blockPos : set) {
            if (doneSet.contains(blockPos)) continue;
            boolean neighbourWater = false;
            runs.clear();
            for (class_2350 dir : dirs) {
                mutableBlockPos.method_25505((class_2382)blockPos, dir);
                Pair result = testDo.get();
                if (result == null) continue;
                if (((Boolean)result.first()).booleanValue()) {
                    neighbourWater = true;
                    continue;
                }
                runs.add((Runnable)result.second());
            }
            if (!neighbourWater) continue;
            for (Runnable run : runs) {
                run.run();
            }
        }
    }

    private static boolean isFluidSource(class_2680 state) {
        class_3610 fluid = state.method_26227();
        if (fluid.method_15769() || !fluid.method_15771()) {
            return false;
        }
        return FlowingFluids.config.isFluidAllowed(fluid);
    }

    private static void fillBlock(class_2791 chunk, class_2338 pos, int seaLevel) {
        class_6880 biome = chunk.method_16359(pos.method_10263(), pos.method_10264(), pos.method_10260());
        class_2680 blockState = biome.method_40220(class_6908.field_36518) ? class_2246.field_10515.method_9564() : (biome.method_40220(class_6908.field_37394) ? class_2246.field_10471.method_9564() : (pos.method_10264() < 0 ? class_2246.field_28888.method_9564() : (pos.method_10264() < seaLevel ? class_2246.field_10340.method_9564() : (biome.method_40220(class_6908.field_36496) || biome.method_40220(class_6908.field_36510) || biome.method_40220(class_6908.field_36509) ? class_2246.field_10102.method_9564() : class_2246.field_37576.method_9564()))));
        if (FlowingFluids.config.announceWorldGenActions) {
            FlowingFluids.info("placed block during world gen: " + String.valueOf(blockState) + " at /tp @s " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260());
        }
        ++FlowingFluids.waterPluggedThisSession;
        chunk.method_12010(pos, blockState, false);
    }
}

