/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.api;

import it.unimi.dsi.fastutil.Pair;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.FlowingFluidsPlatform;
import traben.flowing_fluids.api.FlowingFluidsAPI;
import traben.flowing_fluids.config.FFConfig;

public class FlowingFluidsApiImpl
implements FlowingFluidsAPI {
    private final String modid;

    FlowingFluidsApiImpl(String modIdRequestingAPI) {
        this.modid = modIdRequestingAPI;
    }

    @Override
    public boolean isModEnabled() {
        return this.getConfig().enableMod;
    }

    @Override
    public boolean isModCurrentlyMovingFluids() {
        return FlowingFluids.isManeuveringFluids;
    }

    @Override
    public boolean doesModifyThisFluid(@NotNull class_3611 fluid) {
        return this.getConfig().isFluidAllowed(fluid);
    }

    @Override
    public boolean doesModifyThisFluid(@NotNull class_3610 fluid) {
        return this.getConfig().isFluidAllowed(fluid);
    }

    @Override
    public void disableThisFluid(@NotNull class_3611 fluid, @Nullable MinecraftServer server) {
        if (fluid == class_3612.field_15906) {
            return;
        }
        class_3609 flowing = this.fluidCheck(fluid, "disableThisFluid");
        if (flowing == null) {
            return;
        }
        this.getConfig().fluidBlacklist.add((Object)class_7923.field_41173.method_10221((Object)flowing.method_15751()).toString());
        this.getConfig().fluidBlacklist.add((Object)class_7923.field_41173.method_10221((Object)flowing.method_15750()).toString());
        this.setConfig(this.getConfig(), server);
    }

    @Override
    public void disableThisFluid(@NotNull class_3610 fluid, @Nullable MinecraftServer server) {
        this.disableThisFluid(fluid.method_15772(), server);
    }

    @Override
    public void enableThisFluid(@NotNull class_3611 fluid, @Nullable MinecraftServer server) {
        if (fluid == class_3612.field_15906) {
            return;
        }
        class_3609 flowing = this.fluidCheck(fluid, "enableThisFluid");
        if (flowing == null) {
            return;
        }
        this.getConfig().fluidBlacklist.remove((Object)class_7923.field_41173.method_10221((Object)flowing.method_15751()).toString());
        this.getConfig().fluidBlacklist.remove((Object)class_7923.field_41173.method_10221((Object)flowing.method_15750()).toString());
        this.setConfig(this.getConfig(), server);
    }

    @Override
    public void enableThisFluid(@NotNull class_3610 fluid, @Nullable MinecraftServer server) {
        this.enableThisFluid(fluid.method_15772(), server);
    }

    @Override
    public FFConfig getConfig() {
        return FlowingFluids.config;
    }

    @Override
    public void setConfig(@NotNull FFConfig config, @Nullable MinecraftServer server) {
        FlowingFluids.config = config;
        FlowingFluids.saveConfig();
        if (server != null) {
            FlowingFluids.info("Flowing Fluids config was changed by the " + this.modid + " mod, and will be applied to the server.");
            server.method_3760().method_14571().forEach(FlowingFluidsPlatform::sendConfigToClient);
        } else {
            FlowingFluids.warn("Flowing Fluids config was changed by the " + this.modid + " mod, but no server was provided. This will only modify the local config for single-player etc.");
        }
    }

    private boolean clientCheck(class_1936 level, String str) {
        if (level.method_8608()) {
            FlowingFluids.warn("Flowing Fluids API: " + str + " was called on a client side level. This does nothing. Mod that called it: " + this.modid);
            return true;
        }
        return false;
    }

    @Nullable
    private class_3609 fluidCheck(class_3611 fluid, String str) {
        if (fluid instanceof class_3609) {
            class_3609 flowing = (class_3609)fluid;
            return flowing;
        }
        FlowingFluids.warn("Flowing Fluids API: " + str + " was called on a non-flowing fluid. This is not allowed. Mod that called it: " + this.modid);
        return null;
    }

    @Override
    public int removeFluidAmountFromPos(@NotNull class_1936 level, @NotNull class_2338 startPos, @NotNull class_3611 fluid, int minAmount, int maxAmount) {
        if (this.clientCheck(level, "removeFluidAmountFromPos")) {
            return 0;
        }
        class_3609 flowing = this.fluidCheck(fluid, "removeFluidAmountFromPos");
        if (flowing == null) {
            return 0;
        }
        return FFFluidUtils.collectConnectedFluidAmountAndRemove(level, startPos, minAmount, maxAmount, flowing);
    }

    @Override
    public int placeFluidAmountFromPos(@NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_3611 fluid, int amount, boolean canSpreadUp, boolean canSpreadDown) {
        if (this.clientCheck(level, "placeFluidAmountFromPos")) {
            return amount;
        }
        class_3609 flowing = this.fluidCheck(fluid, "placeFluidAmountFromPos");
        if (flowing == null) {
            return 0;
        }
        return FFFluidUtils.addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull(level, pos, flowing, amount, canSpreadUp, canSpreadDown);
    }

    @Override
    public void registerBlockTagThatWontDisplaceFluid(@NotNull class_3611 fluid, @NotNull class_6862<class_2248> tag) {
        FlowingFluids.nonDisplacerTags.add((Pair<class_3611, class_6862<class_2248>>)Pair.of((Object)fluid, tag));
    }

    @Override
    public void registerBlockThatWontDisplaceFluid(@NotNull class_3611 fluid, @NotNull class_2248 block) {
        FlowingFluids.nonDisplacers.add((Pair<class_3611, class_2248>)Pair.of((Object)fluid, (Object)block));
    }

    @Override
    public void registerBiomeTagThatHasInfiniteWaterRefilling(@NotNull class_6862<class_1959> tag) {
        FlowingFluids.infiniteBiomeTags.add(tag);
    }

    @Override
    public void registerBiomeThatHasInfiniteWaterRefilling(@NotNull class_5321<class_1959> biome) {
        FlowingFluids.infiniteBiomes.add(biome);
    }

    @Override
    public boolean doesBiomeInfiniteWaterRefill(@NotNull class_6880<class_1959> biome) {
        return FFFluidUtils.matchInfiniteBiomes(biome);
    }

    @Override
    public boolean modifyFluidAmountAtPos(@NotNull class_1936 level, @NotNull class_2338 pos, @NotNull FlowingFluidsAPI.FluidAmountModifier fluidAmountModifier) {
        if (this.clientCheck(level, "modifyFluidAmountAtPos")) {
            return false;
        }
        class_3610 fluid = level.method_8316(pos);
        if (this.getConfig().isFluidAllowed(fluid)) {
            int amount;
            class_3611 type = fluid.method_15772();
            Pair<class_3611, Integer> data = fluidAmountModifier.getNewAmount(type, amount = fluid.method_15761());
            if (data.first() == type && (Integer)data.second() == amount) {
                return false;
            }
            return FFFluidUtils.setFluidStateAtPosToNewAmount(level, pos, (class_3611)data.first(), class_3532.method_15340((int)((Integer)data.second()), (int)0, (int)8));
        }
        return false;
    }

    @Override
    public boolean modifyFluidAmountAtPos(@NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_3611 type, int amount) {
        if (this.clientCheck(level, "modifyFluidAmountAtPos")) {
            return false;
        }
        if (this.getConfig().isFluidAllowed(type)) {
            return FFFluidUtils.setFluidStateAtPosToNewAmount(level, pos, type, class_3532.method_15340((int)amount, (int)0, (int)8));
        }
        return false;
    }
}

