/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2257;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.FlowingFluidsPlatform;
import traben.flowing_fluids.PlugWaterFeature;
import traben.flowing_fluids.config.FFConfig;

public class FFCommands {
    private static int messageAndSaveConfig(CommandContext<class_2168> context, String text) {
        FlowingFluids.saveConfig();
        ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(FlowingFluidsPlatform::sendConfigToClient);
        return FFCommands.message(context, text);
    }

    private static int message(CommandContext<class_2168> context, String text) {
        String inputCommand = context.getInput();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\n\u00a77\u00a7o/" + inputCommand + "\u00a7r\n" + text + "\n\u00a77_____________________________")));
        return 1;
    }

    private static LiteralArgumentBuilder<class_2168> floatChanceCommand(String name, String description, Consumer<Float> setter, Supplier<Float> getter) {
        return FFCommands.floatCommand(name, description, "chance", 0.0f, 1.0f, setter, getter);
    }

    private static LiteralArgumentBuilder<class_2168> floatCommand(String name, String description, String argName, float min, float max, Consumer<Float> setter, Supplier<Float> getter) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, description + "\nCurrent value of " + name + " = " + String.valueOf(getter.get())))).then(class_2170.method_9244((String)argName, (ArgumentType)FloatArgumentType.floatArg((float)min, (float)max)).executes(cont -> {
            setter.accept((Float)cont.getArgument(argName, Float.class));
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, name + " set to " + String.valueOf(getter.get()));
        }));
    }

    private static LiteralArgumentBuilder<class_2168> intCommand(String name, String description, String argName, int min, int max, Consumer<Integer> setter, Supplier<Integer> getter) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, description + "\nCurrent value of " + name + " = " + String.valueOf(getter.get())))).then(class_2170.method_9244((String)argName, (ArgumentType)IntegerArgumentType.integer((int)min, (int)max)).executes(cont -> {
            setter.accept((Integer)cont.getArgument(argName, Integer.class));
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, name + " set to " + String.valueOf(getter.get()));
        }));
    }

    private static LiteralArgumentBuilder<class_2168> booleanCommand(String name, String description, BooleanConsumer setter, BooleanSupplier getter) {
        return FFCommands.booleanCommand(name, description, name + " setting is now: On.", name + " setting is now: Off.", setter, getter);
    }

    private static LiteralArgumentBuilder<class_2168> booleanCommand(String name, String description, String messageOn, String messageOff, BooleanConsumer setter, BooleanSupplier getter) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, description + "\n" + name + " is currently set to: " + (getter.getAsBoolean() ? "on" : "off")))).then(class_2170.method_9247((String)"on").executes(cont -> {
            setter.accept(true);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, messageOn);
        }))).then(class_2170.method_9247((String)"off").executes(cont -> {
            setter.accept(false);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, messageOff);
        }));
    }

    @SafeVarargs
    private static <E extends Enum<E>> LiteralArgumentBuilder<class_2168> enumCommand(String name, String description, Consumer<E> setter, Supplier<E> getter, Pair<E, String> ... options) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)name).executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, description + "\n" + name + " is currently set to: " + ((Enum)getter.get()).toString().toLowerCase()));
        for (Pair<E, String> option : options) {
            String message = (String)option.getSecond();
            Enum enumVal = (Enum)option.getFirst();
            command.then(class_2170.method_9247((String)enumVal.toString().toLowerCase()).executes(cont -> {
                setter.accept(enumVal);
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, message);
            }));
        }
        return command;
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 var3) {
        SimpleCommandExceptionType notFluidException = new SimpleCommandExceptionType((Message)new LiteralMessage("The block you provided is not a fluid block, or is not a fluid block that can flow."));
        LiteralArgumentBuilder commands = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"flowing_fluids").requires(source -> source.method_9259(4) || source.method_9211().method_3724() && source.method_44023() != null && source.method_9211().method_19466(source.method_44023().method_7334()))).then(class_2170.method_9247((String)"help").executes(c -> FFCommands.message((CommandContext<class_2168>)c, "Use any of the commands without adding any of it's arguments, E.G '/flowing_fluids settings', to get a description of what the command does and it's current value.")))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").executes(commandContext -> FFCommands.message((CommandContext<class_2168>)commandContext, "Settings for Flowing Fluids, use these to change how fluids behave."))).then(FFCommands.booleanCommand("plug_fluids_during_world_gen", "Enables or disables plugging all fluids that are generated with air beside or below them.\nThis is an IMMENSE reduction in lag during world generation.", "World gen fluid plugging is now enabled.", "World gen fluid plugging is now disabled.", a -> {
            FlowingFluids.config.encloseAllFluidOnWorldGen = a;
        }, () -> FlowingFluids.config.encloseAllFluidOnWorldGen))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ignored_fluids").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Control which fluids do or do not get affected by this mod."))).then(class_2170.method_9247((String)"list").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "The following fluids are currently ignored by Flowing Fluids: " + String.valueOf(FlowingFluids.config.fluidBlacklist))))).then(class_2170.method_9247((String)"list_all_fluid_names").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "This is a list of all registered fluids as Flowing Fluids knows them: " + String.valueOf(class_7923.field_41173.method_10220().map(fluid -> class_7923.field_41173.method_10221(fluid).toString()).collect(Collectors.toCollection(HashSet::new))))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"fluid", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).executes(cont -> {
            class_3611 patt0$temp;
            class_3610 fluidState = class_2257.method_9655((CommandContext)cont, (String)"fluid").method_9494().method_26227();
            if (fluidState.method_15769() || !((patt0$temp = fluidState.method_15772()) instanceof class_3609)) {
                throw notFluidException.create();
            }
            class_3609 flows = (class_3609)patt0$temp;
            String source = class_7923.field_41173.method_10221((Object)flows.method_15751()).toString();
            FlowingFluids.config.fluidBlacklist.add((Object)source);
            String flowing = class_7923.field_41173.method_10221((Object)flows.method_15750()).toString();
            FlowingFluids.config.fluidBlacklist.add((Object)flowing);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Added the fluids " + source + " and " + flowing + " to the ignored fluids list. The list is now: " + String.valueOf(FlowingFluids.config.fluidBlacklist));
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"fluid", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).executes(cont -> {
            class_3611 patt0$temp;
            class_3610 fluidState = class_2257.method_9655((CommandContext)cont, (String)"fluid").method_9494().method_26227();
            if (fluidState.method_15769() || !((patt0$temp = fluidState.method_15772()) instanceof class_3609)) {
                throw notFluidException.create();
            }
            class_3609 flows = (class_3609)patt0$temp;
            String source = class_7923.field_41173.method_10221((Object)flows.method_15751()).toString();
            FlowingFluids.config.fluidBlacklist.remove((Object)source);
            String flowing = class_7923.field_41173.method_10221((Object)flows.method_15750()).toString();
            FlowingFluids.config.fluidBlacklist.remove((Object)flowing);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Removed the fluids " + source + " and " + flowing + " from the ignored fluids list. The list is now: " + String.valueOf(FlowingFluids.config.fluidBlacklist));
        }))))).then(class_2170.method_9247((String)"reset_all_to_defaults").executes(cont -> {
            FlowingFluids.config = new FFConfig();
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "All Flowing Fluids settings have been reset to defaults.");
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"appearance").executes(commandContext -> FFCommands.message((CommandContext<class_2168>)commandContext, "Appearance settings for Flowing Fluids, use these to change how fluids appear."))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"flowing_texture").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "The flowing fluid texture is currently " + (FlowingFluids.config.hideFlowingTexture ? "hidden." : "shown.") + "\n This will make the fluids surface appear more still and less flickery while settling, this might conflict with mods affecting fluid rendering"))).then(class_2170.method_9247((String)"hidden").executes(cont -> {
            FlowingFluids.config.hideFlowingTexture = true;
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Flowing fluid texture is now hidden.\nLiquids will no longer show the flowing texture on their surface.");
        }))).then(class_2170.method_9247((String)"shown").executes(cont -> {
            FlowingFluids.config.hideFlowingTexture = false;
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Flowing fluid texture is now visible.\nLiquids will now show the flowing texture on their surface.");
        }))))).then(FFCommands.booleanCommand("enable_mod", "Enables or disables the mod, if disabled the mod will not affect any fluids.", "FlowingFluids is now enabled, liquids will now have physics.", "FlowingFluids is now disabled, vanilla liquid behaviour will be restored, Buckets will retain their partial fill amount until used.", a -> {
            FlowingFluids.config.enableMod = a;
        }, () -> FlowingFluids.config.enableMod))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"behaviour").executes(commandContext -> FFCommands.message((CommandContext<class_2168>)commandContext, "Behaviour settings for Flowing Fluids, use these to change how fluids behave."))).then(FFCommands.intCommand("min_level_for_ice", "Controls the minimum level of water that will freeze, this is useful for making ice form in partial height water.\nThe default value is 4, and the maximum value is 8.", "level", 0, 8, a -> {
            FlowingFluids.config.minWaterLevelForIce = a;
        }, () -> FlowingFluids.config.minWaterLevelForIce))).then(FFCommands.intCommand("fluid_processing_distance", "Allows you to set a block distance for fluid processing, works kinda like render distance but for fluid flowing.\n0 means infinite distance (works with chunk loaders far from players).\nThe default value is 0, and the maximum value is 256 (though it is limited by the servers processing chunk distance).\nPlease note this only affects the flowing calculation and refilling behaviours like rain.", "distance_in_blocks", 0, 256, a -> {
            FlowingFluids.config.playerBlockDistanceForFlowing = a;
        }, () -> FlowingFluids.config.playerBlockDistanceForFlowing))).then(FFCommands.intCommand("min_level_for_obsidian", "Controls the minimum level of lava that will convert to obsidian, this is useful for making obsidian form more consistently.\nThe default value is 6, and the maximum value is 8.", "level", 0, 8, a -> {
            FlowingFluids.config.minLavaLevelForObsidian = a;
        }, () -> FlowingFluids.config.minLavaLevelForObsidian))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"random_tick_level_check_distance").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Sets the distance fluids will check for other fluids to level with during random ticks, 0 means disabled, currently set to " + FlowingFluids.config.randomTickLevelingDistance))).then(class_2170.method_9244((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)64)).executes(cont -> {
            FlowingFluids.config.randomTickLevelingDistance = (Integer)cont.getArgument("distance", Integer.class);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Random tick level check distance set to " + FlowingFluids.config.randomTickLevelingDistance);
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"how_liquids_affect_entities").then(FFCommands.booleanCommand("flow_pushes_boats", "Controls if boats are pushed by the flow angle that water visually has at the surface.\nTHIS MUST BE OFF FOR BOATS TO WORK PROPERLY IN PARTIAL HEIGHT FLUIDS!!!", "Boats will now be affected by water flow, THIS WILL BREAK BOATS!! they will not function correctly in partial height water", "Boats will no longer be affected by water flow. This will fix boats not working in partial height water.", a -> {
            FlowingFluids.config.waterFlowAffectsBoats = a;
        }, () -> FlowingFluids.config.waterFlowAffectsBoats))).then(FFCommands.booleanCommand("flow_pushes_players", "Controls if players are pushed by the flow angle that water visually has at the surface.", a -> {
            FlowingFluids.config.waterFlowAffectsPlayers = a;
        }, () -> FlowingFluids.config.waterFlowAffectsPlayers))).then(FFCommands.booleanCommand("flow_pushes_entities", "Controls if entities are pushed by the flow angle that water visually has at the surface.\nEXCEPT players, boats, and item entities, they have their own settings.", a -> {
            FlowingFluids.config.waterFlowAffectsEntities = a;
        }, () -> FlowingFluids.config.waterFlowAffectsEntities))).then(FFCommands.booleanCommand("flow_pushes_items", "Controls if item entities are pushed by the flow angle that water visually has at the surface.", a -> {
            FlowingFluids.config.waterFlowAffectsItems = a;
        }, () -> FlowingFluids.config.waterFlowAffectsItems)))).then(FFCommands.enumCommand("fluid_height", "Changes the heights fluids render/affect entities at, currently set to " + String.valueOf((Object)FlowingFluids.config.fullLiquidHeight) + ".", a -> {
            FlowingFluids.config.fullLiquidHeight = a;
        }, () -> FlowingFluids.config.fullLiquidHeight, Pair.of((Object)((Object)FFConfig.LiquidHeight.REGULAR), (Object)"Fluids now render/affect entities up to regular height."), Pair.of((Object)((Object)FFConfig.LiquidHeight.REGULAR_LOWER_BOUND), (Object)"Fluids now render/affect entities up to their regular height but will be almost flat at their lowest amount."), Pair.of((Object)((Object)FFConfig.LiquidHeight.BLOCK_LOWER_BOUND), (Object)"Fluids now render/affect entities up to block height but will be almost flat at their lowest amount."), Pair.of((Object)((Object)FFConfig.LiquidHeight.BLOCK), (Object)"Fluids now render/affect entities up to block height."), Pair.of((Object)((Object)FFConfig.LiquidHeight.SLAB), (Object)"Fluids now render/affect entities up to half a block height."), Pair.of((Object)((Object)FFConfig.LiquidHeight.CARPET), (Object)"All Fluids now render/affect entities with 1 pixel height.")))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"flow_distances").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Modifies the distance fluids will search for slopes to flow down.\nThe vanilla value is always 4 for water but lava will vary between 2 and 4 depending on if it is in the Nether.\n\u00a74WARNING: this setting is the biggest source of lag for all fluid flowing, this value is limited to 8 (as any higher will freeze your world) and I strongly suggest you never raise it above the default 4."))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"water").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Modifies the distance water will search for slopes to flow down.\nThe vanilla value is always 4 for water.\nWater flow distance modifier is currently set to " + FlowingFluids.config.waterFlowDistance))).then(class_2170.method_9244((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)8)).executes(cont -> {
            FlowingFluids.config.waterFlowDistance = (Integer)cont.getArgument("distance", Integer.class);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water flow distance set to " + FlowingFluids.config.waterFlowDistance);
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lava").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Modifies the distance lava will search for slopes to flow down in the overworld.\nThe vanilla value is always 2 for lava in the overworld.\nLava flow distance modifier is currently set to " + FlowingFluids.config.lavaFlowDistance))).then(class_2170.method_9244((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)8)).executes(cont -> {
            FlowingFluids.config.lavaFlowDistance = (Integer)cont.getArgument("distance", Integer.class);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water flow distance set to " + FlowingFluids.config.lavaFlowDistance);
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lava_nether").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Modifies the distance lava will search for slopes to flow down in the nether.\nThe vanilla value is always 4 for lava in the nether.\nLava flow distance modifier is currently set to " + FlowingFluids.config.lavaNetherFlowDistance))).then(class_2170.method_9244((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)8)).executes(cont -> {
            FlowingFluids.config.lavaNetherFlowDistance = (Integer)cont.getArgument("distance", Integer.class);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water flow distance set to " + FlowingFluids.config.lavaNetherFlowDistance);
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tick_delays__aka__flow_speeds").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Modifies the tick delay fluids will have between spreading updates\nThe vanilla value is always 5 for water but lava will vary between 10 and 30 depending on if it is in the Nether."))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"water").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Modifies the tick delay water will have between spreading updates.\nThe vanilla value is always 5 for water.\nWater tick delay modifier is currently set to " + FlowingFluids.config.waterTickDelay))).then(class_2170.method_9244((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(cont -> {
            FlowingFluids.config.waterTickDelay = (Integer)cont.getArgument("delay", Integer.class);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water tick delay set to " + FlowingFluids.config.waterTickDelay);
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lava").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Modifies the tick delay lava will have between spreading updates in the overworld.\nThe vanilla value is always 30 for lava in the overworld.\nLava tick delay modifier is currently set to " + FlowingFluids.config.lavaTickDelay))).then(class_2170.method_9244((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(cont -> {
            FlowingFluids.config.lavaTickDelay = (Integer)cont.getArgument("delay", Integer.class);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Lava tick delay set to " + FlowingFluids.config.lavaTickDelay);
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lava_nether").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Modifies the tick delay lava will have between spreading updates in the nether.\nThe vanilla value is always 10 for lava in the nether.\nLava tick delay modifier is currently set to " + FlowingFluids.config.lavaNetherTickDelay))).then(class_2170.method_9244((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(cont -> {
            FlowingFluids.config.lavaNetherTickDelay = (Integer)cont.getArgument("delay", Integer.class);
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Lava_nether tick delay set to " + FlowingFluids.config.lavaNetherTickDelay);
        }))))).then(FFCommands.booleanCommand("pistons_push_fluids", "Enables or disables piston pushing, if disabled pistons will no longer push fluids.", "Piston pushing is now enabled.\nLiquids will now be pushed by pistons.", "Piston pushing is now disabled.\nLiquids will no longer be pushed by pistons.", a -> {
            FlowingFluids.config.enablePistonPushing = a;
        }, () -> FlowingFluids.config.enablePistonPushing))).then(FFCommands.booleanCommand("easy_piston_pumps", "Makes fluids above pistons delay their falling to make pumping upwards much easier.", a -> {
            FlowingFluids.config.easyPistonPump = a;
        }, () -> FlowingFluids.config.easyPistonPump))).then(FFCommands.booleanCommand("placed_blocks_displace_fluids", "Enables or disables placed blocks displacing fluids, if disabled placed blocks will no longer displace fluids.", "Placed blocks displacing fluids is now enabled.\nLiquids will now be displaced by blocks placed inside them.", "Placed blocks displacing fluids is now disabled.\nLiquids will no longer be displaced by blocks placed inside them.", a -> {
            FlowingFluids.config.enableDisplacement = a;
        }, () -> FlowingFluids.config.enableDisplacement))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"waterlogged_blocks_flow_mode").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Controls how water flows into or out fo water loggable blocks, due to limitations you cannot have two side by side waterloggable blocks flow into each other as they would flicker endlessly, Sea grass and kelp are excluded from this setting and will always break in waters absence, current setting: " + String.valueOf((Object)FlowingFluids.config.waterLogFlowMode)))).then(class_2170.method_9247((String)"only_in").executes(cont -> {
            FlowingFluids.config.waterLogFlowMode = FFConfig.WaterLogFlowMode.ONLY_IN;
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water will only flow into water loggable blocks, and never out of them.");
        }))).then(class_2170.method_9247((String)"only_out").executes(cont -> {
            FlowingFluids.config.waterLogFlowMode = FFConfig.WaterLogFlowMode.ONLY_OUT;
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water will only flow out of water loggable blocks, and never into them.");
        }))).then(class_2170.method_9247((String)"in_from_sides_or_top_out_down").executes(cont -> {
            FlowingFluids.config.waterLogFlowMode = FFConfig.WaterLogFlowMode.OUT_DOWN_ELSE_IN;
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water will flow into water loggable blocks from the sides or top, and out of them from the bottom, if possible.");
        }))).then(class_2170.method_9247((String)"ignore").executes(cont -> {
            FlowingFluids.config.waterLogFlowMode = FFConfig.WaterLogFlowMode.IGNORE;
            return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water flowing will ignore water loggable blocks entirely.");
        })))).then(FFCommands.booleanCommand("flow_over_edges", "Controls if liquids flow over nearby edges, or will stay at the ledge.", "Liquids at their minimum height will now flow to and over nearby edges, up to 4 blocks away.", "Liquids at their minimum height will no longer flow to and over nearby edges.", a -> {
            FlowingFluids.config.flowToEdges = a;
        }, () -> FlowingFluids.config.flowToEdges)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"draining_and_filling").executes(commandContext -> FFCommands.message((CommandContext<class_2168>)commandContext, "Set the chances of certain random tick interactions with fluids."))).then(FFCommands.floatChanceCommand("water_puddle_evaporation_chance", "Sets the chance of small minimum level water tiles evaporating during random ticks", a -> {
            FlowingFluids.config.evaporationChanceV2 = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.evaporationChanceV2)))).then(FFCommands.floatChanceCommand("water_nether_evaporation_chance", "Sets the chance of any water losing a level during random ticks in the nether", a -> {
            FlowingFluids.config.evaporationNetherChance = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.evaporationNetherChance)))).then(FFCommands.floatChanceCommand("water_rain_refill_chance", "Sets the chance of non-full water tiles increasing their level while its rains and they are open to the sky, during random ticks. This provides access to renewable water given enough time.\nNOTE: this will always be forcibly limited to 1/3rd of the current water_puddle_evaporation_chance setting otherwise water will endlessly fill the world during rain, this does effectively cap this value to 0.33", a -> {
            FlowingFluids.config.rainRefillChance = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.rainRefillChance)))).then(FFCommands.floatChanceCommand("water_infinite_biome_refill_chance", "Sets the chance of non-full water tiles increasing their level within: Oceans, Rivers, and Swamps, during random ticks. Additionally they must have a sky light level higher than 0, and be between y=0 and sea level. This provides time limited access to infinite water within these biomes, granted they are big enough and not drained too quickly", a -> {
            FlowingFluids.config.oceanRiverSwampRefillChance = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.oceanRiverSwampRefillChance)))).then(FFCommands.floatChanceCommand("water_infinite_biome_non_consume_chance", "Sets the chance of water not being consumed when flowing in: Oceans, Rivers, and Swamps. Additionally they must have a sky light level higher than 0, and be between y=0 and sea level. This allows access to infinite water within these biomes", a -> {
            FlowingFluids.config.infiniteWaterBiomeNonConsumeChance = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.infiniteWaterBiomeNonConsumeChance)))).then(FFCommands.floatChanceCommand("water_infinite_biome_surface_drain_chance", "Sets the chance of water being drained into water at sea level when flowing into: Oceans, Rivers, and Swamps. Additionally they must have a sky light level higher than 0. This allows infinte water drainage within these biomes", a -> {
            FlowingFluids.config.infiniteWaterBiomeDrainSurfaceChance = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.infiniteWaterBiomeDrainSurfaceChance)))).then(FFCommands.floatChanceCommand("farm_land_drains_water_chance", "Sets the chance at which a farmland block will consume 1 level of water each time it hydrates. 0 == OFF, 1 == ALWAYS", a -> {
            FlowingFluids.config.farmlandDrainWaterChance = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.farmlandDrainWaterChance)))).then(FFCommands.floatChanceCommand("animal_breeding_drains_water_chance", "Sets the chance at which an animal will consume 1 level of nearby water each time it tries to breed, range 8 blocks, water can be at same level or 1 lower. 0 == OFF, 1 == ALWAYS", a -> {
            FlowingFluids.config.drinkWaterToBreedAnimalChance = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.drinkWaterToBreedAnimalChance)))).then(FFCommands.floatChanceCommand("concrete_powder_drains_water_chance", "Sets the chance at which concrete powder will consume a water level on hardening. 0 == OFF, 1 == ALWAYS", a -> {
            FlowingFluids.config.concreteDrainsWaterChance = a.floatValue();
        }, () -> Float.valueOf(FlowingFluids.config.concreteDrainsWaterChance)))).then(FFCommands.booleanCommand("rain_fills_block_above", "Controls if rain will place new layers of water higher than the previous block of water was.", a -> {
            FlowingFluids.config.rainFillsWaterHigherV2 = a;
        }, () -> FlowingFluids.config.rainFillsWaterHigherV2))).then(FFCommands.booleanCommand("only_infinite_biomes_at_sea_level", "Controls if the infinite biome refilling only happens to water at exactly sea level.", a -> {
            FlowingFluids.config.fastBiomeRefillAtSeaLevelOnly = a;
        }, () -> FlowingFluids.config.fastBiomeRefillAtSeaLevelOnly))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"~debug").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Debug commands you probably don't need these."))).then(FFCommands.booleanCommand("random_ticks_printing", "Enables or disables printing of random tick events, this will spam your log with every random tick event that happens.", "Random ticks printing is now enabled.", "Random ticks printing is now disabled.", a -> {
            FlowingFluids.config.printRandomTicks = a;
        }, () -> FlowingFluids.config.printRandomTicks))).then(FFCommands.booleanCommand("water_level_tinting", "Enables or disables water level tinting, this will make water change colour based on its level.", "water_level_tinting is now enabled.", "water_level_tinting is now disabled.", a -> {
            FlowingFluids.config.debugWaterLevelColours = a;
        }, () -> FlowingFluids.config.debugWaterLevelColours))).then(class_2170.method_9247((String)"kill_all_current_fluid_updates").executes(cont -> {
            FlowingFluids.debug_killFluidUpdatesUntilTime = System.currentTimeMillis() + 3000L;
            return FFCommands.message((CommandContext<class_2168>)cont, "All fluid flowing ticks will be ignored and allowed to freeze in place over the next 3 seconds.\nAll fluids that are loaded and ticking during this time will completely stop updating and freeze in place until the next time they get updated.\n You may use the debug command \"plug_fluids_in_nearby_chunks\" to surround all these frozen fluids with appropriate blocks to prevent further flow.");
        }))).then(class_2170.method_9247((String)"how_many_fluids_plugged_in_world_gen_this_session").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, FlowingFluids.waterPluggedThisSession + " fluids have been plugged during world gen this session.")))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"super_sponge_at_me").executes(cont -> {
            int drained = FFCommands.superSponge((class_1937)((class_2168)cont.getSource()).method_9225(), class_2338.method_49638((class_2374)((class_2168)cont.getSource()).method_9222()), (class_3611)class_3612.field_15910);
            return FFCommands.message((CommandContext<class_2168>)cont, drained + " blocks of water have been drained.");
        })).then(class_2170.method_9244((String)"fluid", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).executes(cont -> {
            class_3611 patt0$temp;
            class_3610 fluidState = class_2257.method_9655((CommandContext)cont, (String)"fluid").method_9494().method_26227();
            if (fluidState.method_15769() || !((patt0$temp = fluidState.method_15772()) instanceof class_3609)) {
                throw notFluidException.create();
            }
            class_3609 flows = (class_3609)patt0$temp;
            int drained = FFCommands.superSponge((class_1937)((class_2168)cont.getSource()).method_9225(), class_2338.method_49638((class_2374)((class_2168)cont.getSource()).method_9222()), (class_3611)flows);
            return FFCommands.message((CommandContext<class_2168>)cont, drained + " blocks of " + flows.method_15751().method_15785().method_15759().method_26204().method_9518().getString() + " have been drained.");
        })))).then(FFCommands.booleanCommand("announce_world_gen_actions", "Enables or disables world gen action announcements, this will spam your log with every world gen action that happens because of this mod, including the location of this action (E.G. the plug fluids during world gen feature).", "World gen action announcements are now enabled.", "World gen action announcements are now disabled.", a -> {
            FlowingFluids.config.announceWorldGenActions = a;
        }, () -> FlowingFluids.config.announceWorldGenActions))).then(class_2170.method_9247((String)"surround_all_fluids_in_nearby_chunks_with_blocks").executes(cont -> {
            class_3218 level = ((class_2168)cont.getSource()).method_9225();
            class_243 pos = ((class_2168)cont.getSource()).method_9222();
            class_1923 posChunk = new class_1923(new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
            int dist = level.method_8503().method_3760().method_38651();
            int count = FlowingFluids.waterPluggedThisSession;
            for (int x = posChunk.field_9181 - dist; x <= posChunk.field_9181 + dist; ++x) {
                for (int z = posChunk.field_9180 - dist; z <= posChunk.field_9180 + dist; ++z) {
                    if (!level.method_8393(x, z)) continue;
                    PlugWaterFeature.processChunk((class_1936)level, new class_1923(x, z), (class_2791)level.method_8497(x, z));
                }
            }
            return FFCommands.message((CommandContext<class_2168>)cont, "All fluids, within " + dist + " chunks of you, have had any fluids that are exposed to air plugged up with appropriate blocks.\nThis will not affect any fluids that are not exposed to air, or are already plugged.\nThis has plugged " + (FlowingFluids.waterPluggedThisSession - count) + " fluids in total.");
        }))).then(class_2170.method_9247((String)"force_tick_all_fluids_in_nearby_chunks").executes(cont -> {
            class_3218 level = ((class_2168)cont.getSource()).method_9225();
            class_243 pos = ((class_2168)cont.getSource()).method_9222();
            class_1923 posChunk = new class_1923(new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
            int dist = level.method_8503().method_3760().method_38651();
            class_5819 rand = level.method_8409();
            AtomicInteger count = new AtomicInteger();
            for (int x = posChunk.field_9181 - dist; x <= posChunk.field_9181 + dist; ++x) {
                for (int z = posChunk.field_9180 - dist; z <= posChunk.field_9180 + dist; ++z) {
                    if (!level.method_8393(x, z)) continue;
                    level.method_8497(x, z).method_51525(class_4970.class_4971::method_51176, (blockPos, blockState) -> {
                        level.method_39281(blockPos, blockState.method_26227().method_15772(), 1 + rand.method_43048(200));
                        count.incrementAndGet();
                    });
                }
            }
            return FFCommands.message((CommandContext<class_2168>)cont, "All fluids, within " + dist + " chunks of you, have been forcibly added to the tick queue with random intervals over the next 0-10 seconds, EXPECT SOME LAG! Amount force ticked = " + count.get());
        }))).then(class_2170.method_9247((String)"is_infinite_water_biome").executes(cont -> {
            class_3218 level = ((class_2168)cont.getSource()).method_9225();
            class_243 pos = ((class_2168)cont.getSource()).method_9222();
            return FFCommands.message((CommandContext<class_2168>)cont, "You are " + (FFFluidUtils.matchInfiniteBiomes((class_6880<class_1959>)level.method_23753(new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350))) ? "IN" : "NOT IN") + " an Infinite biome. By default these are: Oceans, Rivers, and Swamps.\nMods can add their own via the api but most modded oceans and rivers should be accounted for automatically by this mod.");
        })));
        if (FlowingFluidsPlatform.isThisModLoaded("create")) {
            commands.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"create_mod_compat").executes(commandContext -> FFCommands.message((CommandContext<class_2168>)commandContext, "Settings for Create Mod compatibility, use these to change how fluids interact with Create water wheels and pipes."))).then(class_2170.method_9247((String)"info").executes(c -> FFCommands.message((CommandContext<class_2168>)c, "The Create mod uses water wheels as it's most primitive power source. Flowing Fluids has settings to change how these water wheels get powered due to the additional challenges of the flowing fluids mod interactions with fluids.")))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"water_wheel_requirements").executes(cont -> FFCommands.message((CommandContext<class_2168>)cont, "Changes how the Create Mod's water wheels interact with fluids, select an mode to get further information. Default is flow. Water wheel mode is currently set to " + String.valueOf((Object)FlowingFluids.config.create_waterWheelMode)))).then(class_2170.method_9247((String)"flow").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.REQUIRE_FLOW;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water wheel mode is now set to require flow.\nWater wheels will only spin if the water has a level gradient, which almost always requires the water to be actively flowing.");
            }))).then(class_2170.method_9247((String)"flow_or_river").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.REQUIRE_FLOW_OR_RIVER;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water wheel mode is now set to require flow or river.\nWater wheels will only spin if the water has a level gradient, which almost always requires the water to be actively flowing, or if the water is in a river biome touching any water, and within 5 blocks of sea level. Will always spin in the same direction when using a river as a source.");
            }))).then(class_2170.method_9247((String)"flow_or_river_opposite_spin").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.REQUIRE_FLOW_OR_RIVER_OPPOSITE;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water wheel mode is now set to require flow or river with opposite spin.\nWater wheels will only spin if the water has a level gradient, which almost always requires the water to be actively flowing, or if the water is in a river biome touching any water, and within 5 blocks of sea level. Will spin in the opposite direction to the other river mode.");
            }))).then(class_2170.method_9247((String)"fluid").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.REQUIRE_FLUID;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water wheel mode is now set to only require fluid to be present in the checked spaces. Will always spin in the same direction.");
            }))).then(class_2170.method_9247((String)"fluid_opposite_spin").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.REQUIRE_FLUID_OPPOSITE;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water wheel mode is now set to only require fluid to be present in the checked spaces. Will spin in the opposite direction to the other fluid mode.");
            }))).then(class_2170.method_9247((String)"full_fluid").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.REQUIRE_FULL_FLUID;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water wheel mode is now set to only require a full 8 levels of fluid to be present in the checked spaces. Will always spin in the same direction.");
            }))).then(class_2170.method_9247((String)"full_fluid_opposite_spin").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.REQUIRE_FULL_FLUID_OPPOSITE;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "Water wheel mode is now set to only require a full 8 levels of fluid to be present in the checked spaces. Will spin in the opposite direction to the other full fluid mode.");
            }))).then(class_2170.method_9247((String)"always").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.ALWAYS;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "water wheel mode is now set to always spin.\nWater wheels will always spin with max strength regardless of present fluids.");
            }))).then(class_2170.method_9247((String)"always_opposite_spin").executes(cont -> {
                FlowingFluids.config.create_waterWheelMode = FFConfig.CreateWaterWheelMode.ALWAYS_OPPOSITE;
                return FFCommands.messageAndSaveConfig((CommandContext<class_2168>)cont, "water wheel mode is now set to always spin with opposite spin.\nWater wheels will always spin with max strength regardless of present fluids, and will spin in the opposite direction to the other always mode.");
            })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"pipes").then(FFCommands.booleanCommand("infinite_pipe_fluid_source", "Enables or disables infinite pipe fluid source, if disabled pipes will consume the source fluid block.", "Pipes will now not consume the source fluid block.", "Pipes will now consume the source fluid block.", a -> {
                FlowingFluids.config.create_infinitePipes = a;
            }, () -> FlowingFluids.config.create_infinitePipes))).then(class_2170.method_9247((String)"info").executes(c -> FFCommands.message((CommandContext<class_2168>)c, "Create mod pipes will draw fluids only when the entire input block is full (8 levels of fluid). This is required for fluid levels to remain consistent between bucket and other usages, and for Flowing Fluids to be as unobtrusive as possible to the Create mod's inner workings. That being said if you want an easy time of using pipes without worrying about water usage, then enable the infinite pipes setting. You can also disable Create pipes from outputting water blocks in it's own config settings")))));
        }
        dispatcher.register(commands);
    }

    private static int superSponge(class_1937 level, class_2338 pos, class_3611 fluid) {
        boolean yes = true;
        boolean no = false;
        return class_2338.method_49925((class_2338)pos, (int)32, (int)10000, (blockPos, consumer) -> {
            for (class_2350 direction : class_2350.values()) {
                consumer.accept(blockPos.method_10093(direction));
            }
        }, blockPos2 -> {
            class_2263 bucketPickup;
            if (blockPos2.equals((Object)pos)) {
                return true;
            }
            class_2680 blockState = level.method_8320(blockPos2);
            class_3610 fluidState = level.method_8316(blockPos2);
            if (!fluidState.method_15772().method_15780(fluid)) {
                return false;
            }
            class_2248 block = blockState.method_26204();
            if (block instanceof class_2263 && !(bucketPickup = (class_2263)block).method_9700(null, (class_1936)level, blockPos2, blockState).method_7960()) {
                return true;
            }
            if (blockState.method_26204() instanceof class_2404) {
                level.method_8652(blockPos2, class_2246.field_10124.method_9564(), 3);
            } else {
                if (!(blockState.method_27852(class_2246.field_9993) || blockState.method_27852(class_2246.field_10463) || blockState.method_27852(class_2246.field_10376) || blockState.method_27852(class_2246.field_10238))) {
                    return false;
                }
                class_2586 blockEntity = blockState.method_31709() ? level.method_8321(blockPos2) : null;
                class_2248.method_9610((class_2680)blockState, (class_1936)level, (class_2338)blockPos2, (class_2586)blockEntity);
                level.method_8652(blockPos2, class_2246.field_10124.method_9564(), 3);
            }
            return true;
        });
    }
}

