/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.config;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5253;
import net.minecraft.class_7923;
import traben.flowing_fluids.FlowingFluids;

public class FFConfig {
    public boolean flowToEdges = true;
    public boolean enableMod = true;
    public boolean enableDisplacement = true;
    public boolean enablePistonPushing = true;
    public float rainRefillChance = 0.3f;
    public float oceanRiverSwampRefillChance = 1.0f;
    public float evaporationChanceV2 = 1.0f;
    public float evaporationNetherChance = 1.0f;
    public boolean printRandomTicks = false;
    public boolean hideFlowingTexture = true;
    public LiquidHeight fullLiquidHeight = LiquidHeight.REGULAR;
    public float farmlandDrainWaterChance = 0.1f;
    public boolean debugWaterLevelColours = false;
    public WaterLogFlowMode waterLogFlowMode = WaterLogFlowMode.IN_FROM_TOP_ELSE_OUT;
    public int waterFlowDistance = 4;
    public int lavaFlowDistance = 2;
    public int lavaNetherFlowDistance = 4;
    public int waterTickDelay = 2;
    public int lavaTickDelay = 15;
    public int lavaNetherTickDelay = 5;
    public int randomTickLevelingDistance = 32;
    public float drinkWaterToBreedAnimalChance = 0.1f;
    public boolean encloseAllFluidOnWorldGen = true;
    public boolean announceWorldGenActions = false;
    public boolean easyPistonPump = true;
    public boolean waterFlowAffectsBoats = false;
    public boolean waterFlowAffectsEntities = true;
    public boolean waterFlowAffectsPlayers = false;
    public boolean waterFlowAffectsItems = true;
    public float infiniteWaterBiomeNonConsumeChance = 0.01f;
    public float infiniteWaterBiomeDrainSurfaceChance = 0.1f;
    public int minWaterLevelForIce = 4;
    public boolean rainFillsWaterHigherV2 = false;
    public int minLavaLevelForObsidian = 6;
    public boolean fastBiomeRefillAtSeaLevelOnly = false;
    public int playerBlockDistanceForFlowing = 0;
    public float concreteDrainsWaterChance = 0.5f;
    public CreateWaterWheelMode create_waterWheelMode = CreateWaterWheelMode.REQUIRE_FLOW_OR_RIVER;
    public boolean create_infinitePipes = false;
    public ObjectOpenHashSet<String> fluidBlacklist = new ObjectOpenHashSet();
    public static int[] waterLevelColours = new int[]{class_5253.class_5254.method_27764((int)255, (int)0, (int)0, (int)255), class_5253.class_5254.method_27764((int)255, (int)0, (int)128, (int)255), class_5253.class_5254.method_27764((int)255, (int)0, (int)255, (int)192), class_5253.class_5254.method_27764((int)255, (int)0, (int)255, (int)0), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)0), class_5253.class_5254.method_27764((int)255, (int)255, (int)128, (int)0), class_5253.class_5254.method_27764((int)255, (int)255, (int)0, (int)0), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255)};

    public boolean isFluidAllowed(class_3611 fluid) {
        if (fluid == null) {
            return false;
        }
        if (this.fluidBlacklist.isEmpty() || fluid == class_3612.field_15906) {
            return true;
        }
        return !this.fluidBlacklist.contains((Object)class_7923.field_41173.method_10221((Object)fluid).toString());
    }

    public boolean isFluidAllowed(class_3610 fluid) {
        return this.isFluidAllowed(fluid.method_15772());
    }

    public boolean isWaterAllowed() {
        return this.isFluidAllowed((class_3611)class_3612.field_15910);
    }

    public boolean dontTickAtLocation(class_2338 pos, class_1936 level) {
        if (this.playerBlockDistanceForFlowing == 0) {
            return false;
        }
        int sqrDist = this.playerBlockDistanceForFlowing * this.playerBlockDistanceForFlowing;
        for (class_1657 player2 : level.method_18456()) {
            double i = player2.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (!(i < (double)sqrDist)) continue;
            return false;
        }
        return true;
    }

    public FFConfig() {
    }

    public FFConfig(class_2540 buffer) {
        FlowingFluids.info("- Decoding server config packet from server.");
        this.flowToEdges = buffer.readBoolean();
        this.enableMod = buffer.readBoolean();
        this.enableDisplacement = buffer.readBoolean();
        this.enablePistonPushing = buffer.readBoolean();
        this.rainRefillChance = buffer.readFloat();
        this.oceanRiverSwampRefillChance = buffer.readFloat();
        this.evaporationChanceV2 = buffer.readFloat();
        this.evaporationNetherChance = buffer.readFloat();
        this.printRandomTicks = buffer.readBoolean();
        this.hideFlowingTexture = buffer.readBoolean();
        this.fullLiquidHeight = (LiquidHeight)buffer.method_10818(LiquidHeight.class);
        this.farmlandDrainWaterChance = buffer.readFloat();
        this.debugWaterLevelColours = buffer.readBoolean();
        this.waterLogFlowMode = (WaterLogFlowMode)buffer.method_10818(WaterLogFlowMode.class);
        this.waterFlowDistance = buffer.method_10816();
        this.lavaFlowDistance = buffer.method_10816();
        this.lavaNetherFlowDistance = buffer.method_10816();
        this.waterTickDelay = buffer.method_10816();
        this.lavaTickDelay = buffer.method_10816();
        this.lavaNetherTickDelay = buffer.method_10816();
        this.randomTickLevelingDistance = buffer.method_10816();
        this.drinkWaterToBreedAnimalChance = buffer.readFloat();
        this.encloseAllFluidOnWorldGen = buffer.readBoolean();
        this.announceWorldGenActions = buffer.readBoolean();
        this.easyPistonPump = buffer.readBoolean();
        this.waterFlowAffectsBoats = buffer.readBoolean();
        this.waterFlowAffectsEntities = buffer.readBoolean();
        this.waterFlowAffectsPlayers = buffer.readBoolean();
        this.waterFlowAffectsItems = buffer.readBoolean();
        this.infiniteWaterBiomeNonConsumeChance = buffer.readFloat();
        this.infiniteWaterBiomeDrainSurfaceChance = buffer.readFloat();
        this.minWaterLevelForIce = buffer.method_10816();
        this.rainFillsWaterHigherV2 = buffer.readBoolean();
        this.minLavaLevelForObsidian = buffer.method_10816();
        this.fastBiomeRefillAtSeaLevelOnly = buffer.readBoolean();
        this.playerBlockDistanceForFlowing = buffer.method_10816();
        this.concreteDrainsWaterChance = buffer.readFloat();
        this.create_waterWheelMode = (CreateWaterWheelMode)buffer.method_10818(CreateWaterWheelMode.class);
        this.create_infinitePipes = buffer.readBoolean();
        this.fluidBlacklist = (ObjectOpenHashSet)buffer.method_34068(ObjectOpenHashSet::new, class_2540::method_19772);
    }

    public void encodeToByteBuffer(class_2540 buffer) {
        FlowingFluids.info("- Encoding server config packet for client.");
        buffer.method_52964(this.flowToEdges);
        buffer.method_52964(this.enableMod);
        buffer.method_52964(this.enableDisplacement);
        buffer.method_52964(this.enablePistonPushing);
        buffer.method_52941(this.rainRefillChance);
        buffer.method_52941(this.oceanRiverSwampRefillChance);
        buffer.method_52941(this.evaporationChanceV2);
        buffer.method_52941(this.evaporationNetherChance);
        buffer.method_52964(this.printRandomTicks);
        buffer.method_52964(this.hideFlowingTexture);
        buffer.method_10817((Enum)this.fullLiquidHeight);
        buffer.method_52941(this.farmlandDrainWaterChance);
        buffer.method_52964(this.debugWaterLevelColours);
        buffer.method_10817((Enum)this.waterLogFlowMode);
        buffer.method_10804(this.waterFlowDistance);
        buffer.method_10804(this.lavaFlowDistance);
        buffer.method_10804(this.lavaNetherFlowDistance);
        buffer.method_10804(this.waterTickDelay);
        buffer.method_10804(this.lavaTickDelay);
        buffer.method_10804(this.lavaNetherTickDelay);
        buffer.method_10804(this.randomTickLevelingDistance);
        buffer.method_52941(this.drinkWaterToBreedAnimalChance);
        buffer.method_52964(this.encloseAllFluidOnWorldGen);
        buffer.method_52964(this.announceWorldGenActions);
        buffer.method_52964(this.easyPistonPump);
        buffer.method_52964(this.waterFlowAffectsBoats);
        buffer.method_52964(this.waterFlowAffectsEntities);
        buffer.method_52964(this.waterFlowAffectsPlayers);
        buffer.method_52964(this.waterFlowAffectsItems);
        buffer.method_52941(this.infiniteWaterBiomeNonConsumeChance);
        buffer.method_52941(this.infiniteWaterBiomeDrainSurfaceChance);
        buffer.method_10804(this.minWaterLevelForIce);
        buffer.method_52964(this.rainFillsWaterHigherV2);
        buffer.method_10804(this.minLavaLevelForObsidian);
        buffer.method_52964(this.fastBiomeRefillAtSeaLevelOnly);
        buffer.method_10804(this.playerBlockDistanceForFlowing);
        buffer.method_52941(this.concreteDrainsWaterChance);
        buffer.method_10817((Enum)this.create_waterWheelMode);
        buffer.method_52964(this.create_infinitePipes);
        buffer.method_34062(this.fluidBlacklist, class_2540::method_10814);
    }

    public static enum LiquidHeight {
        REGULAR,
        REGULAR_LOWER_BOUND,
        BLOCK,
        BLOCK_LOWER_BOUND,
        SLAB,
        CARPET;

    }

    public static enum WaterLogFlowMode {
        ONLY_IN,
        ONLY_OUT,
        IN_FROM_TOP_ELSE_OUT,
        OUT_DOWN_ELSE_IN,
        IGNORE;


        public boolean blocksFlowOutDown() {
            return this == ONLY_IN || this == IGNORE;
        }

        public boolean blocksFlowIn(boolean down) {
            if (down) {
                return this == ONLY_OUT || this == IGNORE;
            }
            return this == ONLY_OUT || this == IN_FROM_TOP_ELSE_OUT || this == IGNORE;
        }

        public boolean blocksFlowOutSides() {
            return this == ONLY_IN || this == OUT_DOWN_ELSE_IN || this == IGNORE;
        }
    }

    public static enum CreateWaterWheelMode {
        ALWAYS,
        REQUIRE_FLOW,
        REQUIRE_FLOW_OR_RIVER,
        REQUIRE_FLUID,
        REQUIRE_FULL_FLUID,
        RIVER_ONLY,
        REQUIRE_FLOW_OR_RIVER_OPPOSITE,
        REQUIRE_FLUID_OPPOSITE,
        REQUIRE_FULL_FLUID_OPPOSITE,
        ALWAYS_OPPOSITE,
        RIVER_ONLY_OPPOSITE;


        public boolean isCounterSpin() {
            return this.ordinal() > 5;
        }

        public boolean isRiver() {
            return this == REQUIRE_FLOW_OR_RIVER || this == REQUIRE_FLOW_OR_RIVER_OPPOSITE || this == RIVER_ONLY || this == RIVER_ONLY_OPPOSITE;
        }

        public boolean isRiverOnly() {
            return this == RIVER_ONLY || this == RIVER_ONLY_OPPOSITE;
        }

        public boolean needsFullFluid() {
            return this == REQUIRE_FULL_FLUID || this == REQUIRE_FULL_FLUID_OPPOSITE;
        }

        public boolean always() {
            return this == ALWAYS || this == ALWAYS_OPPOSITE;
        }
    }
}

