/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.config.FFConfig;

@Mixin(value={class_3609.class})
public abstract class MixinFlowingFluid
extends class_3611 {
    @Unique
    private static short ffCacheKey(class_2338 sourcePos, class_2338 spreadPos) {
        int i = spreadPos.method_10263() - sourcePos.method_10263();
        int j = spreadPos.method_10260() - sourcePos.method_10260();
        return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
    }

    @Unique
    private static boolean ff$handleWaterLoggedFlowAndReturnIfHandled(class_1937 level, class_2338 posFrom, class_3610 fluidState, int amount, class_2680 thisState, class_2338 posTo, int destFluidAmount, boolean flowingDown) {
        boolean toIsWaterloggable;
        boolean fromIsWaterloggable;
        boolean bl = fromIsWaterloggable = thisState.method_26204() instanceof class_2402 && thisState.method_26204() instanceof class_2263;
        if (fromIsWaterloggable && (flowingDown ? FlowingFluids.config.waterLogFlowMode.blocksFlowOutDown() : FlowingFluids.config.waterLogFlowMode.blocksFlowOutSides())) {
            return true;
        }
        class_2248 blockTo = level.method_8320(posTo).method_26204();
        boolean bl2 = toIsWaterloggable = blockTo instanceof class_2402 && blockTo instanceof class_2263;
        if (toIsWaterloggable && FlowingFluids.config.waterLogFlowMode.blocksFlowIn(flowingDown)) {
            return true;
        }
        if (fromIsWaterloggable || toIsWaterloggable) {
            int totalAmount = destFluidAmount + amount;
            if (totalAmount < 8) {
                return true;
            }
            if (toIsWaterloggable && fromIsWaterloggable) {
                FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, posFrom, fluidState.method_15772(), 0);
                FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, posTo, fluidState.method_15772(), 8);
            } else if (toIsWaterloggable) {
                FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, posFrom, fluidState.method_15772(), totalAmount - 8);
                FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, posTo, fluidState.method_15772(), 8);
            } else {
                if (destFluidAmount > 0) {
                    return true;
                }
                FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, posFrom, fluidState.method_15772(), 0);
                FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, posTo, fluidState.method_15772(), 8);
            }
            return true;
        }
        return false;
    }

    protected boolean method_15795() {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(this)) {
            return true;
        }
        return super.method_15795();
    }

    protected void method_15792(class_1937 level, class_2338 pos, class_3610 state, class_5819 random) {
        super.method_15792(level, pos, state, random);
        if (FlowingFluids.config.enableMod && FlowingFluids.config.randomTickLevelingDistance > 0 && level.method_8500(pos).method_12014().method_20825() < 16 && FlowingFluids.config.isFluidAllowed(this) && !level.method_8316(pos.method_10084()).method_15772().method_15780((class_3611)this)) {
            BiConsumer<class_2338.class_2339, class_2338.class_2339> move;
            int amount = state.method_15761();
            if (amount <= this.method_15739((class_4538)level)) {
                return;
            }
            int amountLess = amount - 1;
            class_2350 randomDirection = FFFluidUtils.getCardinalsShuffle(level.method_8409()).get(0);
            if (level.method_8409().method_43056()) {
                move = (mbp, up) -> {
                    mbp.method_10098(randomDirection);
                    up.method_10098(randomDirection);
                };
            } else {
                class_2350 offStep = level.method_8409().method_43056() ? randomDirection.method_10170() : randomDirection.method_10160();
                class_5819 rand = level.method_8409();
                move = (mbp, up) -> {
                    class_2350 dir = rand.method_43056() ? randomDirection : offStep;
                    mbp.method_10098(dir);
                    up.method_10098(dir);
                };
            }
            class_2338.class_2339 movingDir = pos.method_25503();
            class_2338.class_2339 movingDirAbove = pos.method_10084().method_25503();
            for (int i = 0; i < FlowingFluids.config.randomTickLevelingDistance; ++i) {
                move.accept(movingDir, movingDirAbove);
                class_2680 stateDir = level.method_8320((class_2338)movingDir);
                if (!(stateDir.method_26204() instanceof class_2404)) {
                    return;
                }
                class_3610 fluidStateDir = stateDir.method_26227();
                if (!fluidStateDir.method_15772().method_15780((class_3611)this)) {
                    return;
                }
                if (level.method_8316((class_2338)movingDirAbove).method_15772().method_15780((class_3611)this)) {
                    return;
                }
                int amountDir = fluidStateDir.method_15761();
                if (amountDir > amount) {
                    return;
                }
                if (amountDir >= amountLess) continue;
                FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, (class_2338)movingDir, this, amountDir + 1);
                FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, pos, this, amountLess);
                return;
            }
        }
    }

    @Shadow
    protected abstract int method_15739(class_4538 var1);

    @Shadow
    protected abstract void method_15745(class_1936 var1, class_2338 var2, class_2680 var3, class_2350 var4, class_3610 var5);

    @Shadow
    protected abstract int method_15733(class_4538 var1);

    @Shadow
    public abstract int method_15779(class_3610 var1);

    @Inject(method={"getOwnHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void ff$differentRenderHeight(class_3610 state, CallbackInfoReturnable<Float> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(state) && FlowingFluids.config.fullLiquidHeight != FFConfig.LiquidHeight.REGULAR) {
            cir.setReturnValue((Object)(switch (FlowingFluids.config.fullLiquidHeight) {
                case FFConfig.LiquidHeight.BLOCK -> Float.valueOf((float)state.method_15761() / 8.0f);
                case FFConfig.LiquidHeight.SLAB -> Float.valueOf((float)state.method_15761() / 16.0f);
                case FFConfig.LiquidHeight.CARPET -> Float.valueOf(0.0625f);
                case FFConfig.LiquidHeight.REGULAR_LOWER_BOUND -> Float.valueOf(((float)state.method_15761() - 0.9f) * 0.8888889f / 7.0f);
                case FFConfig.LiquidHeight.BLOCK_LOWER_BOUND -> Float.valueOf(((float)state.method_15761() - 0.9f) / 7.0f);
                default -> Float.valueOf((float)state.method_15761() / 9.0f);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void ff$tickMixin(class_1937 level, class_2338 blockPos, class_3610 fluidState, CallbackInfo ci) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(fluidState)) {
            ci.cancel();
            if (FlowingFluids.config.dontTickAtLocation(blockPos, (class_1936)level)) {
                level.method_39281(blockPos, (class_3611)this, 200 + level.field_9229.method_43048(200));
                return;
            }
            if (System.currentTimeMillis() < FlowingFluids.debug_killFluidUpdatesUntilTime) {
                return;
            }
            FlowingFluids.isManeuveringFluids = true;
            boolean withinInfBiomeHeights = FlowingFluids.config.fastBiomeRefillAtSeaLevelOnly ? level.method_8615() == blockPos.method_10264() || level.method_8615() - 1 == blockPos.method_10264() : level.method_8615() == blockPos.method_10264() && blockPos.method_10264() > 0;
            boolean isWaterAndInfiniteBiome = fluidState.method_15767(class_3486.field_15517) && withinInfBiomeHeights && FFFluidUtils.matchInfiniteBiomes((class_6880<class_1959>)level.method_23753(blockPos)) && level.method_8314(class_1944.field_9284, blockPos) > 0;
            boolean dontConsumeWater = isWaterAndInfiniteBiome && level.method_8615() != blockPos.method_10264() && level.method_8409().method_43057() < FlowingFluids.config.infiniteWaterBiomeNonConsumeChance;
            class_2680 thisState = level.method_8320(blockPos);
            try {
                class_2350 dir;
                it.unimi.dsi.fastutil.Pair<Integer, Runnable> remainder;
                class_3609 flow;
                class_3610 aboveF;
                int aboveAmount;
                class_2338 abovePos;
                class_2680 above;
                class_2338 posDown = blockPos.method_10074();
                int remainingAmount = this.flowing_fluids$checkAndFlowDown(level, blockPos, fluidState, thisState, posDown, level.method_8320(posDown), fluidState.method_15761());
                if (remainingAmount <= 0) {
                    return;
                }
                if (fluidState.method_15761() == 8 && thisState.method_51176() && (above = level.method_8320(abovePos = blockPos.method_10084())).method_51176() && (aboveAmount = (aboveF = above.method_26227()).method_15761()) > 0 && FFFluidUtils.canFluidFlowFromPosToDirectionFitOverride(flow = (class_3609)aboveF.method_15772(), (class_1922)level, abovePos, above, class_2350.field_11033, blockPos, thisState) && (Integer)(remainder = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction((class_1936)level, blockPos, aboveAmount, flow, 40, false, !FlowingFluids.pistonTick)).first() < aboveAmount) {
                    ((Runnable)remainder.second()).run();
                    if (!dontConsumeWater) {
                        FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, abovePos, (class_3611)flow, (Integer)remainder.first());
                    }
                    return;
                }
                if (remainingAmount > this.method_15739((class_4538)level)) {
                    this.ff$flowToSides(level, blockPos, fluidState, remainingAmount, thisState);
                } else if (FlowingFluids.config.flowToEdges && (dir = this.flowing_fluids$getLowestSpreadableLookingFor4BlockDrops(level, blockPos, fluidState, 1, true)) != null) {
                    class_2338 pos = blockPos.method_10093(dir);
                    this.flowing_fluids$setOrRemoveWaterAmountAt(level, blockPos, 0, thisState, dir);
                    this.flowing_fluids$spreadTo2((class_1936)level, pos, level.method_8320(pos), dir, remainingAmount);
                }
            }
            finally {
                if (isWaterAndInfiniteBiome) {
                    if (level.method_8615() == blockPos.method_10264()) {
                        class_3610 below;
                        int amount;
                        if (level.method_8409().method_43057() < FlowingFluids.config.infiniteWaterBiomeDrainSurfaceChance && (amount = level.method_8316(blockPos).method_15761()) > 0 && (below = level.method_8316(blockPos.method_10074())).method_15761() == 8 && below.method_15767(class_3486.field_15517)) {
                            level.method_8501(blockPos, FFFluidUtils.getBlockForFluidByAmount(this, amount - 1));
                        }
                    } else if (dontConsumeWater) {
                        level.method_8652(blockPos, thisState, 0);
                    }
                }
                FlowingFluids.isManeuveringFluids = false;
                FlowingFluids.pistonTick = false;
            }
        }
    }

    @Unique
    private void ff$flowToSides(class_1937 level, class_2338 blockPos, class_3610 fluidState, int amount, class_2680 thisState) {
        int destFluidAmount;
        class_2350 dir = this.flowing_fluids$getLowestSpreadableLookingFor4BlockDrops(level, blockPos, fluidState, amount, false);
        if (dir == null) {
            return;
        }
        class_2338 posDir = blockPos.method_10093(dir);
        if (MixinFlowingFluid.ff$handleWaterLoggedFlowAndReturnIfHandled(level, blockPos, fluidState, amount, thisState, posDir, destFluidAmount = level.method_8316(posDir).method_15761(), false)) {
            return;
        }
        int difference = amount - destFluidAmount;
        int averageLevel = destFluidAmount + difference / 2;
        boolean hasRemainder = difference % 2 != 0;
        int fromAmount = averageLevel;
        int toAmount = hasRemainder ? averageLevel + 1 : averageLevel;
        FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, blockPos, fluidState.method_15772(), fromAmount);
        FFFluidUtils.setFluidStateAtPosToNewAmount((class_1936)level, posDir, fluidState.method_15772(), toAmount);
    }

    @Unique
    private int flowing_fluids$checkAndFlowDown(class_1937 level, class_2338 blockPos, class_3610 fluidState, class_2680 thisState, class_2338 posDown, class_2680 stateDown, int amount) {
        class_3610 downFState = level.method_8316(posDown);
        if (this.flowing_fluids$canSpreadTo(fluidState.method_15772(), fluidState.method_15761(), (class_1922)level, blockPos, thisState, class_2350.field_11033, posDown, stateDown, downFState)) {
            class_2680 block;
            if (!downFState.method_15769() && !downFState.method_15772().method_15780(fluidState.method_15772())) {
                this.flowing_fluids$setOrRemoveWaterAmountAt(level, blockPos, amount - 1, thisState, class_2350.field_11033);
                this.flowing_fluids$spreadTo2((class_1936)level, posDown, stateDown, class_2350.field_11033, 1);
                return amount - 1;
            }
            if (FlowingFluids.config.easyPistonPump && FlowingFluids.config.enablePistonPushing && (block = level.method_8320(posDown.method_10074())).method_27852(class_2246.field_10008) && block.method_11654((class_2769)class_2318.field_10927) == class_2350.field_11036) {
                level.method_39281(blockPos, (class_3611)this, 10);
                FlowingFluids.pistonTick = true;
                return amount;
            }
            int fluidDownAmount = downFState.method_15761();
            if (MixinFlowingFluid.ff$handleWaterLoggedFlowAndReturnIfHandled(level, blockPos, fluidState, amount, thisState, posDown, fluidDownAmount, true)) {
                return level.method_8316(blockPos).method_15761();
            }
            int amountDestCanAccept = Math.min(8 - fluidDownAmount, amount);
            if (amountDestCanAccept > 0) {
                int destNewAmount = fluidDownAmount + amountDestCanAccept;
                int sourceNewAmount = amount - amountDestCanAccept;
                this.flowing_fluids$setOrRemoveWaterAmountAt(level, blockPos, sourceNewAmount, thisState, class_2350.field_11033);
                this.flowing_fluids$spreadTo2((class_1936)level, posDown, stateDown, class_2350.field_11033, destNewAmount);
                return sourceNewAmount;
            }
        }
        return amount;
    }

    @Unique
    private void flowing_fluids$setOrRemoveWaterAmountAt(class_1937 level, class_2338 blockPos, int amount, class_2680 thisState, class_2350 direction) {
        if (amount > 0) {
            this.flowing_fluids$spreadTo2((class_1936)level, blockPos, thisState, direction, amount);
        } else {
            FFFluidUtils.removeAllFluidAtPos((class_1936)level, blockPos, this);
        }
    }

    @Inject(method={"getNewLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    private void flowing_fluids$validateLiquidMixin(class_1937 level, class_2338 blockPos, class_2680 blockState, CallbackInfoReturnable<class_3610> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(this)) {
            class_3610 state = level.method_8316(blockPos);
            cir.setReturnValue((Object)FFFluidUtils.getStateForFluidByAmount(state.method_15772(), state.method_15761()));
        }
    }

    @Unique
    @Nullable
    private class_2350 flowing_fluids$getLowestSpreadableLookingFor4BlockDrops(class_1937 level, class_2338 blockPos, class_3610 fluidState, int amount, boolean requiresSlope) {
        Short2ObjectOpenHashMap statesAtPos = new Short2ObjectOpenHashMap();
        AtomicBoolean anyFlowableNeighbours2LevelsLowerOrMore = new AtomicBoolean(requiresSlope);
        List<class_2350> directionsCanSpreadToSortedByAmount = FFFluidUtils.getCardinalsShuffle(level.field_9229).stream().sorted(Comparator.comparingInt(dir1 -> level.method_8316(blockPos.method_10093(dir1)).method_15761())).filter(arg_0 -> this.lambda$flowing_fluids$getLowestSpreadableLookingFor4BlockDrops$3(blockPos, level, (Short2ObjectMap)statesAtPos, fluidState, amount, requiresSlope, anyFlowableNeighbours2LevelsLowerOrMore, arg_0)).toList();
        if (directionsCanSpreadToSortedByAmount.isEmpty()) {
            return null;
        }
        boolean requiresSlopeWithOverride = requiresSlope || !anyFlowableNeighbours2LevelsLowerOrMore.get();
        class_2350 spreadDirection = this.flowing_fluids$getValidDirectionFromDeepSpreadSearch(level, blockPos, fluidState, amount, requiresSlopeWithOverride, directionsCanSpreadToSortedByAmount, (Short2ObjectMap<Pair<class_2680, class_3610>>)statesAtPos);
        if (spreadDirection == null && !requiresSlopeWithOverride) {
            return directionsCanSpreadToSortedByAmount.get(0);
        }
        return spreadDirection;
    }

    @Unique
    @Nullable
    private class_2350 flowing_fluids$getValidDirectionFromDeepSpreadSearch(class_1937 level, class_2338 blockPos, class_3610 fluidState, int amount, boolean requiresSlope, List<class_2350> directionsCanSpreadToSortedByAmount, Short2ObjectMap<Pair<class_2680, class_3610>> statesAtPos) {
        int slopeFindDistance = this.method_15733((class_4538)level);
        if (slopeFindDistance < 1) {
            return null;
        }
        Short2BooleanOpenHashMap posCanFlowDown = new Short2BooleanOpenHashMap();
        posCanFlowDown.put(MixinFlowingFluid.ffCacheKey(blockPos, blockPos), false);
        return directionsCanSpreadToSortedByAmount.stream().map(arg_0 -> this.lambda$flowing_fluids$getValidDirectionFromDeepSpreadSearch$4(blockPos, level, amount, (Short2BooleanMap)posCanFlowDown, fluidState, requiresSlope, statesAtPos, slopeFindDistance, arg_0)).filter(pair -> !requiresSlope || (Integer)pair.getSecond() <= slopeFindDistance).min(Comparator.comparingInt(Pair::getSecond)).map(Pair::getFirst).orElse(null);
    }

    @Unique
    protected int flowing_fluids$getSlopeDistance(class_4538 level, class_2338 sourcePosForKey, int distance, class_2350 fromDir, class_3611 sourceFluid, int sourceAmount, class_2338 newPos, Short2ObjectMap<Pair<class_2680, class_3610>> statesAtPos, Short2BooleanMap posCanFlowDown, boolean forceSlopeDownSameOrEmpty, int slopeFindDistance) {
        int smallest = 1000;
        int searchDistance = distance + 1;
        for (class_2350 searchDir : class_2350.class_2353.field_11062) {
            int next;
            if (searchDir == fromDir) continue;
            class_2338 searchPos = newPos.method_10093(searchDir);
            short searchKey = MixinFlowingFluid.ffCacheKey(sourcePosForKey, searchPos);
            Pair<class_2680, class_3610> searchStates = this.flowing_fluids$getSetPosCache(searchKey, level, statesAtPos, searchPos);
            if (!this.flowing_fluids$canSpreadToOptionallySameOrEmpty(sourceFluid, sourceAmount, (class_1922)level, newPos, level.method_8320(newPos), searchDir, searchPos, (class_2680)searchStates.getFirst(), (class_3610)searchStates.getSecond(), forceSlopeDownSameOrEmpty)) continue;
            if (((class_3610)searchStates.getSecond()).method_15761() < sourceAmount - 2 || this.flowing_fluids$getSetFlowDownCache(searchKey, level, posCanFlowDown, searchPos, sourceFluid, forceSlopeDownSameOrEmpty)) {
                return searchDistance;
            }
            if (searchDistance >= slopeFindDistance || (next = this.flowing_fluids$getSlopeDistance(level, sourcePosForKey, searchDistance, searchDir.method_10153(), sourceFluid, sourceAmount, searchPos, statesAtPos, posCanFlowDown, forceSlopeDownSameOrEmpty, slopeFindDistance)) >= smallest) continue;
            smallest = next;
        }
        return smallest;
    }

    @Unique
    private Pair<class_2680, class_3610> flowing_fluids$getSetPosCache(short key, class_4538 level, Short2ObjectMap<Pair<class_2680, class_3610>> statesAtPos, class_2338 pos) {
        return (Pair)statesAtPos.computeIfAbsent(key, sx -> {
            class_2680 blockState = level.method_8320(pos);
            return Pair.of((Object)blockState, (Object)blockState.method_26227());
        });
    }

    @Unique
    private boolean flowing_fluids$getSetFlowDownCache(short key, class_4538 level, Short2BooleanMap boolAtPos, class_2338 pos, class_3611 sourceFluid, boolean forceSlopeDownSameOrEmpty) {
        return boolAtPos.computeIfAbsent(key, sx -> {
            class_2338 posDown = pos.method_10074();
            return this.flowing_fluids$canSpreadToOptionallySameOrEmpty(sourceFluid, 8, (class_1922)level, pos, level.method_8320(pos), class_2350.field_11033, posDown, level.method_8320(posDown), level.method_8316(posDown), forceSlopeDownSameOrEmpty);
        });
    }

    @Unique
    protected void flowing_fluids$spreadTo2(class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState, class_2350 direction, int amount) {
        this.method_15745(levelAccessor, blockPos, blockState, direction, FFFluidUtils.getStateForFluidByAmount(this, amount));
    }

    @Unique
    private boolean flowing_fluids$canSpreadToOptionallySameOrEmpty(class_3611 sourceFluid, int sourceAmount, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_3610 fluidState2, boolean enforceSameFluidOrEmpty) {
        if (enforceSameFluidOrEmpty && !fluidState2.method_15769() && !fluidState2.method_15772().method_15780(sourceFluid)) {
            return false;
        }
        return this.flowing_fluids$canSpreadTo(sourceFluid, sourceAmount, blockGetter, blockPos, blockState, direction, blockPos2, blockState2, fluidState2);
    }

    @Unique
    private boolean flowing_fluids$canSpreadTo(class_3611 sourceFluid, int sourceAmount, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_3610 fluidState2) {
        return FFFluidUtils.canFluidFlowFromPosToDirection((class_3609)sourceFluid, sourceAmount, blockGetter, blockPos, blockState, direction, blockPos2, blockState2, fluidState2);
    }

    private /* synthetic */ Pair lambda$flowing_fluids$getValidDirectionFromDeepSpreadSearch$4(class_2338 blockPos, class_1937 level, int amount, Short2BooleanMap posCanFlowDown, class_3610 fluidState, boolean requiresSlope, Short2ObjectMap statesAtPos, int slopeFindDistance, class_2350 dir) {
        class_2338 posDir = blockPos.method_10093(dir);
        short key = MixinFlowingFluid.ffCacheKey(blockPos, posDir);
        if (level.method_8316(posDir).method_15761() < amount - 1 || this.flowing_fluids$getSetFlowDownCache(key, (class_4538)level, posCanFlowDown, posDir, fluidState.method_15772(), requiresSlope)) {
            return Pair.of((Object)dir, (Object)0);
        }
        return Pair.of((Object)dir, (Object)this.flowing_fluids$getSlopeDistance((class_4538)level, blockPos, 1, dir.method_10153(), fluidState.method_15772(), amount + 1, posDir, (Short2ObjectMap<Pair<class_2680, class_3610>>)statesAtPos, posCanFlowDown, requiresSlope, slopeFindDistance));
    }

    private /* synthetic */ boolean lambda$flowing_fluids$getLowestSpreadableLookingFor4BlockDrops$3(class_2338 blockPos, class_1937 level, Short2ObjectMap statesAtPos, class_3610 fluidState, int amount, boolean requiresSlope, AtomicBoolean anyFlowableNeighbours2LevelsLowerOrMore, class_2350 dir) {
        class_2338 posDir = blockPos.method_10093(dir);
        short key = MixinFlowingFluid.ffCacheKey(blockPos, posDir);
        Pair<class_2680, class_3610> statesDir = this.flowing_fluids$getSetPosCache(key, (class_4538)level, (Short2ObjectMap<Pair<class_2680, class_3610>>)statesAtPos, posDir);
        class_2680 stateDir = (class_2680)statesDir.getFirst();
        class_3610 fluidStateDir = (class_3610)statesDir.getSecond();
        int amountDir = fluidStateDir.method_15761();
        boolean canFlow = this.flowing_fluids$canSpreadToOptionallySameOrEmpty(fluidState.method_15772(), amount, (class_1922)level, blockPos, level.method_8320(blockPos), dir, posDir, stateDir, fluidStateDir, requiresSlope);
        if (canFlow && !anyFlowableNeighbours2LevelsLowerOrMore.get()) {
            anyFlowableNeighbours2LevelsLowerOrMore.set(amountDir < amount - 1);
        }
        return canFlow;
    }
}

