/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import it.unimi.dsi.fastutil.Pair;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3621;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;

@Mixin(value={class_3621.class})
public abstract class MixinWaterFluid
extends class_3609 {
    @Unique
    boolean isWithinInfBiomeHeights = false;
    @Unique
    boolean isInfBiome = false;
    @Unique
    boolean hasSkyLight = false;

    @Shadow
    public abstract int method_15739(class_4538 var1);

    @Shadow
    public abstract boolean method_15780(class_3611 var1);

    protected void method_15792(class_1937 level, class_2338 blockPos, class_3610 fluidState, class_5819 randomSource) {
        super.method_15792(level, blockPos, fluidState, randomSource);
        if (level.method_8608() || fluidState.method_15769() || !FlowingFluids.config.enableMod || !FlowingFluids.config.isFluidAllowed(fluidState)) {
            return;
        }
        if (FlowingFluids.config.dontTickAtLocation(blockPos, (class_1936)level)) {
            return;
        }
        this.isWithinInfBiomeHeights = FlowingFluids.config.fastBiomeRefillAtSeaLevelOnly ? level.method_8615() == blockPos.method_10264() || level.method_8615() - 1 == blockPos.method_10264() : level.method_8615() == blockPos.method_10264() && blockPos.method_10264() > 0;
        this.hasSkyLight = level.method_8314(class_1944.field_9284, blockPos) > 0;
        this.isInfBiome = FFFluidUtils.matchInfiniteBiomes((class_6880<class_1959>)level.method_23753(blockPos));
        int amount = fluidState.method_15761();
        if (amount < 8) {
            if (this.ff$tryBiomeFillOrDrain(level, blockPos, amount, level.field_9229.method_43057())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was filled by biome at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.oceanRiverSwampRefillChance);
                }
                return;
            }
            if (this.ff$tryRainFill(level, blockPos, level.field_9229.method_43057())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was filled by rain at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.rainRefillChance);
                }
                return;
            }
            if (this.ff$tryEvaporateNether(level, blockPos, amount, level.field_9229.method_43057())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was evaporated via Nether at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.evaporationChanceV2);
                }
                return;
            }
            if (this.ff$tryEvaporate(level, blockPos, amount, level.field_9229.method_43057()) && FlowingFluids.config.printRandomTicks) {
                FlowingFluids.info("--- Water was evaporated - non Nether at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.evaporationChanceV2);
            }
        } else if (this.ff$tryRainFill(level, blockPos, level.field_9229.method_43057()) && FlowingFluids.config.printRandomTicks) {
            FlowingFluids.info("--- Water was filled by rain at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.rainRefillChance);
        }
    }

    @Unique
    private boolean ff$tryRainFill(class_1937 level, class_2338 blockPos, float chance) {
        int amount;
        Pair<Integer, Runnable> result;
        if (chance < Math.min(FlowingFluids.config.rainRefillChance, FlowingFluids.config.evaporationChanceV2 / 3.0f) && level.method_8419() && level.method_8311(blockPos.method_10084()) && (!this.isInfBiome || !this.isWithinInfBiomeHeights) && !level.method_23753(blockPos).method_40220(class_6908.field_36496) && (Integer)(result = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction((class_1936)level, blockPos, amount = level.method_8546() ? 2 : 1, this, 40, FlowingFluids.config.rainFillsWaterHigherV2, false)).first() != amount) {
            ((Runnable)result.second()).run();
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryBiomeFillOrDrain(class_1937 level, class_2338 blockPos, int amount, float chance) {
        if (level.method_8615() == blockPos.method_10264()) {
            class_3610 below;
            if ((chance < FlowingFluids.config.infiniteWaterBiomeNonConsumeChance || chance < FlowingFluids.config.oceanRiverSwampRefillChance || level.method_8419() && chance < FlowingFluids.config.rainRefillChance) && (below = level.method_8316(blockPos.method_10074())).method_15761() == 8 && below.method_15767(class_3486.field_15517) && this.hasSkyLight && this.isInfBiome) {
                level.method_8501(blockPos, FFFluidUtils.getBlockForFluidByAmount((class_3611)this, amount - 2));
                return true;
            }
        } else if (this.isWithinInfBiomeHeights && amount < 8 && chance < FlowingFluids.config.oceanRiverSwampRefillChance && this.isInfBiome && this.hasSkyLight) {
            level.method_8501(blockPos, FFFluidUtils.getBlockForFluidByAmount((class_3611)this, amount + 2));
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryEvaporate(class_1937 level, class_2338 blockPos, int amount, float chance) {
        if (chance < FlowingFluids.config.evaporationChanceV2 && amount <= this.method_15739((class_4538)level) && level.method_8316(blockPos.method_10074()).method_15769()) {
            level.method_8501(blockPos, class_2246.field_10124.method_9564());
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryEvaporateNether(class_1937 level, class_2338 blockPos, int amount, float chance) {
        if (chance < FlowingFluids.config.evaporationNetherChance && level.method_23753(blockPos).method_40220(class_6908.field_36518)) {
            if (amount == 1) {
                level.method_8501(blockPos, class_2246.field_10124.method_9564());
            } else {
                level.method_8501(blockPos, FFFluidUtils.getBlockForFluidByAmount((class_3611)this, amount - 3));
            }
            return true;
        }
        return false;
    }

    @Inject(method={"getSlopeFindDistance"}, at={@At(value="RETURN")}, cancellable=true)
    private void ff$modifySlopeDistance(class_4538 level, CallbackInfoReturnable<Integer> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((class_3611)this)) {
            cir.setReturnValue((Object)class_3532.method_15340((int)FlowingFluids.config.waterFlowDistance, (int)1, (int)8));
        }
    }

    @Inject(method={"getTickDelay"}, at={@At(value="RETURN")}, cancellable=true)
    private void ff$modifyTickDelay(class_4538 level, CallbackInfoReturnable<Integer> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((class_3611)this)) {
            cir.setReturnValue((Object)class_3532.method_15340((int)FlowingFluids.config.waterTickDelay, (int)1, (int)255));
        }
    }
}

