/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFBucketItem;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;

@Mixin(value={BucketItem.class})
public abstract class MixinBucketItem
extends Item
implements FFBucketItem {
    @Shadow
    @Final
    private Fluid content;

    public MixinBucketItem(Item.Properties properties) {
        super(properties);
    }

    @Shadow
    public static ItemStack getEmptySuccessItem(ItemStack itemStack, Player player) {
        return null;
    }

    @Shadow
    public abstract void checkExtraContent(@Nullable LivingEntity var1, Level var2, ItemStack var3, BlockPos var4);

    @Shadow
    protected abstract void playEmptySound(@Nullable LivingEntity var1, LevelAccessor var2, BlockPos var3);

    @ModifyArg(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/BucketItem;getPlayerPOVHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/ClipContext$Fluid;)Lnet/minecraft/world/phys/BlockHitResult;"), index=2)
    private ClipContext.Fluid flowing_fluids$allowAnyFluid(ClipContext.Fluid par3) {
        if (FlowingFluids.config.enableMod && par3 == ClipContext.Fluid.SOURCE_ONLY) {
            return ClipContext.Fluid.ANY;
        }
        return par3;
    }

    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void flowing_fluids$alterBehaviourIfPartial(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (FlowingFluids.config.enableMod && this.content instanceof FlowingFluid && FlowingFluids.config.isFluidAllowed(this.content)) {
            ItemStack heldBucket = player.getItemInHand(interactionHand);
            BlockHitResult blockHitResult = MixinBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (blockHitResult.getType() == HitResult.Type.MISS || blockHitResult.getType() != HitResult.Type.BLOCK) {
                cir.setReturnValue((Object)InteractionResult.PASS);
            } else {
                BlockPos blockPos = blockHitResult.getBlockPos();
                Direction direction = blockHitResult.getDirection();
                BlockPos blockPos2 = blockPos.relative(direction);
                if (level.mayInteract((Entity)player, blockPos) && player.mayUseItemAt(blockPos2, direction, heldBucket)) {
                    int amount;
                    BlockState blockState = level.getBlockState(blockPos);
                    FluidState fluidState = level.getFluidState(blockPos);
                    BlockPos blockPos3 = blockState.getBlock() instanceof LiquidBlockContainer && this.content == Fluids.WATER || this.content.isSame(fluidState.getType()) && fluidState.getAmount() < 8 ? blockPos : blockPos2;
                    int remainder = this.ff$emptyContents_AndGetRemainder(player, level, blockPos3, blockHitResult, amount = 8 - heldBucket.getDamageValue(), false);
                    if (remainder != amount) {
                        this.checkExtraContent((LivingEntity)player, level, heldBucket, blockPos3);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockPos3, heldBucket);
                        }
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                        ItemStack resultBucket = remainder == 0 ? MixinBucketItem.getEmptySuccessItem(heldBucket, player) : this.ff$bucketOfAmount(heldBucket, remainder);
                        ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)heldBucket, (Player)player, (ItemStack)resultBucket);
                        cir.setReturnValue((Object)InteractionResult.SUCCESS.heldItemTransformedTo(itemStack2));
                    } else {
                        cir.setReturnValue((Object)InteractionResult.FAIL);
                    }
                } else {
                    cir.setReturnValue((Object)InteractionResult.FAIL);
                }
            }
        }
    }

    @Override
    public int ff$emptyContents_AndGetRemainder(@Nullable Player player, Level level, BlockPos blockPos, @Nullable BlockHitResult blockHitResult, int amount, boolean onlyModifyThatBlock) {
        int remainder;
        boolean success;
        LiquidBlockContainer container;
        Block block;
        boolean canPlaceLiquidInPos;
        FlowingFluid flowingFluid;
        block18: {
            block17: {
                Fluid fluid = this.content;
                if (!(fluid instanceof FlowingFluid)) break block17;
                flowingFluid = (FlowingFluid)fluid;
                if (FlowingFluids.config.isFluidAllowed(this.content)) break block18;
            }
            return amount;
        }
        BlockState state = level.getBlockState(blockPos);
        FluidState fluidState = level.getFluidState(blockPos);
        boolean fluidIsSameAsContent = this.content.isSame(fluidState.getType());
        boolean bl = canPlaceLiquidInPos = state.canBeReplaced(this.content) || state.isAir() || fluidIsSameAsContent;
        if (!canPlaceLiquidInPos && (block = state.getBlock()) instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).canPlaceLiquid((LivingEntity)player, (BlockGetter)level, blockPos, state, this.content)) {
            if (amount != 8) {
                return amount;
            }
            container.placeLiquid((LevelAccessor)level, blockPos, level.getBlockState(blockPos), flowingFluid.getSource(false));
            this.playEmptySound((LivingEntity)player, (LevelAccessor)level, blockPos);
            return 0;
        }
        if (!canPlaceLiquidInPos) {
            if (blockHitResult == null) {
                return amount;
            }
            return this.ff$emptyContents_AndGetRemainder(player, level, blockHitResult.getBlockPos().relative(blockHitResult.getDirection()), null, amount, onlyModifyThatBlock);
        }
        if (level.dimensionType().ultraWarm() && this.content.isSame((Fluid)Fluids.WATER)) {
            int i = blockPos.getX();
            int j = blockPos.getY();
            int k = blockPos.getZ();
            level.playSound((Entity)player, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return 0;
        }
        if (!level.isClientSide && level.getBlockState(blockPos).canBeReplaced(this.content) && !level.getBlockState(blockPos).liquid()) {
            level.destroyBlock(blockPos, true);
        }
        if (fluidIsSameAsContent) {
            int levelAtBlock = fluidState.getAmount();
            int total = levelAtBlock + amount;
            if (total > 8) {
                if (onlyModifyThatBlock) {
                    success = level.setBlock(blockPos, FFFluidUtils.getBlockForFluidByAmount(this.content, 8), 11);
                    remainder = total - 8;
                } else {
                    remainder = FFFluidUtils.addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull((LevelAccessor)level, blockPos, flowingFluid, amount);
                    success = remainder != amount;
                }
            } else {
                success = level.setBlock(blockPos, FFFluidUtils.getBlockForFluidByAmount(this.content, total), 11);
                remainder = 0;
            }
        } else {
            success = level.setBlock(blockPos, FFFluidUtils.getBlockForFluidByAmount(this.content, amount), 11);
            remainder = 0;
        }
        if (success) {
            this.playEmptySound((LivingEntity)player, (LevelAccessor)level, blockPos);
        }
        return success ? remainder : amount;
    }

    @Override
    public ItemStack ff$bucketOfAmount(ItemStack originalItemData, int amount) {
        if (amount == 0) {
            return Items.BUCKET.getDefaultInstance();
        }
        if (!FlowingFluids.config.isFluidAllowed(this.content)) {
            return originalItemData;
        }
        ItemStack resultBucket = originalItemData.copy();
        resultBucket.applyComponents(DataComponentMap.builder().set(DataComponents.DAMAGE, (Object)(8 - amount)).set(DataComponents.MAX_DAMAGE, (Object)8).build());
        return resultBucket;
    }

    public int getBarColor(ItemStack itemStack) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(this.content)) {
            return this.content.defaultFluidState().createLegacyBlock().getMapColor(null, null).col;
        }
        return super.getBarColor(itemStack);
    }

    @Override
    public Fluid ff$getFluid() {
        return this.content;
    }
}

