/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;

@Mixin(value={BreedGoal.class})
public class MixinEntityBreeding {
    @Shadow
    @Final
    protected Animal animal;
    @Shadow
    @Nullable
    protected Animal partner;

    @Inject(method={"breed()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void ff$drinkToBreed(CallbackInfo ci) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.drinkWaterToBreedAnimalChance > 0.0f && FlowingFluids.config.isWaterAllowed()) {
            if (this.animal.getRandom().nextFloat() < FlowingFluids.config.drinkWaterToBreedAnimalChance) {
                return;
            }
            Level world = this.animal.level();
            BlockPos pos = this.animal.blockPosition();
            for (BlockPos blockPos2 : BlockPos.betweenClosed((BlockPos)pos.offset(-8, -1, -8), (BlockPos)pos.offset(8, 1, 8))) {
                BlockState state = world.getBlockState(blockPos2);
                if (world.getFluidState(blockPos2).is(FluidTags.WATER)) {
                    FFFluidUtils.removeAmountFromFluidAtPosWithRemainder((LevelAccessor)world, blockPos2, (Fluid)Fluids.WATER, 1);
                    world.playSound(null, this.animal.getX(), this.animal.getY(), this.animal.getZ(), (SoundEvent)SoundEvents.GENERIC_DRINK.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    return;
                }
                if (!state.is(Blocks.WATER_CAULDRON)) continue;
                LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)world, (BlockPos)blockPos2);
                world.playSound(null, this.animal.getX(), this.animal.getY(), this.animal.getZ(), (SoundEvent)SoundEvents.GENERIC_DRINK.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return;
            }
            ci.cancel();
            this.animal.setAge(6000);
            this.animal.resetLove();
            assert (this.partner != null);
            this.partner.setAge(6000);
            this.partner.resetLove();
            RandomSource rand = this.animal.getRandom();
            if (world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                for (int i = 0; i < 8; ++i) {
                    server.sendParticles((ParticleOptions)new DustParticleOptions(9999746, 1.0f), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1, (double)((0.5f - rand.nextFloat()) * 3.0f), (double)(rand.nextFloat() * 2.0f), (double)((0.5f - rand.nextFloat()) * 3.0f), 1.0);
                }
                server.playSound(null, this.animal.getX(), this.animal.getY(), this.animal.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 0.25f, 1.0f);
            }
        }
    }
}

