/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import traben.flowing_fluids.FlowingFluids;

public class FFFluidUtils {
    @NotNull
    public static ResourceLocation res(String fullPath) {
        return ResourceLocation.parse((String)fullPath);
    }

    @NotNull
    public static ResourceLocation res(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static boolean canFluidFlowToNeighbourFromPos(LevelAccessor accessor, BlockPos pos, FlowingFluid fluid, int amount) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!FFFluidUtils.canFluidFlowFromPosToDirection(fluid, amount, accessor, pos, direction)) continue;
            return true;
        }
        return false;
    }

    public static FluidState getStateForFluidByAmount(Fluid fluid, int amount) {
        if (amount < 1) {
            return Fluids.EMPTY.defaultFluidState();
        }
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            return amount >= 8 ? flowing.getSource(false) : flowing.getFlowing(amount, false);
        }
        return amount >= 8 ? fluid.defaultFluidState() : (FluidState)fluid.defaultFluidState().trySetValue((Property)FlowingFluid.LEVEL, (Comparable)Integer.valueOf(amount));
    }

    public static BlockState getBlockForFluidByAmount(Fluid fluid, int amount) {
        return FFFluidUtils.getStateForFluidByAmount(fluid, amount).createLegacyBlock();
    }

    public static boolean setFluidStateAtPosToNewAmount(LevelAccessor levelAccessor, BlockPos pos, Fluid fluid, int newAmount) {
        if (newAmount < 1) {
            return FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, fluid);
        }
        BlockState blockState = levelAccessor.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer = (LiquidBlockContainer)block;
            if (newAmount == 8) {
                return liquidBlockContainer.placeLiquid(levelAccessor, pos, blockState, FFFluidUtils.getStateForFluidByAmount(fluid, newAmount));
            }
            Block block2 = blockState.getBlock();
            if (block2 instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block2;
                bucketPickup.pickupBlock(null, levelAccessor, pos, blockState);
                return true;
            }
            if (!blockState.canBeReplaced(fluid)) {
                return false;
            }
        }
        if (!blockState.isAir() && fluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)fluid;
            flowingFluid.beforeDestroyingBlock(levelAccessor, pos, blockState);
        }
        return levelAccessor.setBlock(pos, FFFluidUtils.getStateForFluidByAmount(fluid, newAmount).createLegacyBlock(), 3);
    }

    public static boolean removeAllFluidAtPos(LevelAccessor levelAccessor, BlockPos pos, Fluid fluid) {
        Block block;
        BlockState blockState = levelAccessor.getBlockState(pos);
        if (blockState.getBlock() instanceof LiquidBlockContainer && (block = blockState.getBlock()) instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            bucketPickup.pickupBlock(null, levelAccessor, pos, blockState);
            return true;
        }
        if (!blockState.isAir() && fluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)fluid;
            flowingFluid.beforeDestroyingBlock(levelAccessor, pos, blockState);
        }
        return levelAccessor.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
    }

    public static int removeAmountFromFluidAtPosWithRemainder(LevelAccessor levelAccessor, BlockPos pos, Fluid fluid, int removeAmount) {
        FluidState state = levelAccessor.getFluidState(pos);
        if (state.getType().isSame(fluid)) {
            int currentAmount = state.getAmount();
            if (currentAmount <= removeAmount) {
                FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, fluid);
                return removeAmount - currentAmount;
            }
            FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, currentAmount - removeAmount);
            return 0;
        }
        return removeAmount;
    }

    public static int addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull(LevelAccessor levelAccessor, BlockPos pos, FlowingFluid fluid, int addAmount) {
        Pair<Integer, Runnable> data = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, pos, addAmount, fluid);
        if ((Integer)data.first() != addAmount) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return addAmount;
    }

    public static int addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull(LevelAccessor levelAccessor, BlockPos pos, FlowingFluid fluid, int addAmount, boolean canSpreadUp, boolean canSpreadDown) {
        Pair<Integer, Runnable> data = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, pos, addAmount, fluid, 80, canSpreadUp, canSpreadDown);
        if ((Integer)data.first() != addAmount) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return addAmount;
    }

    public static int addAmountToFluidAtPosWithRemainder(LevelAccessor levelAccessor, BlockPos pos, Fluid fluid, int addAmount) {
        FluidState state = levelAccessor.getFluidState(pos);
        if (state.isEmpty() || state.getType().isSame(fluid)) {
            int currentAmount = state.getAmount();
            if (currentAmount == 8) {
                return addAmount;
            }
            if (currentAmount + addAmount <= 8) {
                if (FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, currentAmount + addAmount)) {
                    return 0;
                }
            } else if (FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, 8)) {
                return currentAmount + addAmount - 8;
            }
        }
        return addAmount;
    }

    public static boolean canFluidFlowFromPosToDirection(FlowingFluid fluid, int amount, LevelAccessor levelAccessor, BlockPos fromPos, Direction direction) {
        BlockPos blockPos2 = fromPos.relative(direction);
        BlockState blockState2 = levelAccessor.getBlockState(blockPos2);
        FluidState fluidState2 = blockState2.getFluidState();
        return FFFluidUtils.canFluidFlowFromPosToDirection(fluid, amount, (BlockGetter)levelAccessor, fromPos, levelAccessor.getBlockState(fromPos), direction, blockPos2, blockState2, fluidState2);
    }

    public static boolean canFluidFlowFromPosToDirection(FlowingFluid sourceFluid, int sourceAmount, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState2) {
        return (fluidState2.canBeReplacedWith(blockGetter, blockPos2, (Fluid)sourceFluid, direction) || FFFluidUtils.canFitIntoFluid((Fluid)sourceFluid, fluidState2, direction, sourceAmount, blockState2)) && sourceFluid.canPassThroughWall(direction, blockGetter, blockPos, blockState, blockPos2, blockState2) && sourceFluid.canHoldFluid(blockGetter, blockPos2, blockState2, (Fluid)sourceFluid);
    }

    public static boolean canFluidFlowFromPosToDirectionFitOverride(FlowingFluid sourceFluid, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2) {
        return sourceFluid.canPassThroughWall(direction, blockGetter, blockPos, blockState, blockPos2, blockState2) && sourceFluid.canHoldFluid(blockGetter, blockPos2, blockState2, (Fluid)sourceFluid);
    }

    private static boolean canFitIntoFluid(Fluid thisFluid, FluidState fluidStateTo, Direction direction, int amount, BlockState blockStateTo) {
        if (fluidStateTo.isEmpty()) {
            return true;
        }
        if (fluidStateTo.getType().isSame(thisFluid)) {
            if (direction == Direction.DOWN) {
                return fluidStateTo.getAmount() < 8;
            }
            return fluidStateTo.getAmount() < amount;
        }
        return false;
    }

    public static Pair<Integer, Runnable> placeConnectedFluidAmountAndPlaceAction(LevelAccessor levelAccessor, BlockPos blockPos, int amountToPlace, FlowingFluid fluid) {
        return FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, blockPos, amountToPlace, fluid, 80, true, true);
    }

    public static Pair<Integer, Runnable> placeConnectedFluidAmountAndPlaceAction(LevelAccessor levelAccessor, BlockPos blockPos, int amountToPlace, FlowingFluid fluid, int depth, boolean doUp, boolean doDown) {
        FluidState originalState = levelAccessor.getFluidState(blockPos);
        int originalAmount = originalState.getAmount();
        if (originalState.getType().isSame((Fluid)fluid) && originalAmount > 0) {
            if (originalAmount + amountToPlace <= 8) {
                return Pair.of((Object)0, () -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, blockPos, (Fluid)fluid, originalAmount + amountToPlace));
            }
            ArrayList<BlockPos> toCheck = new ArrayList<BlockPos>();
            toCheck.add(blockPos);
            Consumer<BlockPos> addSurroundingPositions = blockPos1 -> {
                BlockPos down;
                BlockPos up;
                for (Direction direction : FFFluidUtils.getCardinalsShuffle(levelAccessor.getRandom())) {
                    BlockPos offset = blockPos1.relative(direction);
                    if (toCheck.contains(offset)) continue;
                    toCheck.add(offset);
                }
                if (doUp && !toCheck.contains(up = blockPos1.above())) {
                    toCheck.add(up);
                }
                if (doDown && !toCheck.contains(down = blockPos1.below())) {
                    toCheck.add(down);
                }
            };
            addSurroundingPositions.accept(blockPos);
            ArrayList<Runnable> onSuccessPlacers = new ArrayList<Runnable>();
            int amountLeftToPlace = amountToPlace;
            for (int i = 0; i < toCheck.size(); ++i) {
                BlockPos pos = (BlockPos)toCheck.get(i);
                if (toCheck.size() > depth) break;
                FluidState state = levelAccessor.getFluidState(pos);
                if (!fluid.isSame(state.getType()) && (!state.isEmpty() || !levelAccessor.getBlockState(pos).isAir())) continue;
                int space = 8 - state.getAmount();
                if (space > 0) {
                    if (space >= amountLeftToPlace) {
                        int newAmount = state.getAmount() + amountLeftToPlace;
                        onSuccessPlacers.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (Fluid)fluid, newAmount));
                        amountLeftToPlace = 0;
                        break;
                    }
                    onSuccessPlacers.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (Fluid)fluid, 8));
                    amountLeftToPlace -= space;
                }
                addSurroundingPositions.accept(pos);
            }
            if (amountLeftToPlace == amountToPlace) {
                return Pair.of((Object)amountToPlace, null);
            }
            return Pair.of((Object)amountLeftToPlace, () -> onSuccessPlacers.forEach(Runnable::run));
        }
        return Pair.of((Object)amountToPlace, null);
    }

    public static int collectConnectedFluidAmountAndRemove(LevelAccessor levelAccessor, BlockPos blockPos, int minAmountRequired, int maxAmountToFind, FlowingFluid fluid) {
        Pair<Integer, Runnable> data = FFFluidUtils.collectConnectedFluidAmountAndRemoveAction(levelAccessor, blockPos, minAmountRequired, maxAmountToFind, fluid);
        if ((Integer)data.first() != 0) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return 0;
    }

    public static Pair<Integer, Runnable> collectConnectedFluidAmountAndRemoveAction(LevelAccessor levelAccessor, BlockPos blockPos, int minAmountRequired, int maxAmountToFind, FlowingFluid fluid) {
        return FFFluidUtils.collectConnectedFluidAmountAndRemoveAction(levelAccessor, blockPos, minAmountRequired, maxAmountToFind, fluid, 40);
    }

    public static Pair<Integer, Runnable> collectConnectedFluidAmountAndRemoveAction(LevelAccessor levelAccessor, BlockPos blockPos, int minAmountRequired, int maxAmountToFind, FlowingFluid fluid, int depth) {
        FluidState originalState = levelAccessor.getFluidState(blockPos);
        int originalAmount = originalState.getAmount();
        if (originalState.getType().isSame((Fluid)fluid) && originalAmount > 0) {
            if (originalAmount >= maxAmountToFind) {
                return Pair.of((Object)maxAmountToFind, () -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, blockPos, (Fluid)fluid, originalAmount - maxAmountToFind));
            }
            ArrayList<BlockPos> toCheck = new ArrayList<BlockPos>();
            toCheck.add(blockPos);
            for (Direction direction : Direction.allShuffled((RandomSource)levelAccessor.getRandom())) {
                BlockPos offset = blockPos.relative(direction);
                toCheck.add(offset);
            }
            ArrayList<Runnable> onSuccessAirSetters = new ArrayList<Runnable>();
            int foundAmount = 0;
            for (int i = 0; i < toCheck.size(); ++i) {
                int amount;
                BlockPos pos = (BlockPos)toCheck.get(i);
                if (toCheck.size() > depth) break;
                FluidState state = levelAccessor.getFluidState(pos);
                if (!fluid.isSame(state.getType()) || (amount = state.getAmount()) <= 0) continue;
                if ((foundAmount += amount) > maxAmountToFind) {
                    int finalLevel = foundAmount - maxAmountToFind;
                    onSuccessAirSetters.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (Fluid)fluid, finalLevel));
                    foundAmount = maxAmountToFind;
                    break;
                }
                onSuccessAirSetters.add(() -> FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, (Fluid)fluid));
                if (foundAmount == maxAmountToFind) break;
                for (Direction direction : Direction.allShuffled((RandomSource)levelAccessor.getRandom())) {
                    BlockPos offset = pos.relative(direction);
                    if (toCheck.contains(offset)) continue;
                    toCheck.add(offset);
                }
            }
            if (foundAmount < minAmountRequired) {
                return Pair.of((Object)0, null);
            }
            return Pair.of((Object)foundAmount, () -> onSuccessAirSetters.forEach(Runnable::run));
        }
        return Pair.of((Object)0, null);
    }

    public static List<Direction> getCardinalsShuffle(RandomSource random) {
        return Direction.Plane.HORIZONTAL.shuffledCopy(random);
    }

    private static boolean checkBlockIsNonDisplacer(Fluid fluid, BlockState state) {
        return FlowingFluids.nonDisplacerTags.stream().anyMatch(pair -> (pair.first() == Fluids.EMPTY || ((Fluid)pair.first()).isSame(fluid)) && state.is((TagKey)pair.second())) || FlowingFluids.nonDisplacers.stream().anyMatch(pair -> (pair.first() == Fluids.EMPTY || ((Fluid)pair.first()).isSame(fluid)) && state.is((Block)pair.second()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void displaceFluids(Level level, BlockPos pos, BlockState state, int flags, LevelChunk levelChunk, BlockState originalState) {
        block10: {
            Fluid fluid;
            if (!level.isClientSide() && FlowingFluids.config.enableMod && FlowingFluids.config.enableDisplacement && !FlowingFluids.isManeuveringFluids && !originalState.getFluidState().isEmpty() && (fluid = originalState.getFluidState().getType()) instanceof FlowingFluid) {
                FlowingFluid flowSource = (FlowingFluid)fluid;
                if (!(state.isAir() || !state.getFluidState().isEmpty() || (flags & 0x40) == 64 || state.getBlock() instanceof LiquidBlockContainer && originalState.getBlock() instanceof BucketPickup || FFFluidUtils.checkBlockIsNonDisplacer((Fluid)flowSource, state))) {
                    FlowingFluids.isManeuveringFluids = true;
                    try {
                        int amountRemaining = originalState.getFluidState().getAmount();
                        for (Direction direction : FFFluidUtils.getCardinalsShuffle(level.getRandom())) {
                            BlockPos offset = pos.relative(direction);
                            BlockState offsetState = level.getBlockState(offset);
                            if (offsetState.getFluidState().getType() instanceof FlowingFluid) {
                                if ((amountRemaining = FFFluidUtils.addAmountToFluidAtPosWithRemainder((LevelAccessor)level, offset, (Fluid)flowSource, amountRemaining)) != 0) continue;
                                break;
                            }
                            if (!offsetState.isAir()) continue;
                            level.setBlock(offset, originalState.getFluidState().createLegacyBlock(), 3);
                            amountRemaining = 0;
                            break;
                        }
                        if (amountRemaining <= 0) break block10;
                        BlockPos.MutableBlockPos posTraversing = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
                        int height = levelChunk.getMaxBuildHeight();
                        while (amountRemaining > 0 && posTraversing.getY() < height) {
                            posTraversing.move(Direction.UP);
                            BlockState offsetState = level.getBlockState((BlockPos)posTraversing);
                            if (offsetState.getFluidState().getType() instanceof FlowingFluid) {
                                amountRemaining = FFFluidUtils.addAmountToFluidAtPosWithRemainder((LevelAccessor)level, (BlockPos)posTraversing, (Fluid)flowSource, amountRemaining);
                                continue;
                            }
                            if (offsetState.isAir()) {
                                level.setBlock((BlockPos)posTraversing, originalState.getFluidState().createLegacyBlock(), 3);
                                amountRemaining = 0;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        FlowingFluids.isManeuveringFluids = false;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchInfiniteBiomes(Holder<Biome> biome) {
        if (FlowingFluids.infiniteBiomeTags.stream().anyMatch(arg_0 -> biome.is(arg_0))) return true;
        if (!FlowingFluids.infiniteBiomes.stream().anyMatch(arg_0 -> biome.is(arg_0))) return false;
        return true;
    }
}

