/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.api;

import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.FlowingFluidsPlatform;
import traben.flowing_fluids.api.FlowingFluidsAPI;
import traben.flowing_fluids.config.FFConfig;

public class FlowingFluidsApiImpl
implements FlowingFluidsAPI {
    private final String modid;

    FlowingFluidsApiImpl(String modIdRequestingAPI) {
        this.modid = modIdRequestingAPI;
    }

    @Override
    public boolean isModEnabled() {
        return this.getConfig().enableMod;
    }

    @Override
    public boolean isModCurrentlyMovingFluids() {
        return FlowingFluids.isManeuveringFluids;
    }

    @Override
    public boolean doesModifyThisFluid(@NotNull Fluid fluid) {
        return this.getConfig().isFluidAllowed(fluid);
    }

    @Override
    public boolean doesModifyThisFluid(@NotNull FluidState fluid) {
        return this.getConfig().isFluidAllowed(fluid);
    }

    @Override
    public void disableThisFluid(@NotNull Fluid fluid, @Nullable MinecraftServer server) {
        if (fluid == Fluids.EMPTY) {
            return;
        }
        FlowingFluid flowing = this.fluidCheck(fluid, "disableThisFluid");
        if (flowing == null) {
            return;
        }
        this.getConfig().fluidBlacklist.add((Object)BuiltInRegistries.FLUID.getKey((Object)flowing.getSource()).toString());
        this.getConfig().fluidBlacklist.add((Object)BuiltInRegistries.FLUID.getKey((Object)flowing.getFlowing()).toString());
        this.setConfig(this.getConfig(), server);
    }

    @Override
    public void disableThisFluid(@NotNull FluidState fluid, @Nullable MinecraftServer server) {
        this.disableThisFluid(fluid.getType(), server);
    }

    @Override
    public void enableThisFluid(@NotNull Fluid fluid, @Nullable MinecraftServer server) {
        if (fluid == Fluids.EMPTY) {
            return;
        }
        FlowingFluid flowing = this.fluidCheck(fluid, "enableThisFluid");
        if (flowing == null) {
            return;
        }
        this.getConfig().fluidBlacklist.remove((Object)BuiltInRegistries.FLUID.getKey((Object)flowing.getSource()).toString());
        this.getConfig().fluidBlacklist.remove((Object)BuiltInRegistries.FLUID.getKey((Object)flowing.getFlowing()).toString());
        this.setConfig(this.getConfig(), server);
    }

    @Override
    public void enableThisFluid(@NotNull FluidState fluid, @Nullable MinecraftServer server) {
        this.enableThisFluid(fluid.getType(), server);
    }

    @Override
    public FFConfig getConfig() {
        return FlowingFluids.config;
    }

    @Override
    public void setConfig(@NotNull FFConfig config, @Nullable MinecraftServer server) {
        FlowingFluids.config = config;
        FlowingFluids.saveConfig();
        if (server != null) {
            FlowingFluids.info("Flowing Fluids config was changed by the " + this.modid + " mod, and will be applied to the server.");
            server.getPlayerList().getPlayers().forEach(FlowingFluidsPlatform::sendConfigToClient);
        } else {
            FlowingFluids.warn("Flowing Fluids config was changed by the " + this.modid + " mod, but no server was provided. This will only modify the local config for single-player etc.");
        }
    }

    private boolean clientCheck(LevelAccessor level, String str) {
        if (level.isClientSide()) {
            FlowingFluids.warn("Flowing Fluids API: " + str + " was called on a client side level. This does nothing. Mod that called it: " + this.modid);
            return true;
        }
        return false;
    }

    @Nullable
    private FlowingFluid fluidCheck(Fluid fluid, String str) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            return flowing;
        }
        FlowingFluids.warn("Flowing Fluids API: " + str + " was called on a non-flowing fluid. This is not allowed. Mod that called it: " + this.modid);
        return null;
    }

    @Override
    public int removeFluidAmountFromPos(@NotNull LevelAccessor level, @NotNull BlockPos startPos, @NotNull Fluid fluid, int minAmount, int maxAmount) {
        if (this.clientCheck(level, "removeFluidAmountFromPos")) {
            return 0;
        }
        FlowingFluid flowing = this.fluidCheck(fluid, "removeFluidAmountFromPos");
        if (flowing == null) {
            return 0;
        }
        return FFFluidUtils.collectConnectedFluidAmountAndRemove(level, startPos, minAmount, maxAmount, flowing);
    }

    @Override
    public int placeFluidAmountFromPos(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull Fluid fluid, int amount, boolean canSpreadUp, boolean canSpreadDown) {
        if (this.clientCheck(level, "placeFluidAmountFromPos")) {
            return amount;
        }
        FlowingFluid flowing = this.fluidCheck(fluid, "placeFluidAmountFromPos");
        if (flowing == null) {
            return 0;
        }
        return FFFluidUtils.addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull(level, pos, flowing, amount, canSpreadUp, canSpreadDown);
    }

    @Override
    public void registerBlockTagThatWontDisplaceFluid(@NotNull Fluid fluid, @NotNull TagKey<Block> tag) {
        FlowingFluids.nonDisplacerTags.add((Pair<Fluid, TagKey<Block>>)Pair.of((Object)fluid, tag));
    }

    @Override
    public void registerBlockThatWontDisplaceFluid(@NotNull Fluid fluid, @NotNull Block block) {
        FlowingFluids.nonDisplacers.add((Pair<Fluid, Block>)Pair.of((Object)fluid, (Object)block));
    }

    @Override
    public void registerBiomeTagThatHasInfiniteWaterRefilling(@NotNull TagKey<Biome> tag) {
        FlowingFluids.infiniteBiomeTags.add(tag);
    }

    @Override
    public void registerBiomeThatHasInfiniteWaterRefilling(@NotNull ResourceKey<Biome> biome) {
        FlowingFluids.infiniteBiomes.add(biome);
    }

    @Override
    public boolean doesBiomeInfiniteWaterRefill(@NotNull Holder<Biome> biome) {
        return FFFluidUtils.matchInfiniteBiomes(biome);
    }

    @Override
    public boolean modifyFluidAmountAtPos(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull FlowingFluidsAPI.FluidAmountModifier fluidAmountModifier) {
        if (this.clientCheck(level, "modifyFluidAmountAtPos")) {
            return false;
        }
        FluidState fluid = level.getFluidState(pos);
        if (this.getConfig().isFluidAllowed(fluid)) {
            int amount;
            Fluid type = fluid.getType();
            Pair<Fluid, Integer> data = fluidAmountModifier.getNewAmount(type, amount = fluid.getAmount());
            if (data.first() == type && (Integer)data.second() == amount) {
                return false;
            }
            return FFFluidUtils.setFluidStateAtPosToNewAmount(level, pos, (Fluid)data.first(), Mth.clamp((int)((Integer)data.second()), (int)0, (int)8));
        }
        return false;
    }

    @Override
    public boolean modifyFluidAmountAtPos(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull Fluid type, int amount) {
        if (this.clientCheck(level, "modifyFluidAmountAtPos")) {
            return false;
        }
        if (this.getConfig().isFluidAllowed(type)) {
            return FFFluidUtils.setFluidStateAtPosToNewAmount(level, pos, type, Mth.clamp((int)amount, (int)0, (int)8));
        }
        return false;
    }
}

