/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.LavaFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;

@Mixin(value={LavaFluid.class})
public abstract class MixinLavaFluid
extends FlowingFluid {
    @Shadow
    public abstract boolean isSame(Fluid var1);

    @Inject(method={"canBeReplacedWith(Lnet/minecraft/world/level/material/FluidState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/Fluid;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void flowing_fluids$removeHeightCheck(FluidState fluidState, BlockGetter blockGetter, BlockPos blockPos, Fluid fluid, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        if (FlowingFluids.config.enableMod && !((Boolean)cir.getReturnValue()).booleanValue() && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            cir.setReturnValue((Object)fluid.isSame((Fluid)Fluids.WATER));
        }
    }

    @Inject(method={"beforeDestroyingBlock(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void ff$fizzOnlyForNonLava(LevelAccessor level, BlockPos pos, BlockState state, CallbackInfo ci) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this) && this.isSame(state.getFluidState().getType())) {
            ci.cancel();
        }
    }

    @Inject(method={"getSlopeFindDistance(Lnet/minecraft/world/level/LevelReader;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void ff$modifySlopeDistance(LevelReader level, CallbackInfoReturnable<Integer> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            cir.setReturnValue((Object)Mth.clamp((int)(level.dimensionType().ultraWarm() ? FlowingFluids.config.lavaNetherFlowDistance : FlowingFluids.config.lavaFlowDistance), (int)1, (int)8));
        }
    }

    @Inject(method={"getTickDelay(Lnet/minecraft/world/level/LevelReader;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void ff$modifyTickDelay(LevelReader level, CallbackInfoReturnable<Integer> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            cir.setReturnValue((Object)Mth.clamp((int)(level.dimensionType().ultraWarm() ? FlowingFluids.config.lavaNetherTickDelay : FlowingFluids.config.lavaTickDelay), (int)1, (int)255));
        }
    }

    @Inject(method={"randomTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/FluidState;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="HEAD")})
    private void ff$callSuper(Level level, BlockPos pos, FluidState state, RandomSource random, CallbackInfo ci) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            super.randomTick(level, pos, state, random);
        }
    }

    @Inject(method={"spreadTo(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/material/FluidState;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/LavaFluid;fizz(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;)V")})
    private void ff$consumeLevelStoneCreation(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, Direction direction, FluidState fluidState, CallbackInfo ci) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            BlockPos above = blockPos.above();
            FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, above, (Fluid)Fluids.LAVA, levelAccessor.getFluidState(above).getAmount() - 1);
        }
    }
}

