/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.neoforge.mixin.create;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.config.FFConfig;

@Pseudo
@Mixin(value={WaterWheelBlockEntity.class})
public abstract class MixinWaterWheel
extends GeneratingKineticBlockEntity {
    @Shadow(remap=false)
    protected abstract Set<BlockPos> getOffsetsToCheck();

    @Shadow(remap=false)
    public abstract void setFlowScoreAndUpdate(int var1);

    public MixinWaterWheel(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"determineAndApplyFlowScore()V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void ff$modifyWaterCheck(CallbackInfo ci) {
        try {
            if (!FlowingFluids.config.enableMod || FlowingFluids.config.create_waterWheelMode == FFConfig.CreateWaterWheelMode.REQUIRE_FLOW || this.level == null) {
                return;
            }
            if (FlowingFluids.config.create_waterWheelMode.isRiver() && (!this.level.getBiome(this.worldPosition).is(BiomeTags.IS_RIVER) || Math.abs(this.worldPosition.getY() - this.level.getSeaLevel()) > 5)) {
                if (FlowingFluids.config.create_waterWheelMode.isRiverOnly()) {
                    ci.cancel();
                    this.setFlowScoreAndUpdate(0);
                }
                return;
            }
            ci.cancel();
            boolean fluidCanBeAnyHeight = !FlowingFluids.config.create_waterWheelMode.needsFullFluid();
            boolean oppositeSpin = FlowingFluids.config.create_waterWheelMode.isCounterSpin();
            boolean alwaysSpin = FlowingFluids.config.create_waterWheelMode.always();
            boolean lava = false;
            int score = 0;
            for (BlockPos blockPos : this.getOffsetsToCheck()) {
                BlockPos checkPos = blockPos.offset((Vec3i)this.worldPosition);
                FluidState fState = this.level.getFluidState(checkPos);
                lava |= fState.getType().isSame((Fluid)Fluids.LAVA);
                if (!alwaysSpin && (fState.isEmpty() || !fluidCanBeAnyHeight && fState.getAmount() != 8)) continue;
                score += oppositeSpin ? -1 : 1;
            }
            if (score != 0 && !this.level.isClientSide()) {
                this.award(lava ? AllAdvancements.LAVA_WHEEL : AllAdvancements.WATER_WHEEL);
            }
            this.setFlowScoreAndUpdate(score);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

