/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.flowing_fluids.FFBucketItem;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;

@Mixin(value={DispenserBlock.class}, priority=2000)
public class MixinDispenserBlock {
    @Shadow
    @Final
    public static Map<Item, DispenseItemBehavior> DISPENSER_REGISTRY;

    @Inject(method={"registerBehavior(Lnet/minecraft/world/level/ItemLike;Lnet/minecraft/core/dispenser/DispenseItemBehavior;)V"}, at={@At(value="TAIL")})
    private static void ff$wrapBehaviour(ItemLike item, DispenseItemBehavior behavior, CallbackInfo ci) {
        Item item2 = item.asItem();
        if (item2 instanceof FFBucketItem) {
            BiFunction<BlockSource, ItemStack, ItemStack> biFunction;
            FFBucketItem bucket = (FFBucketItem)item2;
            if (behavior instanceof DefaultDispenseItemBehavior) {
                DefaultDispenseItemBehavior d = (DefaultDispenseItemBehavior)behavior;
                biFunction = (arg_0, arg_1) -> ((DefaultDispenseItemBehavior)d).execute(arg_0, arg_1);
            } else {
                biFunction = (arg_0, arg_1) -> ((DispenseItemBehavior)behavior).dispense(arg_0, arg_1);
            }
            final BiFunction<BlockSource, ItemStack, ItemStack> delegate = biFunction;
            DefaultDispenseItemBehavior wrappedBehaviour = bucket == Items.BUCKET ? new DefaultDispenseItemBehavior(){

                @NotNull
                public ItemStack execute(BlockSource blockSource, ItemStack item) {
                    Item item2;
                    if (FlowingFluids.config.enableMod && (item2 = item.getItem()) instanceof FFBucketItem) {
                        FFBucketItem bucket = (FFBucketItem)item2;
                        BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                        ServerLevel level = blockSource.level();
                        FluidState fState = level.getFluidState(blockPos);
                        Fluid fluid = fState.getType();
                        if (fluid instanceof FlowingFluid) {
                            FlowingFluid flowingFluid = (FlowingFluid)fluid;
                            if (FlowingFluids.config.isFluidAllowed(fState) && fState.getAmount() > 0 && fState.getAmount() < 8) {
                                int found = FFFluidUtils.collectConnectedFluidAmountAndRemove((LevelAccessor)level, blockPos, 1, 8, flowingFluid);
                                if (found > 0) {
                                    return this.consumeWithRemainder(blockSource, item, bucket.ff$bucketOfAmount(flowingFluid.getBucket().getDefaultInstance(), found));
                                }
                                return item;
                            }
                        }
                    }
                    return (ItemStack)delegate.apply(blockSource, item);
                }
            } : new DefaultDispenseItemBehavior(){

                @NotNull
                public ItemStack execute(BlockSource blockSource, ItemStack item) {
                    FFBucketItem bucket;
                    Item item2;
                    if (FlowingFluids.config.enableMod && (item2 = item.getItem()) instanceof FFBucketItem && FlowingFluids.config.isFluidAllowed((bucket = (FFBucketItem)item2).ff$getFluid())) {
                        BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                        ServerLevel level = blockSource.level();
                        FluidState fState = level.getFluidState(blockPos);
                        if (fState.getAmount() > 0 || item.getDamageValue() > 0) {
                            int amountInBucket = 8 - item.getDamageValue();
                            int remainder = bucket.ff$emptyContents_AndGetRemainder(null, (Level)level, blockPos, null, amountInBucket, false);
                            if (remainder != amountInBucket) {
                                ((DispensibleContainerItem)bucket).checkExtraContent(null, (Level)level, item, blockPos);
                                return this.consumeWithRemainder(blockSource, item, bucket.ff$bucketOfAmount(item, remainder));
                            }
                            return item;
                        }
                    }
                    return (ItemStack)delegate.apply(blockSource, item);
                }
            };
            DISPENSER_REGISTRY.put(item.asItem(), (DispenseItemBehavior)wrappedBehaviour);
        }
    }
}

