/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;

@Mixin(value={WaterFluid.class})
public abstract class MixinWaterFluid
extends FlowingFluid {
    @Shadow
    public abstract int getDropOff(LevelReader var1);

    @Shadow
    public abstract boolean isSame(Fluid var1);

    protected void randomTick(Level level, BlockPos blockPos, FluidState fluidState, RandomSource randomSource) {
        super.randomTick(level, blockPos, fluidState, randomSource);
        if (level.isClientSide() || fluidState.isEmpty() || !FlowingFluids.config.enableMod || !FlowingFluids.config.isFluidAllowed(fluidState)) {
            return;
        }
        int amount = fluidState.getAmount();
        if (amount < 8) {
            if (this.ff$tryBiomeFillOrDrain(level, blockPos, amount, level.random.nextFloat())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was filled by biome at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.oceanRiverSwampRefillChance);
                }
                return;
            }
            if (this.ff$tryRainFill(level, blockPos, level.random.nextFloat())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was filled by rain at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.rainRefillChance);
                }
                return;
            }
            if (this.ff$tryEvaporateNether(level, blockPos, amount, level.random.nextFloat())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was evaporated via Nether at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.evaporationChance);
                }
                return;
            }
            if (this.ff$tryEvaporate(level, blockPos, amount, level.random.nextFloat()) && FlowingFluids.config.printRandomTicks) {
                FlowingFluids.info("--- Water was evaporated - non Nether at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.evaporationChance);
            }
        } else if (this.ff$tryRainFill(level, blockPos, level.random.nextFloat()) && FlowingFluids.config.printRandomTicks) {
            FlowingFluids.info("--- Water was filled by rain at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.rainRefillChance);
        }
    }

    @Unique
    private boolean ff$tryRainFill(Level level, BlockPos blockPos, float chance) {
        int amount;
        Pair<Integer, Runnable> result;
        if (chance < FlowingFluids.config.rainRefillChance && level.isRaining() && level.canSeeSky(blockPos.above()) && (Integer)(result = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction((LevelAccessor)level, blockPos, amount = level.isThundering() ? 2 : 1, this, 40, FlowingFluids.config.rainFillsWaterHigher, false)).first() != amount) {
            ((Runnable)result.second()).run();
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryBiomeFillOrDrain(Level level, BlockPos blockPos, int amount, float chance) {
        FluidState below;
        if (level.getSeaLevel() > blockPos.getY() && blockPos.getY() > 0) {
            if (amount < 8 && chance < FlowingFluids.config.oceanRiverSwampRefillChance && level.getBrightness(LightLayer.SKY, blockPos) > 0 && FFFluidUtils.matchInfiniteBiomes((Holder<Biome>)level.getBiome(blockPos))) {
                level.setBlockAndUpdate(blockPos, FFFluidUtils.getBlockForFluidByAmount((Fluid)this, amount + 2));
                return true;
            }
        } else if (level.getSeaLevel() == blockPos.getY() && (chance < FlowingFluids.config.infiniteWaterBiomeNonConsumeChance || chance < FlowingFluids.config.oceanRiverSwampRefillChance) && (below = level.getFluidState(blockPos.below())).getAmount() == 8 && below.is(FluidTags.WATER) && level.getBrightness(LightLayer.SKY, blockPos) > 0 && FFFluidUtils.matchInfiniteBiomes((Holder<Biome>)level.getBiome(blockPos))) {
            level.setBlockAndUpdate(blockPos, FFFluidUtils.getBlockForFluidByAmount((Fluid)this, amount - 2));
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryEvaporate(Level level, BlockPos blockPos, int amount, float chance) {
        if (chance < FlowingFluids.config.evaporationChance && amount <= this.getDropOff((LevelReader)level) && level.isDay() && !level.isRaining() && level.getFluidState(blockPos.below()).isEmpty()) {
            level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryEvaporateNether(Level level, BlockPos blockPos, int amount, float chance) {
        if (chance < FlowingFluids.config.evaporationNetherChance && level.getBiome(blockPos).is(BiomeTags.IS_NETHER)) {
            if (amount == 1) {
                level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
            } else {
                level.setBlockAndUpdate(blockPos, FFFluidUtils.getBlockForFluidByAmount((Fluid)this, amount - 3));
            }
            return true;
        }
        return false;
    }

    @Inject(method={"getSlopeFindDistance(Lnet/minecraft/world/level/LevelReader;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void ff$modifySlopeDistance(LevelReader level, CallbackInfoReturnable<Integer> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            cir.setReturnValue((Object)Mth.clamp((int)FlowingFluids.config.waterFlowDistance, (int)1, (int)8));
        }
    }

    @Inject(method={"getTickDelay(Lnet/minecraft/world/level/LevelReader;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void ff$modifyTickDelay(LevelReader level, CallbackInfoReturnable<Integer> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            cir.setReturnValue((Object)Mth.clamp((int)FlowingFluids.config.waterTickDelay, (int)1, (int)255));
        }
    }
}

