/*
 * Copyright 2025 Gurkan
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package me.gurkz.superdupermod.mixin;

import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2344.class)
public abstract class FarmlandMixin {

    @Inject(
            method = "fallOn",
            at = @At("HEAD"),
            cancellable = true
    )
    private void disableTramplingWithFeatherFalling(
            class_1937 level, class_2680 blockState, class_2338 blockPos, class_1297 entity, double fallDistance, CallbackInfo ci
    ) {
        if (!(entity instanceof class_1309 livingEntity)) return;

        class_1799 boots = livingEntity.method_6118(class_1304.field_6166);

        // Fetch the Feather Falling enchantment holder properly via the registry
        class_6880.class_6883<class_1887> featherHolder = level
                .method_30349()
                .method_30530(class_7924.field_41265)
                .method_46747(class_1893.field_9129);

        // Get the level of Feather Falling on the boots
        int featherLevel = class_1890.method_8225(featherHolder, boots);

        // Cancel trampling if Feather Falling or Slow Falling is active
        if (featherLevel > 0 || livingEntity.method_6059(class_1294.field_5906)) {
            ci.cancel();
        }
    }
}
