/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.bugfixes.entities.desync;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.bugfixes.entities.desync.IPrevMotion;
import mod.acgaming.universaltweaks.config.UTConfigBugfixes;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class UTEntityDesync {
    public static final Set<Class<? extends Entity>> blacklistedEntityEntries = new ObjectOpenHashSet();

    public static void initBlacklistedEntityEntries() {
        blacklistedEntityEntries.clear();
        try {
            for (String entry : UTConfigBugfixes.ENTITIES.ENTITY_DESYNC.utEntityDesyncBlacklist) {
                Class entityClass;
                EntityEntry entityEntry;
                ResourceLocation resLoc = new ResourceLocation(entry);
                if (!ForgeRegistries.ENTITIES.containsKey(resLoc) || (entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(resLoc)) == null || (entityClass = entityEntry.getEntityClass()) == null) continue;
                blacklistedEntityEntries.add(entityClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UniversalTweaks.LOGGER.info("Entity Desync blacklist initialized");
    }

    public static boolean isBlacklisted(Entity entity) {
        return blacklistedEntityEntries.contains(entity.getClass()) || !((IPrevMotion)entity).hasSuperUpdate();
    }
}

