/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.roost.contenttweaker;

import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import com.teamacronymcoders.contenttweaker.modules.chickens.ChickenFactory;
import com.teamacronymcoders.contenttweaker.modules.chickens.ChickenRepresentation;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class UTChickenRegistration {
    public static void utRegisterChickens() {
        for (ChickenRepresentation chickenRepresentation : ChickenFactory.CHICKEN_REPRESENTATIONS) {
            ChickensRegistryItem item = new ChickensRegistryItem(new ResourceLocation("contenttweaker", chickenRepresentation.name), chickenRepresentation.name, chickenRepresentation.textureLocation.getInternal(), ItemStack.field_190927_a, chickenRepresentation.backgroundColor.getIntColor(), chickenRepresentation.foregroundColor.getIntColor(), null, null);
            ChickensRegistry.register((ChickensRegistryItem)item);
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            CraftTweakerAPI.logInfo((String)"UTChickenModuleMixin ::: Dumping chicken registry!");
            for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                CraftTweakerAPI.logInfo((String)("UTChickenModuleMixin ::: " + chicken.getRegistryName().toString()));
            }
        }
    }

    public static void utInitChickens() {
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            CraftTweakerAPI.logInfo((String)"UTChickenModuleMixin ::: Dumping chicken registry! (in init)");
            for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                CraftTweakerAPI.logInfo((String)("UTChickenModuleMixin ::: " + chicken.getRegistryName().toString()));
            }
        }
        for (ChickenRepresentation chickenRepresentation : ChickenFactory.CHICKEN_REPRESENTATIONS) {
            ChickensRegistryItem parentTwoItem;
            ResourceLocation registryName = new ResourceLocation("contenttweaker", chickenRepresentation.name);
            ChickensRegistryItem item = ChickensRegistry.getByRegistryName((String)registryName.toString());
            if (item == null) {
                CraftTweakerAPI.logError((String)("Failed to find chicken item " + registryName + " in registry"));
                return;
            }
            ChickensRegistryItem parentOneItem = chickenRepresentation.parentOne != null ? ChickensRegistry.getByResourceLocation((ResourceLocation)chickenRepresentation.parentOne.getInternal()) : null;
            ChickensRegistryItem chickensRegistryItem = parentTwoItem = chickenRepresentation.parentTwo != null ? ChickensRegistry.getByResourceLocation((ResourceLocation)chickenRepresentation.parentTwo.getInternal()) : null;
            if (parentOneItem != null && parentTwoItem != null) {
                item.setParentsNew(parentOneItem, parentTwoItem);
            } else {
                item.setNoParents();
            }
            if (chickenRepresentation.layItem != null) {
                item.setLayItem(CraftTweakerMC.getItemStack((IItemStack)chickenRepresentation.layItem));
            }
            if (chickenRepresentation.dropItem != null) {
                item.setDropItem(CraftTweakerMC.getItemStack((IItemStack)chickenRepresentation.dropItem));
            }
            if (chickenRepresentation.spawnType != null) {
                SpawnType actualSpawnType = null;
                for (SpawnType spawnTypeEnum : SpawnType.values()) {
                    if (!spawnTypeEnum.toString().equalsIgnoreCase(chickenRepresentation.spawnType)) continue;
                    actualSpawnType = spawnTypeEnum;
                }
                if (actualSpawnType != null) {
                    item.setSpawnType(actualSpawnType);
                } else {
                    CraftTweakerAPI.logError((String)("Failed to find SpawnType for String: " + chickenRepresentation.spawnType));
                }
            }
            item.setLayCoefficient(chickenRepresentation.layCoefficient);
        }
    }
}

