/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.thermalexpansion.mixin;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.storage.BlockCache;
import cofh.thermalexpansion.block.storage.TileCache;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockCache.class}, remap=false)
public abstract class UTBlockCacheMixin
extends BlockTEBase {
    @Shadow
    private static boolean insertAllItemsFromPlayer(TileCache tile, EntityPlayer player) {
        return false;
    }

    protected UTBlockCacheMixin(Material material) {
        super(material);
    }

    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileCache tile = (TileCache)world.func_175625_s(pos);
        if (tile == null || !tile.canPlayerAccess(player)) {
            return false;
        }
        if (ItemHelper.isPlayerHoldingNothing((EntityPlayer)player) && player.func_70093_af()) {
            tile.setLocked(!tile.isLocked());
            if (tile.isLocked()) {
                world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.2f, 0.8f);
            } else {
                world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.5f);
            }
            return true;
        }
        boolean playSound = false;
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        ItemStack ret = tile.insertItem(heldItem, false);
        long time = player.getEntityData().func_74763_f("thermalexpansion:CacheClick");
        long currentTime = world.func_82737_E();
        player.getEntityData().func_74772_a("thermalexpansion:CacheClick", currentTime);
        if (!player.field_71075_bZ.field_75098_d) {
            if (ret != heldItem) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ret);
                playSound = true;
            }
            if (!tile.getStoredInstance().func_190926_b() && currentTime - time < 15L) {
                playSound &= !UTBlockCacheMixin.insertAllItemsFromPlayer(tile, player);
            }
        }
        if (playSound) {
            world.func_184133_a(null, pos, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.1f, 0.7f);
        }
        return true;
    }
}

