/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.blocks.anvil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class UTRepairableAnvil {
    private static final Map<Item, Integer> repairItems = new HashMap<Item, Integer>();

    public static void initRepairItemsList() {
        repairItems.clear();
        try {
            for (String entry : UTConfigTweaks.BLOCKS.ANVIL.utDamagedAnvilRepairItems.keySet()) {
                if (entry.contains(":")) {
                    ResourceLocation resLoc = new ResourceLocation(entry);
                    int amount = UTConfigTweaks.BLOCKS.ANVIL.utDamagedAnvilRepairItems.get(entry);
                    if (!ForgeRegistries.ITEMS.containsKey(resLoc)) continue;
                    repairItems.put((Item)ForgeRegistries.ITEMS.getValue(resLoc), amount);
                    continue;
                }
                List items = OreDictionary.getOres((String)entry).stream().map(ItemStack::func_77973_b).collect(Collectors.toList());
                for (Item item : items) {
                    if (item == null) continue;
                    int amount = UTConfigTweaks.BLOCKS.ANVIL.utDamagedAnvilRepairItems.get(entry);
                    repairItems.put(item, amount);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UniversalTweaks.LOGGER.info("Damaged Anvil repair items list initialized");
    }

    @SubscribeEvent
    public static void utRepairableAnvil(PlayerInteractEvent.RightClickBlock event) {
        if (repairItems.isEmpty()) {
            return;
        }
        if (!event.getEntityPlayer().func_70093_af()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() != Blocks.field_150467_bQ) {
            return;
        }
        if (repairItems.containsKey(event.getItemStack().func_77973_b()) && event.getItemStack().func_190916_E() >= repairItems.get(event.getItemStack().func_77973_b())) {
            IBlockState anvil = event.getWorld().func_180495_p(event.getPos());
            int currentDamage = (Integer)anvil.func_177229_b((IProperty)BlockAnvil.field_176505_b);
            if (currentDamage <= 0) {
                return;
            }
            event.getEntityPlayer().func_184614_ca().func_190918_g(repairItems.get(event.getItemStack().func_77973_b()).intValue());
            IBlockState repaired = anvil.func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(currentDamage - 1));
            event.getWorld().func_180501_a(event.getPos(), repaired, 3);
            event.setResult(Event.Result.DENY);
        }
    }
}

