/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.entities.speed.player.mixin;

import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayer.class})
public abstract class UTPlayerAirSpeedMixin
extends EntityLivingBase {
    @Shadow
    protected float field_71102_ce;

    protected UTPlayerAirSpeedMixin(World world) {
        super(world);
    }

    protected float func_175134_bD() {
        if (!UTConfigTweaks.ENTITIES.PLAYER_SPEED.utPlayerJumpSpeed) {
            return super.func_175134_bD();
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTPlayerAirSpeed ::: Set jump upwards motion");
        }
        float defaultMovementSpeed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
        float currentMovementSpeed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        return Math.min(super.func_175134_bD(), super.func_175134_bD() / defaultMovementSpeed * currentMovementSpeed);
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="HEAD")})
    private void utAirSpeed(CallbackInfo ci) {
        if (!UTConfigTweaks.ENTITIES.PLAYER_SPEED.utPlayerAirSpeed) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTPlayerAirSpeed ::: On living update -> Update speed in air");
        }
        float defaultMovementSpeed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
        float currentMovementSpeed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        this.field_71102_ce = Math.min(0.02f, 0.02f / defaultMovementSpeed * currentMovementSpeed);
    }

    @ModifyConstant(method={"onLivingUpdate"}, constant={@Constant(doubleValue=0.3)})
    private double utAirSpeedSprinting(double factor) {
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTPlayerAirSpeed ::: On living update -> Set air speed sprinting factor");
        }
        return UTConfigTweaks.ENTITIES.PLAYER_SPEED.utPlayerAirSpeedSprintingFactor != 0.3 ? UTConfigTweaks.ENTITIES.PLAYER_SPEED.utPlayerAirSpeedSprintingFactor : factor;
    }
}

