/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.util.compat;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import mod.acgaming.universaltweaks.config.UTConfigBugfixes;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import mod.acgaming.universaltweaks.config.UTConfigMods;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import mod.acgaming.universaltweaks.core.Coremods;
import mod.acgaming.universaltweaks.util.UTReflectionUtil;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class UTObsoleteModsHandler {
    private static final Map<String, BooleanSupplier> obsoleteModMap = ImmutableMap.copyOf((Map)new HashMap<String, BooleanSupplier>(){
        {
            if (UTConfigGeneral.MASTER_SWITCHES.utMasterSwitchBugfixes) {
                this.put("bannerpatch", () -> UTConfigBugfixes.BLOCKS.utBannerBoundingBoxToggle);
                this.put("biggerpacketsplz", () -> UTConfigBugfixes.MISC.utPacketSize > 0x200000);
                this.put("blockfire", () -> UTConfigBugfixes.ENTITIES.utBlockFireToggle);
                this.put("blockoverlayfix", () -> UTConfigBugfixes.BLOCKS.BLOCK_OVERLAY.utBlockOverlayToggle);
                this.put("deuf", () -> UTConfigBugfixes.ENTITIES.utEntityUUIDToggle);
                this.put("diethopper", () -> UTConfigBugfixes.BLOCKS.utDietHopperToggle);
                this.put("entity_desync_fix", () -> UTConfigBugfixes.ENTITIES.ENTITY_DESYNC.utEntityDesyncToggle);
                this.put("experiencebugfix", () -> UTConfigBugfixes.ENTITIES.utDimensionChangeToggle);
                this.put("eyltrafix", () -> UTConfigBugfixes.ENTITIES.utElytraDeploymentLandingToggle);
                this.put("foodfix", () -> UTConfigBugfixes.ENTITIES.utDoubleConsumptionToggle);
                this.put("framevoidpatch", () -> UTConfigBugfixes.BLOCKS.utItemFrameVoidToggle);
                this.put("givemebackmyhp", () -> UTConfigBugfixes.ENTITIES.utMaxHealthToggle);
                this.put("helpfixer", () -> UTConfigBugfixes.MISC.utHelpToggle);
                this.put("horsefallfix", () -> UTConfigBugfixes.ENTITIES.utHorseFallingToggle);
                this.put("loginhpfix", () -> UTConfigBugfixes.ENTITIES.utMaxHealthToggle);
                this.put("maxhealthfixer", () -> UTConfigBugfixes.ENTITIES.utMaxHealthToggle);
                this.put("nanfix", () -> UTConfigBugfixes.ENTITIES.utEntityNaNToggle);
                this.put("nanpolice", () -> UTConfigBugfixes.ENTITIES.utEntityNaNToggle);
                this.put("netherportalfix", () -> UTConfigBugfixes.WORLD.utPortalLocationLink);
                this.put("portaldupebegone", () -> UTConfigBugfixes.WORLD.utPortalTravelingDupeToggle);
                this.put("preventghost", () -> UTConfigBugfixes.BLOCKS.MINING_GLITCH.utMiningGlitchToggle);
                this.put("villagermantlefix", () -> UTConfigBugfixes.ENTITIES.utVillagerMantleToggle);
            }
            if (UTConfigGeneral.MASTER_SWITCHES.utMasterSwitchModIntegration) {
                this.put("drawerfps", () -> UTConfigMods.STORAGE_DRAWERS.utSDRenderRange > 0);
                this.put("erebusfix", () -> UTConfigMods.EREBUS.utEBPreservedBlocksToggle);
                this.put("steamworldpatcher", () -> UTConfigMods.STEAMWORLD.utSkyOfOldFixToggle);
            }
            if (UTConfigGeneral.MASTER_SWITCHES.utMasterSwitchTweaks) {
                this.put("advancementscreenshot", () -> UTConfigTweaks.MISC.ADVANCEMENT_SCREENSHOT.utAdvancementScreenshotToggle);
                this.put("aiimprovements", () -> UTConfigTweaks.ENTITIES.utAIReplacementToggle || UTConfigTweaks.ENTITIES.utAIRemovalToggle);
                this.put("armorcurve", () -> UTConfigTweaks.MISC.ARMOR_CURVE.utArmorCurveToggle);
                this.put("attributefix", () -> UTConfigTweaks.ENTITIES.ATTRIBUTES.utAttributesToggle);
                this.put("badwithernocookiereloaded", () -> !UTConfigTweaks.MISC.BROADCAST_SOUNDS.utBroadcastSoundDragon || !UTConfigTweaks.MISC.BROADCAST_SOUNDS.utBroadcastSoundEndPortal || !UTConfigTweaks.MISC.BROADCAST_SOUNDS.utBroadcastSoundWither);
                this.put("bedbreakbegone", () -> UTConfigTweaks.BLOCKS.utBedObstructionToggle);
                this.put("bedfix", () -> UTConfigTweaks.ENTITIES.SLEEPING.utSleepingTime != -1);
                this.put("bedsaynosleep", () -> UTConfigTweaks.ENTITIES.SLEEPING.utDisableSleepingToggle);
                this.put("betteradvancements", () -> UTConfigTweaks.MISC.ADVANCEMENTS.utAdvancementsToggle);
                this.put("betterburning", () -> UTConfigTweaks.ENTITIES.BETTER_BURNING.utBBArrowsToggle || UTConfigTweaks.ENTITIES.BETTER_BURNING.utBBCookedToggle || UTConfigTweaks.ENTITIES.BETTER_BURNING.utBBExtinguishToggle || UTConfigTweaks.ENTITIES.BETTER_BURNING.utBBOverlayToggle || UTConfigTweaks.ENTITIES.BETTER_BURNING.utBBSpreadingToggle);
                this.put("betterpingdisplay", () -> UTConfigTweaks.MISC.utBetterPing);
                this.put("betterplacement", () -> UTConfigTweaks.BLOCKS.BETTER_PLACEMENT.utBetterPlacementToggle);
                this.put("biggerchathistory", () -> UTConfigTweaks.MISC.CHAT.utChatLines != 100);
                this.put("blockdispenser", () -> UTConfigTweaks.BLOCKS.BLOCK_DISPENSER.utBlockDispenserToggle);
                this.put("bottlefix", () -> UTConfigTweaks.ITEMS.utGlassBottlesConsumeWaterSource);
                this.put("bottomsugarcanharvest", () -> UTConfigTweaks.BLOCKS.utSugarCaneSize != 3);
                this.put("bowinfinityfix", () -> UTConfigTweaks.ITEMS.INFINITY.utBowInfinityToggle);
                this.put("breedablekillerrabbit", () -> UTConfigTweaks.ENTITIES.utRabbitKillerChance > 0.0);
                this.put("burnbabyburn", () -> UTConfigTweaks.ENTITIES.utBurningBabyZombiesToggle);
                this.put("chickensshed", () -> UTConfigTweaks.ENTITIES.CHICKEN_SHEDDING.utChickenSheddingToggle);
                this.put("cie", () -> UTConfigTweaks.ITEMS.ITEM_ENTITIES.utItemEntitiesToggle);
                this.put("classiccombat", () -> UTConfigTweaks.ITEMS.ATTACK_COOLDOWN.utAttackCooldownToggle);
                this.put("cleardespawn", () -> UTConfigTweaks.ITEMS.ITEM_ENTITIES.utIEClearDespawnToggle);
                this.put("configurablecane", () -> UTConfigTweaks.BLOCKS.utSugarCaneSize != 3);
                this.put("configurabledespawntimer", () -> UTConfigTweaks.ITEMS.ITEM_ENTITIES.utItemEntitiesToggle);
                this.put("continousmusic", () -> UTConfigTweaks.MISC.MUSIC.utCustomMusicDelay);
                this.put("creeperconfetti", () -> UTConfigTweaks.ENTITIES.CREEPER_CONFETTI.utCreeperConfettiChance > 0.0);
                this.put("damagetilt", () -> UTConfigTweaks.MISC.utDamageTiltToggle);
                this.put("darkstone", () -> UTConfigTweaks.PERFORMANCE.utRedstoneLightingToggle);
                this.put("defaultlanport", () -> UTConfigTweaks.MISC.utLANServerProperties);
                this.put("ding", () -> UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode != UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.NOTHING);
                this.put("easybreeding", () -> UTConfigTweaks.ENTITIES.EASY_BREEDING.utEasyBreedingToggle);
                this.put("enablecheats", () -> UTConfigTweaks.MISC.utToggleCheatsToggle);
                this.put("endportalparallax", () -> UTConfigTweaks.MISC.utEndPortalParallaxToggle);
                this.put("f5fix", () -> UTConfigTweaks.ENTITIES.utThirdPersonIgnoresNonSolidBlocks);
                this.put("fastbench", () -> UTConfigTweaks.PERFORMANCE.utCraftingCacheToggle);
                this.put("fastleafdecay", () -> UTConfigTweaks.BLOCKS.utLeafDecayToggle);
                this.put("fencejumper", () -> UTConfigTweaks.BLOCKS.utFenceWallJumpToggle);
                this.put("finite-fluid-control", () -> UTConfigTweaks.BLOCKS.FINITE_WATER.utFiniteWaterToggle);
                this.put("forgivingvoid", () -> UTConfigTweaks.ENTITIES.VOID_TELEPORT.utVoidTeleportToggle);
                this.put("getittogetherdrops", () -> UTConfigTweaks.ITEMS.ITEM_ENTITIES.utItemEntitiesToggle);
                this.put("gottagofast", () -> UTConfigTweaks.ENTITIES.PLAYER_SPEED.utPlayerSpeedToggle);
                this.put("hiddenrecipebook", () -> UTConfigTweaks.MISC.utRecipeBookToggle);
                this.put("horsestandstill", () -> UTConfigTweaks.ENTITIES.utSaddledWanderingToggle);
                this.put("ikwid", () -> UTConfigTweaks.MISC.TOAST_CONTROL.utToastControlTutorialToggle);
                this.put("infinityworkswithallarrows", () -> UTConfigTweaks.ITEMS.INFINITY.utAllArrowsAreInfinite);
                this.put("infwithmend", () -> UTConfigTweaks.ITEMS.INFINITY.utInfinityEnchantmentConflicts);
                this.put("insomniac", () -> UTConfigTweaks.ENTITIES.SLEEPING.utDisableSleepingToggle);
                this.put("inventoryspam", () -> UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPickupNotificationToggle);
                this.put("keydescfix", () -> UTConfigTweaks.MISC.utPreventKeybindingEntryOverflow);
                this.put("ksyxis", () -> !UTConfigTweaks.WORLD.SPAWN_CHUNKS.utSpawnChunksGenToggle || !UTConfigTweaks.WORLD.SPAWN_CHUNKS.utSpawnChunksLoadingToggle);
                this.put("lanserverproperties", () -> UTConfigTweaks.MISC.utLANServerProperties);
                this.put("leafdecay", () -> UTConfigTweaks.BLOCKS.utLeafDecayToggle);
                this.put("letmedespawn", () -> UTConfigTweaks.ENTITIES.utMobDespawnToggle);
                this.put("mendingfix", () -> UTConfigTweaks.ITEMS.MENDING.utMendingToggle);
                this.put("mobpc", () -> UTConfigTweaks.ENTITIES.utMobDespawnToggle);
                this.put("mobsunscreen", () -> !UTConfigTweaks.ENTITIES.utBurningSkeletonsToggle || !UTConfigTweaks.ENTITIES.utBurningZombiesToggle);
                this.put("movingquickly", () -> UTConfigTweaks.ENTITIES.PLAYER_SPEED.utPlayerSpeedToggle);
                this.put("mtqfix", () -> UTConfigTweaks.ENTITIES.PLAYER_SPEED.utPlayerSpeedToggle);
                this.put("muteuselesslogs", () -> UTConfigTweaks.PERFORMANCE.utPrefixCheckToggle || UTConfigTweaks.PERFORMANCE.utTextureMapCheckToggle);
                this.put("naturallychargedcreepers", () -> UTConfigTweaks.ENTITIES.utCreeperChargedChance > 0.0);
                this.put("noadvancements", () -> UTConfigTweaks.MISC.utDisableAdvancementsToggle);
                this.put("nodoze", () -> UTConfigTweaks.ENTITIES.SLEEPING.utDisableSleepingToggle);
                this.put("noexpensive", () -> UTConfigTweaks.BLOCKS.ANVIL.utAnvilXPLevelCap != 40 || UTConfigTweaks.ITEMS.INFINITY.utInfinityEnchantmentConflicts);
                this.put("nomoreglowingpots", () -> UTConfigTweaks.MISC.utDisablePotionGlint);
                this.put("nonvflash", () -> UTConfigTweaks.MISC.utNightVisionFlashToggle);
                this.put("nopotionshift", () -> UTConfigTweaks.MISC.utPotionShiftToggle);
                this.put("noprecipebook", () -> UTConfigTweaks.MISC.utRecipeBookToggle);
                this.put("norealmsbutton", () -> UTConfigTweaks.MISC.utRealmsButtonToggle);
                this.put("norecipebook", () -> UTConfigTweaks.MISC.utRecipeBookToggle);
                this.put("oldcombat", () -> UTConfigTweaks.ITEMS.ATTACK_COOLDOWN.utAttackCooldownToggle);
                this.put("overpowered_mending", () -> UTConfigTweaks.ITEMS.MENDING.utMendingOPToggle);
                this.put("parry", () -> UTConfigTweaks.ITEMS.PARRY.utParryToggle);
                this.put("pathundergates", () -> UTConfigTweaks.BLOCKS.utLenientPathsToggle);
                this.put("pickupnotifier", () -> UTConfigTweaks.MISC.PICKUP_NOTIFICATION.utPickupNotificationToggle);
                this.put("ppa", () -> UTConfigTweaks.BLOCKS.utUnsupportedPumpkinPlacing);
                this.put("quickleafdecay", () -> UTConfigTweaks.BLOCKS.utLeafDecayToggle);
                this.put("rallyhealth", () -> UTConfigTweaks.ENTITIES.RALLY_HEALTH.utRallyHealthToggle);
                this.put("rebind_narrator", () -> UTConfigTweaks.MISC.utUseCustomNarratorKeybind);
                this.put("salwayseat", () -> UTConfigTweaks.ITEMS.utAlwaysEatToggle);
                this.put("savemystronghold", () -> UTConfigTweaks.WORLD.utStrongholdToggle);
                this.put("seedcopy", () -> UTConfigTweaks.MISC.utCopyWorldSeedToggle);
                this.put("silentboss", () -> !UTConfigTweaks.MISC.BROADCAST_SOUNDS.utBroadcastSoundDragon || !UTConfigTweaks.MISC.BROADCAST_SOUNDS.utBroadcastSoundWither);
                this.put("sleepsooner", () -> UTConfigTweaks.ENTITIES.SLEEPING.utSleepingTime != -1);
                this.put("smooth-scrolling-everywhere", () -> UTConfigTweaks.MISC.SMOOTH_SCROLLING.utSmoothScrollingToggle);
                this.put("sourcebottles", () -> UTConfigTweaks.ITEMS.utGlassBottlesConsumeWaterSource);
                this.put("stepupfix", () -> UTConfigTweaks.ENTITIES.utAutoJumpToggle);
                this.put("stg", () -> UTConfigTweaks.MISC.SWING_THROUGH_GRASS.utSwingThroughGrassToggle);
                this.put("superhot", () -> UTConfigTweaks.ITEMS.utSuperHotTorchToggle);
                this.put("thirstybottles", () -> UTConfigTweaks.ITEMS.utGlassBottlesConsumeWaterSource);
                this.put("tidychunk", () -> UTConfigTweaks.WORLD.utTidyChunkToggle);
                this.put("tinkersoredictcache", () -> UTConfigMods.TINKERS_CONSTRUCT.utTConOreDictCacheToggle);
                this.put("toastcontrol", () -> UTConfigTweaks.MISC.TOAST_CONTROL.utToastControlToggle);
                this.put("tramplestopper", () -> UTConfigTweaks.BLOCKS.utFarmlandTrample != UTConfigTweaks.TrampleOptions.DEFAULT);
                this.put("unloader", () -> UTConfigTweaks.WORLD.DIMENSION_UNLOAD.utUnloaderToggle);
                this.put("unridekeybind", () -> UTConfigTweaks.MISC.utUseSeparateDismountKey);
                this.put("voidfog", () -> UTConfigTweaks.WORLD.VOID_FOG.utVoidFogToggle);
                this.put("watercontrolextreme", () -> UTConfigTweaks.BLOCKS.FINITE_WATER.utFiniteWaterToggle);
            }
            this.put("bedpatch", () -> true);
            this.put("dupefixproject", () -> true);
            this.put("mup", () -> true);
            this.put("randompatches", () -> true);
            this.put("surge", () -> true);
        }
    });
    private static List<String> obsoleteModsList;
    private static boolean hasShownObsoleteMods;

    public static boolean hasObsoleteModsMessage() {
        return !UTObsoleteModsHandler.hasShownObsoleteMods() && !UTConfigGeneral.DEBUG.utBypassIncompatibilityToggle && !UTObsoleteModsHandler.getObsoleteModsList().isEmpty();
    }

    public static List<String> obsoleteModsMessage() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(new TextComponentTranslation("msg.universaltweaks.obsoletemods.warning1", new Object[0]).func_150254_d());
        messages.add(new TextComponentTranslation("msg.universaltweaks.obsoletemods.warning2", new Object[0]).func_150254_d());
        messages.add("");
        messages.addAll(UTObsoleteModsHandler.getObsoleteModsList());
        messages.add("");
        messages.add(new TextComponentTranslation("msg.universaltweaks.obsoletemods.warning3", new Object[0]).func_150254_d());
        return messages;
    }

    private static List<String> getObsoleteModsList() {
        if (obsoleteModsList == null) {
            obsoleteModsList = UTObsoleteModsHandler.generateObsoleteModsList();
        }
        return obsoleteModsList;
    }

    private static List<String> generateObsoleteModsList() {
        ArrayList<String> messages = new ArrayList<String>();
        Map modIdMap = Loader.instance().getIndexedModList();
        for (String modId : obsoleteModMap.keySet()) {
            if (!Loader.isModLoaded((String)modId) || !obsoleteModMap.get(modId).getAsBoolean()) continue;
            messages.add(((ModContainer)modIdMap.get(modId)).getName());
        }
        if (UTReflectionUtil.isClassLoaded("com.chocohead.biab.BornInABarn")) {
            messages.add("Born in a Barn");
        }
        if ((UTReflectionUtil.isClassLoaded("io.github.jikuja.LocaleTweaker") || UTReflectionUtil.isClassLoaded("io.github.jikuja.LocaleFixer")) && UTConfigBugfixes.MISC.utLocaleToggle) {
            messages.add("LocaleFixer");
        }
        if (UTReflectionUtil.isClassLoaded("com.cleanroommc.blockdelayremover.BlockDelayRemoverCore") && UTConfigTweaks.BLOCKS.utBlockHitDelay != 5) {
            messages.add("Block Delay Remover");
        }
        if (Coremods.CHUNKGEN_LIMITER.isLoaded() && UTConfigTweaks.WORLD.CHUNK_GEN_LIMIT.utChunkGenLimitToggle) {
            messages.add("Chunk Generation Limiter");
        }
        return messages;
    }

    public static boolean hasShownObsoleteMods() {
        return hasShownObsoleteMods;
    }

    public static void setHasShownObsoleteMods(boolean value) {
        hasShownObsoleteMods = value;
    }

    static {
        hasShownObsoleteMods = false;
    }
}

