/*
 * Decompiled with CFR 0.152.
 */
package lunar.tinkerer.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import lunar.tinkerer.block.ModBlockEntities;
import lunar.tinkerer.block.custom.SculkVaultBlockEntity;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class SculkVaultBlock
extends class_2237 {
    public static final MapCodec<SculkVaultBlock> CODEC = SculkVaultBlock.method_54094(SculkVaultBlock::new);
    public static final class_265 BASE_SHAPE = class_2248.method_66404((double)16.0, (double)0.0, (double)4.0);
    public static final class_265 HEAD_SHAPE = class_2248.method_66404((double)8.0, (double)4.0, (double)14.0);
    public static final class_265 SHAPE = class_259.method_1084((class_265)BASE_SHAPE, (class_265)HEAD_SHAPE);

    public SculkVaultBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SculkVaultBlockEntity(pos, state);
    }

    public static Optional<SculkVaultBlockEntity> getBlockEntity(class_1937 world, class_2338 pos) {
        Optional<SculkVaultBlockEntity> optional;
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof SculkVaultBlockEntity) {
            SculkVaultBlockEntity vault = (SculkVaultBlockEntity)entity;
            optional = Optional.of(vault);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return SculkVaultBlock.getBlockEntity(world, pos).map(SculkVaultBlockEntity::getAnalogOutputSignal).orElse(0);
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (!(context instanceof class_3727)) {
            return SHAPE;
        }
        class_3727 entityShapeContext = (class_3727)context;
        if (!(entityShapeContext.method_32480() instanceof class_1303)) {
            return SHAPE;
        }
        return BASE_SHAPE;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        super.method_9548(state, world, pos, entity, handler);
        if (!(entity instanceof class_1303)) {
            return;
        }
        class_1303 orb = (class_1303)entity;
        SculkVaultBlock.absorbExperience((class_1297)orb, orb.method_37908(), pos);
    }

    public static void absorbExperience(class_1297 entity, class_1937 world, class_2338 pos) {
        if (!(entity instanceof class_1303)) {
            return;
        }
        class_1303 orb = (class_1303)entity;
        SculkVaultBlock.getBlockEntity(world, pos).ifPresent(vault -> vault.absorbExperience(orb));
    }

    public static void dropExperience(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        SculkVaultBlock.getBlockEntity((class_1937)serverWorld, pos).ifPresent(vault -> class_1303.method_31493((class_3218)serverWorld, (class_243)pos.method_46558(), (int)vault.getExperience()));
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return null;
        }
        if (type != ModBlockEntities.SCULK_VAULT_BLOCK_ENTITY) {
            return null;
        }
        return (world1, pos, state1, blockEntity) -> {
            if (!(blockEntity instanceof SculkVaultBlockEntity)) {
                return;
            }
            SculkVaultBlockEntity vault = (SculkVaultBlockEntity)blockEntity;
            vault.serverTick();
        };
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        SculkVaultBlock.dropExperience(world, pos);
        return super.method_9576(world, pos, state, player);
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        Optional<SculkVaultBlockEntity> o_vault = SculkVaultBlock.getBlockEntity(world, pos);
        if (o_vault.isEmpty()) {
            return super.method_55765(stack, state, world, pos, player, hand, hit);
        }
        if (o_vault.get().fillContainersFromPlayer(stack, world, player, hand).booleanValue()) {
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }
}

