/*
 * Decompiled with CFR 0.152.
 */
package lunar.tinkerer.block.custom;

import lunar.tinkerer.block.ModBlockEntities;
import lunar.tinkerer.interfaces.PublicCountAndValue;
import lunar.tinkerer.item.ModItems;
import lunar.tinkerer.item.custom.SculkVialItem;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5328;

public class SculkVaultBlockEntity
extends class_2586 {
    public static final int BOTTLE_O_ENCHANTING_COST = 13;
    private static final int MAX_EXPERIENCE = 22250;
    private static final String EXPERIENCE_KEY = "Experience";
    private static final String TAKE_XP_DELAY_KEY = "TakeXpDelay";
    private int experience = 0;
    private int takeXpDelay = 0;

    public SculkVaultBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.SCULK_VAULT_BLOCK_ENTITY, pos, state);
    }

    public Boolean fillContainersFromPlayer(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand) {
        boolean isVial;
        class_1792 item = itemStack.method_7909();
        boolean bl = isVial = item.equals(ModItems.SCULK_VIAL_1) || item.equals(ModItems.SCULK_VIAL_2) || item.equals(ModItems.SCULK_VIAL_3);
        if (item.equals(class_1802.field_8469)) {
            return this.fillContainerFromPlayer(world, 13, player, itemStack, () -> player.method_6122(hand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8287))));
        }
        if (isVial) {
            int xpToTake = Math.min(itemStack.method_7919(), this.experience);
            return this.fillContainerFromPlayer(world, xpToTake, player, itemStack, () -> {
                itemStack.method_7974(itemStack.method_7919() - xpToTake);
                if (item instanceof SculkVialItem) {
                    SculkVialItem.emptyOrFillSound(world, player);
                }
            });
        }
        return false;
    }

    public Boolean fillContainerFromPlayer(class_1937 world, int amount, class_1657 player, class_1799 itemStack, Runnable onSuccess) {
        return this.fillContainer(world, amount, () -> {
            player.method_7342(class_3468.field_15372.method_14956((Object)itemStack.method_7909()), 1);
            onSuccess.run();
        });
    }

    public boolean fillContainer(class_1937 world, int amount, Runnable onSuccess) {
        if (world.field_9236) {
            return true;
        }
        if (!this.dispenseXp(amount).booleanValue()) {
            return false;
        }
        onSuccess.run();
        return true;
    }

    public void absorbExperience(class_1303 orb) {
        if (!this.absorbXp(orb.method_5919()).booleanValue()) {
            return;
        }
        PublicCountAndValue mixinOrb = (PublicCountAndValue)orb;
        int count = mixinOrb.getPickingCount();
        mixinOrb.setPickingCount(count - 1);
        if (count == 1) {
            orb.method_31472();
        }
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_37364, class_3419.field_15245, 4.0f, 1.0f);
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_243 center = this.field_11867.method_46558();
        serverWorld.method_65096((class_2394)class_2398.field_38002, center.method_10216(), center.method_10214(), center.method_10215(), 2, 0.0, 0.5, 0.0, 0.0);
    }

    public Boolean dispenseXp(int xp) {
        if (xp > this.experience) {
            return false;
        }
        this.experience -= xp;
        this.method_5431();
        return true;
    }

    public Boolean absorbXp(int xp) {
        if (this.takeXpDelay > 0) {
            return false;
        }
        if (xp >= 22250) {
            return false;
        }
        this.experience = Math.min(this.experience + xp, 22250);
        this.takeXpDelay = 2;
        this.method_5431();
        return true;
    }

    public int getAnalogOutputSignal() {
        if (this.experience == 0) {
            return 0;
        }
        if (this.experience == 22250) {
            return 15;
        }
        return class_3532.method_15357((double)class_3532.method_16436((double)((double)this.experience / 22250.0), (double)1.0, (double)14.0));
    }

    public void serverTick() {
        if (this.takeXpDelay <= 0) {
            return;
        }
        --this.takeXpDelay;
        this.method_5431();
    }

    public int getExperience() {
        return this.experience;
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.experience = view.method_71439(EXPERIENCE_KEY).orElse(0);
        this.takeXpDelay = view.method_71439(TAKE_XP_DELAY_KEY).orElse(0);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465(EXPERIENCE_KEY, this.experience);
        view.method_71465(TAKE_XP_DELAY_KEY, this.takeXpDelay);
    }
}

