/*
 * Decompiled with CFR 0.152.
 */
package lunar.tinkerer.item.custom;

import java.util.List;
import java.util.Map;
import lunar.tinkerer.SculkVault;
import lunar.tinkerer.utility.ExperienceOrbHelpers;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9699;
import org.jetbrains.annotations.Nullable;

public class SculkVialItem
extends class_1792 {
    public static final Map<Integer, Integer> SCULK_VIAL_CAPACITY_MAP = Map.of(1, 830, 2, 7040, 3, 22250);
    public static final Map<Integer, class_1814> SCULK_VIAL_RARITY_MAP = Map.of(1, class_1814.field_8907, 2, class_1814.field_8907, 3, class_1814.field_8903);

    public SculkVialItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static void emptyOrFillSound(class_1937 world, class_1657 player) {
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_37359, class_3419.field_15254, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
    }

    public static void dropXp(int xpToDrop, class_3218 world, class_1657 player) {
        int droppedXp;
        player.field_7504 = 20;
        for (int counter = xpToDrop; counter > 0; counter -= droppedXp) {
            droppedXp = Math.min(149, counter);
            class_1303.method_31493((class_3218)world, (class_243)player.method_19538(), (int)droppedXp);
        }
    }

    public static void emptyHeldXp(class_3218 world, class_1657 player, class_1799 itemStack) {
        SculkVialItem.dropXp(itemStack.method_7936() - itemStack.method_7919(), world, player);
        itemStack.method_7974(itemStack.method_7936());
        SculkVialItem.emptyOrFillSound((class_1937)world, player);
    }

    public static void repairEquipment(class_1799 itemStack, class_1297 entity) {
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        int durability = itemStack.method_7936() - itemStack.method_7919();
        if (durability <= 0) {
            return;
        }
        ExperienceOrbHelpers.getDamagedRepairableItem(player).map(class_9699::comp_2682).ifPresent(stack -> {
            stack.method_7974(stack.method_7919() - 1);
            itemStack.method_7974(itemStack.method_7919() + 1);
        });
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!(world instanceof class_3218)) {
            return super.method_7836(world, user, hand);
        }
        class_3218 serverWorld = (class_3218)world;
        class_1799 itemStack = user.method_5998(hand);
        SculkVialItem.emptyHeldXp(serverWorld, user, itemStack);
        return class_1269.field_5812;
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        super.method_7888(stack, world, entity, slot);
        SculkVialItem.repairEquipment(stack, entity);
    }

    public static SculkVialItem fromCapacity(int i) {
        int capacity = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)).contains(i) ? i : 1;
        int durability = SCULK_VIAL_CAPACITY_MAP.get(capacity);
        class_1814 rarity = SCULK_VIAL_RARITY_MAP.get(capacity);
        class_1792.class_1793 settings = new class_1792.class_1793().method_7895(durability).method_7894(rarity).method_7889(1).method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)SculkVault.id("sculk_vial_" + capacity))).method_57349(class_9334.field_49641, (Object)true);
        return new SculkVialItem(settings);
    }

    public static class_1799 holding(class_3222 player) {
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        if (SculkVialItem.isRepairableSculkVial(mainHand)) {
            return mainHand;
        }
        if (SculkVialItem.isRepairableSculkVial(offHand)) {
            return offHand;
        }
        return class_1799.field_8037;
    }

    public static boolean isRepairableSculkVial(class_1799 itemStack) {
        return itemStack.method_7909() instanceof SculkVialItem && itemStack.method_7986();
    }
}

