/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10405;
import net.minecraft.class_10410;
import net.minecraft.class_10411;
import net.minecraft.class_10434;
import net.minecraft.class_10439;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4941;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_790;
import net.minecraft.class_7923;

public abstract class ModelProviderBase
implements class_2405 {
    private final class_7784.class_7489 blockStatePathProvider;
    private final class_7784.class_7489 itemInfoPathProvider;
    private final class_7784.class_7489 modelPathProvider;
    private final String modId;
    private final boolean autogenBlockItemInfos;

    public ModelProviderBase(class_7784 output, String modId, boolean autogenBlockItemInfos) {
        this.blockStatePathProvider = output.method_45973(class_7784.class_7490.field_39368, "blockstates");
        this.itemInfoPathProvider = output.method_45973(class_7784.class_7490.field_39368, "items");
        this.modelPathProvider = output.method_45973(class_7784.class_7490.field_39368, "models");
        this.modId = modId;
        this.autogenBlockItemInfos = autogenBlockItemInfos;
    }

    public ModelProviderBase(class_7784 output, String modId) {
        this(output, modId, true);
    }

    protected abstract class_4910 createBlockModelGenerators(Consumer<class_4917> var1, class_10405 var2, BiConsumer<class_2960, class_10411> var3);

    protected abstract class_4915 createItemModelGenerators(class_10405 var1, BiConsumer<class_2960, class_10411> var2);

    public CompletableFuture<?> method_10319(class_7403 output) {
        ItemInfoCollector itemInfoCollector = new ItemInfoCollector();
        BlockStateGeneratorCollector blockStateGeneratorCollector = new BlockStateGeneratorCollector();
        SimpleModelCollector simpleModelCollector = new SimpleModelCollector();
        class_4910 blockModelGenerators = this.createBlockModelGenerators(blockStateGeneratorCollector, itemInfoCollector, simpleModelCollector);
        class_4915 itemModelGenerators = this.createItemModelGenerators(itemInfoCollector, simpleModelCollector);
        if (blockModelGenerators != null) {
            blockModelGenerators.method_25534();
        }
        if (itemModelGenerators != null) {
            itemModelGenerators.method_25731();
        }
        itemInfoCollector.finalizeAndValidate();
        return CompletableFuture.allOf(blockStateGeneratorCollector.save(output, this.blockStatePathProvider), simpleModelCollector.save(output, this.modelPathProvider), itemInfoCollector.save(output, this.itemInfoPathProvider));
    }

    static <T> CompletableFuture<?> saveAll(class_7403 output, Function<T, Path> p_386455_, Map<T, ? extends Supplier<JsonElement>> generators) {
        return class_2405.method_65772((class_7403)output, Supplier::get, p_386455_, generators);
    }

    public final String method_10321() {
        return "Model Definitions";
    }

    private boolean isModded(class_6880.class_6883<?> reference) {
        return reference.method_40237().method_29177().method_12836().equals(this.modId);
    }

    class ItemInfoCollector
    implements class_10405 {
        private final Map<class_1792, class_10434> itemInfos = new HashMap<class_1792, class_10434>();
        private final Map<class_1792, class_1792> copies = new HashMap<class_1792, class_1792>();

        ItemInfoCollector() {
        }

        public void method_65460(class_1792 item, class_10439.class_10441 model) {
            this.register(item, new class_10434(model, class_10434.class_10543.field_55549));
        }

        public void register(class_1792 p_388205_, class_10434 p_388233_) {
            class_10434 clientitem = this.itemInfos.put(p_388205_, p_388233_);
            if (clientitem != null) {
                throw new IllegalStateException("Duplicate item model definition for " + String.valueOf(p_388205_));
            }
        }

        public void method_65459(class_1792 p_386920_, class_1792 p_386789_) {
            this.copies.put(p_386789_, p_386920_);
        }

        public void finalizeAndValidate() {
            if (ModelProviderBase.this.autogenBlockItemInfos) {
                class_7923.field_41178.method_42017().filter(ModelProviderBase.this::isModded).forEach(p_388426_ -> {
                    class_1747 blockitem;
                    Object patt0$temp;
                    if (!this.copies.containsKey(p_388426_) && (patt0$temp = p_388426_.comp_349()) instanceof class_1747 && !this.itemInfos.containsKey(blockitem = (class_1747)patt0$temp)) {
                        class_2960 resourcelocation = class_4941.method_25842((class_2248)blockitem.method_7711());
                        this.method_65460((class_1792)blockitem, class_10410.method_65481((class_2960)resourcelocation));
                    }
                });
            }
            this.copies.forEach((p_386494_, p_386575_) -> {
                class_10434 clientitem = this.itemInfos.get(p_386575_);
                if (clientitem == null) {
                    throw new IllegalStateException("Missing donor: " + String.valueOf(p_386575_) + " -> " + String.valueOf(p_386494_));
                }
                this.register((class_1792)p_386494_, clientitem);
            });
        }

        public CompletableFuture<?> save(class_7403 output, class_7784.class_7489 pathProvider) {
            return class_2405.method_65771((class_7403)output, (Codec)class_10434.field_55327, p_388594_ -> pathProvider.method_44107(p_388594_.method_40131().method_40237().method_29177()), this.itemInfos);
        }
    }

    static class BlockStateGeneratorCollector
    implements Consumer<class_4917> {
        private final Map<class_2248, class_4917> generators = new HashMap<class_2248, class_4917>();

        BlockStateGeneratorCollector() {
        }

        @Override
        public void accept(class_4917 p_388748_) {
            class_2248 block = p_388748_.method_25743();
            class_4917 blockstategenerator = this.generators.put(block, p_388748_);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        }

        public CompletableFuture<?> save(class_7403 p_388014_, class_7784.class_7489 p_388192_) {
            Map map = Maps.transformValues(this.generators, class_4917::method_67844);
            Function<class_2248, Path> function = p_387598_ -> p_388192_.method_44107(p_387598_.method_40142().method_40237().method_29177());
            return class_2405.method_65771((class_7403)p_388014_, (Codec)class_790.field_56928, function, (Map)map);
        }
    }

    static class SimpleModelCollector
    implements BiConsumer<class_2960, class_10411> {
        private final Map<class_2960, class_10411> models = new HashMap<class_2960, class_10411>();

        SimpleModelCollector() {
        }

        @Override
        public void accept(class_2960 location, class_10411 instance) {
            Supplier supplier = (Supplier)this.models.put(location, instance);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(location));
            }
        }

        public CompletableFuture<?> save(class_7403 output, class_7784.class_7489 pathProvider) {
            return ModelProviderBase.saveAll(output, arg_0 -> ((class_7784.class_7489)pathProvider).method_44107(arg_0), this.models);
        }
    }
}

