/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.init;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhotosensitiveSafetyProcedure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="from_the_caves")
public class PhaseCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"fromthecaves").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"phase").requires(src -> src.m_6761_(0))).executes(ctx -> PhaseCommand.executeGetPhase((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setphase").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)2)).executes(ctx -> PhaseCommand.executeSetPhase((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"photosensitiveMode").requires(src -> src.m_6761_(0))).executes(ctx -> PhaseCommand.togglePhotosensitiveMode((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"multiplayerScale").requires(src -> src.m_6761_(2))).executes(ctx -> PhaseCommand.executeGetMultiplayerScale((CommandSourceStack)ctx.getSource()))).then(Commands.m_82129_((String)"factor", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> PhaseCommand.executeSetMultiplayerScale((CommandSourceStack)ctx.getSource(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"factor")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"singleplayerMultiplier").requires(src -> src.m_6761_(2))).executes(ctx -> PhaseCommand.executeGetSingleplayerMultiplier((CommandSourceStack)ctx.getSource()))).then(Commands.m_82129_((String)"multiplier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.5)).executes(ctx -> PhaseCommand.executeSetSingleplayerMultiplier((CommandSourceStack)ctx.getSource(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"multiplier"))))));
    }

    private static int executeGetPhase(CommandSourceStack src) {
        ServerLevel world = src.m_81372_();
        int current = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)world);
        src.m_288197_(() -> Component.m_237113_((String)("Current phase: " + current)), false);
        return 1;
    }

    private static int executeSetPhase(CommandSourceStack src, int phase) {
        ServerLevel world = src.m_81372_();
        PhaseManagerProcedure.setManualPhase((LevelAccessor)world, phase);
        src.m_288197_(() -> Component.m_237113_((String)("Phase manually set to " + phase)), false);
        return 0;
    }

    private static int togglePhotosensitiveMode(CommandSourceStack source) {
        ServerLevel world;
        boolean current = PhotosensitiveSafetyProcedure.isPhotosensitiveModeEnabled((LevelAccessor)(world = source.m_81372_()));
        PhotosensitiveSafetyProcedure.setPhotosensitiveMode((LevelAccessor)world, !current);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7aPhotosensitive safety mode: " + (!current ? "\u00a72ENABLED" : "\u00a7cDISABLED"))), true);
        return 1;
    }

    private static int executeGetMultiplayerScale(CommandSourceStack src) {
        double currentFactor = ChunkTensionProcedure.getMultiplayerScaleFactor();
        src.m_288197_(() -> Component.m_237113_((String)("\u00a7aCurrent multiplayer scale factor: \u00a7f" + String.format("%.2f", currentFactor))), false);
        return 1;
    }

    private static int executeSetMultiplayerScale(CommandSourceStack src, double factor) {
        ChunkTensionProcedure.setMultiplayerScaleFactor(factor);
        double mult2p = 1.0 / (1.0 + factor);
        double mult3p = 1.0 / (1.0 + 2.0 * factor);
        double mult4p = 1.0 / (1.0 + 3.0 * factor);
        src.m_288197_(() -> Component.m_237113_((String)("\u00a7aMultiplayer scale factor set to: \u00a7f" + String.format("%.2f", factor) + "\n\u00a77Spawn rate multipliers:\n \u00a7f2 players: \u00a7e" + String.format("%.2f", mult2p) + "x\n \u00a7f3 players: \u00a7e" + String.format("%.2f", mult3p) + "x\n \u00a7f4 players: \u00a7e" + String.format("%.2f", mult4p) + "x\n" + (factor < 0.2 ? "\u00a76\u26a0 Lower values = weaker reduction (harder in multiplayer)" : (factor > 0.5 ? "\u00a76\u26a0 Higher values = stronger reduction (easier in multiplayer)" : "\u00a72\u2713 Balanced multiplayer scaling")))), true);
        return 1;
    }

    private static int executeGetSingleplayerMultiplier(CommandSourceStack src) {
        double currentMultiplier = ChunkTensionProcedure.getSingleplayerMultiplier();
        src.m_288197_(() -> Component.m_237113_((String)("\u00a7aCurrent singleplayer multiplier: \u00a7f" + String.format("%.2f", currentMultiplier) + "x")), false);
        return 1;
    }

    private static int executeSetSingleplayerMultiplier(CommandSourceStack src, double multiplier) {
        ChunkTensionProcedure.setSingleplayerMultiplier(multiplier);
        String interpretation = multiplier == 0.0 ? "\u00a7c\u26a0 No spawns in singleplayer (0x)" : (multiplier < 0.5 ? "\u00a76\u26a0 Much fewer spawns (very easy)" : (multiplier < 0.8 ? "\u00a7e\u26a0 Fewer spawns (easier)" : (multiplier < 1.2 ? "\u00a72\u2713 Normal spawn rate" : (multiplier <= 1.5 ? "\u00a7c\u26a0 More spawns (harder)" : "\u00a74\u26a0 Much more spawns (very hard)"))));
        src.m_288197_(() -> Component.m_237113_((String)("\u00a7aSingleplayer multiplier set to: \u00a7f" + String.format("%.2f", multiplier) + "x\n" + interpretation)), true);
        return 1;
    }
}

