/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TrapdoorEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int EVENT_DURATION = 240;
    private static final Map<Integer, TrapdoorEventState> activeEvents = new HashMap<Integer, TrapdoorEventState>();
    private static final Map<BlockPos, Long> trapdoorCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validTrapdoors = TrapdoorEventsProcedure.findValidTrapdoors(server, player);
        if (validTrapdoors.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validTrapdoors.removeIf(pos -> trapdoorCooldowns.containsKey(pos) && currentTime < trapdoorCooldowns.get(pos));
        if (validTrapdoors.isEmpty()) {
            return;
        }
        BlockPos chosen = validTrapdoors.get(server.m_213780_().m_188503_(validTrapdoors.size()));
        TrapdoorEvent event = TrapdoorEvent.values()[server.m_213780_().m_188503_(TrapdoorEvent.values().length)];
        trapdoorCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new TrapdoorEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, TrapdoorEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, TrapdoorEventState> entry = iterator.next();
            TrapdoorEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case TRAPDOOR_KNOCKING: {
                    TrapdoorEventsProcedure.handleTrapdoorKnocking(server, state);
                    if (state.tickCount < 240) break;
                    iterator.remove();
                    break;
                }
                case TRAPDOOR_VIOLENT_KNOCKING: {
                    TrapdoorEventsProcedure.handleTrapdoorViolentKnocking(server, state);
                    if (state.tickCount < 240) break;
                    iterator.remove();
                    break;
                }
                case TRAPDOOR_REPETITIVE_KNOCKING: {
                    TrapdoorEventsProcedure.handleTrapdoorRepetitiveKnocking(server, state);
                    if (state.bangPhase < 4) break;
                    iterator.remove();
                    break;
                }
                case TRAPDOOR_SLOW_KNOCKING: {
                    TrapdoorEventsProcedure.handleTrapdoorSlowKnocking(server, state);
                    if (state.tickCount < 240) break;
                    iterator.remove();
                    break;
                }
                case TRAPDOOR_PROXIMITY_SLAM_CLOSE: {
                    TrapdoorEventsProcedure.handleProximitySlamClose(server, state);
                    if (!state.slamTriggered && state.tickCount < 600) break;
                    iterator.remove();
                    break;
                }
                case TRAPDOOR_PROXIMITY_SLAM_OPEN_CLOSE: {
                    TrapdoorEventsProcedure.handleProximitySlamOpenClose(server, state);
                    if (!state.slamTriggered && state.tickCount < 600) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<BlockPos> findValidTrapdoors(ServerLevel server, Player player) {
        ArrayList<BlockPos> trapdoors = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof TrapDoorBlock)) continue;
                    trapdoors.add(pos.m_7949_());
                }
            }
        }
        return trapdoors;
    }

    private static void handleTrapdoorKnocking(ServerLevel server, TrapdoorEventState state) {
        if (state.tickCount % 40 == 0 && state.knockCount > 0) {
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12634_, SoundSource.BLOCKS, 0.7f, 0.9f + server.m_213780_().m_188501_() * 0.2f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_() + 0.5, (double)state.trapdoorPos.m_123343_() + 0.5, 3, 0.1, 0.2, 0.1, 0.01);
            --state.knockCount;
        }
        if (state.knockCount == 0 && state.tickCount % 80 == 0) {
            state.knockCount = 3;
        }
    }

    private static void handleTrapdoorViolentKnocking(ServerLevel server, TrapdoorEventState state) {
        if (state.tickCount % 8 == 0) {
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12634_, SoundSource.BLOCKS, 1.0f + server.m_213780_().m_188501_() * 0.3f, 0.7f + server.m_213780_().m_188501_() * 0.4f);
            server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, server.m_8055_(state.trapdoorPos)), (double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_() + 0.5, (double)state.trapdoorPos.m_123343_() + 0.5, 5, 0.2, 0.3, 0.2, 0.1);
        }
        if (state.tickCount % 40 == 0) {
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12599_, SoundSource.BLOCKS, 0.8f, 0.6f);
        }
        if (state.tickCount == 220) {
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_11922_, SoundSource.HOSTILE, 0.5f, 0.4f);
        }
    }

    private static void handleTrapdoorRepetitiveKnocking(ServerLevel server, TrapdoorEventState state) {
        int knocksPerPhase = 8;
        int currentKnock = state.tickCount % (knocksPerPhase * 5);
        if (currentKnock % 5 == 0 && currentKnock < knocksPerPhase * 5) {
            float intensity = 0.6f + (float)state.bangPhase * 0.2f;
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12634_, SoundSource.BLOCKS, intensity, 0.8f - (float)state.bangPhase * 0.1f);
            server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, server.m_8055_(state.trapdoorPos)), (double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_() + 0.5, (double)state.trapdoorPos.m_123343_() + 0.5, 3 + state.bangPhase * 2, 0.2, 0.2, 0.2, 0.1);
        }
        if (state.tickCount % (knocksPerPhase * 5) == 0 && state.tickCount > 0) {
            ++state.bangPhase;
            if (state.bangPhase <= 4) {
                server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12599_, SoundSource.BLOCKS, 0.5f + (float)state.bangPhase * 0.2f, 0.7f);
            }
        }
    }

    private static void handleTrapdoorSlowKnocking(ServerLevel server, TrapdoorEventState state) {
        if (state.tickCount % 60 == 0) {
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12634_, SoundSource.BLOCKS, 0.5f, 0.7f + server.m_213780_().m_188501_() * 0.2f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_() + 0.5, (double)state.trapdoorPos.m_123343_() + 0.5, 2, 0.1, 0.1, 0.1, 0.01);
        }
        if (state.tickCount % 120 == 0) {
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12628_, SoundSource.BLOCKS, 0.3f, 0.6f);
        }
    }

    private static void handleProximitySlamClose(ServerLevel server, TrapdoorEventState state) {
        BlockState trapdoorState = server.m_8055_(state.trapdoorPos);
        if (!(trapdoorState.m_60734_() instanceof TrapDoorBlock)) {
            return;
        }
        if (!((Boolean)trapdoorState.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) {
            state.slamTriggered = true;
            return;
        }
        double distance = state.player.m_20275_((double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_(), (double)state.trapdoorPos.m_123343_() + 0.5);
        if (distance <= 4.0 && !state.slamTriggered) {
            server.m_7731_(state.trapdoorPos, (BlockState)trapdoorState.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(false)), 3);
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12011_, SoundSource.BLOCKS, 1.5f, 0.6f);
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12601_, SoundSource.BLOCKS, 1.0f, 0.8f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_() + 0.5, (double)state.trapdoorPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_() + 0.5, (double)state.trapdoorPos.m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.05);
            state.slamTriggered = true;
        }
    }

    private static void handleProximitySlamOpenClose(ServerLevel server, TrapdoorEventState state) {
        BlockState currentState;
        BlockState trapdoorState = server.m_8055_(state.trapdoorPos);
        if (!(trapdoorState.m_60734_() instanceof TrapDoorBlock)) {
            return;
        }
        if (!state.openedForSlam && state.tickCount == 1) {
            boolean currentlyOpen = (Boolean)trapdoorState.m_61143_((Property)TrapDoorBlock.f_57514_);
            if (!currentlyOpen) {
                server.m_7731_(state.trapdoorPos, (BlockState)trapdoorState.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true)), 3);
                server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12629_, SoundSource.BLOCKS, 0.6f, 0.8f);
                state.openedForSlam = true;
            } else {
                state.openedForSlam = true;
            }
        }
        if (!state.openedForSlam) {
            return;
        }
        double distance = state.player.m_20275_((double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_(), (double)state.trapdoorPos.m_123343_() + 0.5);
        if (distance <= 4.0 && !state.slamTriggered && ((Boolean)(currentState = server.m_8055_(state.trapdoorPos)).m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) {
            server.m_7731_(state.trapdoorPos, (BlockState)currentState.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(false)), 3);
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12011_, SoundSource.BLOCKS, 1.5f, 0.6f);
            server.m_5594_(null, state.trapdoorPos, SoundEvents.f_12601_, SoundSource.BLOCKS, 1.0f, 0.8f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_() + 0.5, (double)state.trapdoorPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)state.trapdoorPos.m_123341_() + 0.5, (double)state.trapdoorPos.m_123342_() + 0.5, (double)state.trapdoorPos.m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.05);
            state.slamTriggered = true;
        }
    }

    private static enum TrapdoorEvent {
        TRAPDOOR_KNOCKING,
        TRAPDOOR_VIOLENT_KNOCKING,
        TRAPDOOR_REPETITIVE_KNOCKING,
        TRAPDOOR_SLOW_KNOCKING,
        TRAPDOOR_PROXIMITY_SLAM_CLOSE,
        TRAPDOOR_PROXIMITY_SLAM_OPEN_CLOSE;

    }

    private static class TrapdoorEventState {
        TrapdoorEvent event;
        Player player;
        BlockPos trapdoorPos;
        int tickCount;
        int knockCount;
        int bangPhase;
        boolean slamTriggered;
        boolean openedForSlam;

        TrapdoorEventState(TrapdoorEvent event, Player player, BlockPos trapdoorPos) {
            this.event = event;
            this.player = player;
            this.trapdoorPos = trapdoorPos;
            this.tickCount = 0;
            this.knockCount = 3;
            this.bangPhase = 0;
            this.slamTriggered = false;
            this.openedForSlam = false;
        }
    }
}

