/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.client;

import java.util.List;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="from_the_caves", value={Dist.CLIENT})
public class SkyStormFogRenderer {
    private static final double DETECTION_RADIUS = 120.0;
    private static float currentRedTint = 0.0f;
    private static float currentDarkness = 0.0f;
    private static final float MAX_RED_TINT = 0.7f;
    private static final float MAX_DARKNESS = 0.6f;
    private static final float FADE_SPEED = 0.02f;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        AABB searchBox = new AABB(player.m_20185_() - 120.0, player.m_20186_() - 120.0, player.m_20189_() - 120.0, player.m_20185_() + 120.0, player.m_20186_() + 120.0, player.m_20189_() + 120.0);
        List nearbyEntities = mc.f_91073_.m_6249_((Entity)null, searchBox, entity -> entity.m_6095_().equals(FromTheCavesModEntities.FROMTHECAVESSKY.get()));
        if (!nearbyEntities.isEmpty()) {
            double minDistance = 120.0;
            for (Entity entity2 : nearbyEntities) {
                double dist = player.m_20270_(entity2);
                if (!(dist < minDistance)) continue;
                minDistance = dist;
            }
            float intensity = (float)(1.0 - minDistance / 120.0);
            float targetTint = 0.7f * intensity;
            float targetDark = 0.6f * intensity;
            currentRedTint = currentRedTint < targetTint ? Math.min(currentRedTint + 0.02f, targetTint) : Math.max(currentRedTint - 0.02f, targetTint);
            currentDarkness = currentDarkness < targetDark ? Math.min(currentDarkness + 0.02f, targetDark) : Math.max(currentDarkness - 0.02f, targetDark);
        } else {
            currentRedTint = Math.max(0.0f, currentRedTint - 0.02f);
            currentDarkness = Math.max(0.0f, currentDarkness - 0.02f);
        }
        if (currentRedTint > 0.0f || currentDarkness > 0.0f) {
            float red = event.getRed();
            float green = event.getGreen();
            float blue = event.getBlue();
            red *= 1.0f - currentDarkness * 0.7f;
            green *= 1.0f - currentDarkness * 0.7f;
            blue *= 1.0f - currentDarkness * 0.7f;
            red = Math.min(1.0f, red + currentRedTint);
            green = Math.max(0.0f, green - currentRedTint * 0.8f);
            blue = Math.max(0.0f, blue - currentRedTint * 0.8f);
            event.setRed(red);
            event.setGreen(green);
            event.setBlue(blue);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onFogDensity(ViewportEvent.RenderFog event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        if (currentDarkness > 0.1f) {
            float fogStart = event.getFarPlaneDistance() * (1.0f - currentDarkness * 0.7f);
            float fogEnd = event.getFarPlaneDistance() * (1.0f - currentDarkness * 0.5f);
            event.setNearPlaneDistance(fogStart * 0.5f);
            event.setFarPlaneDistance(fogEnd);
            event.setCanceled(true);
        }
    }
}

