/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LadderEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int SOUND_DURATION = 200;
    private static final Map<Integer, LadderEventState> activeEvents = new HashMap<Integer, LadderEventState>();
    private static final Map<BlockPos, Long> ladderCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validLadders = LadderEventsProcedure.findValidLadders(server, player);
        if (validLadders.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validLadders.removeIf(pos -> ladderCooldowns.containsKey(pos) && currentTime < ladderCooldowns.get(pos));
        if (validLadders.isEmpty()) {
            return;
        }
        BlockPos chosen = validLadders.get(server.m_213780_().m_188503_(validLadders.size()));
        LadderEvent event = LadderEvent.values()[server.m_213780_().m_188503_(LadderEvent.values().length)];
        ladderCooldowns.put(chosen, currentTime + 5L);
        List<BlockPos> ladderSequence = LadderEventsProcedure.getLadderSequence(server, chosen, 5);
        activeEvents.put(eventIdCounter++, new LadderEventState(event, player, ladderSequence));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, LadderEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, LadderEventState> entry = iterator.next();
            LadderEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case LADDER_STEP_SOUNDS: {
                    LadderEventsProcedure.handleStepSounds(server, state);
                    break;
                }
                case LADDER_BREAK_SOUNDS: {
                    LadderEventsProcedure.handleBreakSounds(server, state);
                    break;
                }
                case LADDER_BREATH_SOUND: {
                    LadderEventsProcedure.handleBreathSound(server, state);
                }
            }
            if (state.tickCount < 200) continue;
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidLadders(ServerLevel server, Player player) {
        ArrayList<BlockPos> ladders = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof LadderBlock)) continue;
                    ladders.add(pos.m_7949_());
                }
            }
        }
        return ladders;
    }

    private static List<BlockPos> getLadderSequence(ServerLevel server, BlockPos start, int length) {
        ArrayList<BlockPos> sequence = new ArrayList<BlockPos>();
        sequence.add(start.m_7949_());
        BlockPos current = start;
        for (int i = 1; i < length; ++i) {
            BlockPos above = current.m_7494_();
            BlockPos below = current.m_7495_();
            if (server.m_8055_(above).m_60734_() instanceof LadderBlock && !sequence.contains(above)) {
                sequence.add(above.m_7949_());
                current = above;
                continue;
            }
            if (!(server.m_8055_(below).m_60734_() instanceof LadderBlock) || sequence.contains(below)) break;
            sequence.add(below.m_7949_());
            current = below;
        }
        return sequence;
    }

    private static void handleStepSounds(ServerLevel server, LadderEventState state) {
        if (state.tickCount % 15 == 0 && state.currentStep < state.ladderPositions.size()) {
            BlockPos stepPos = state.ladderPositions.get(state.currentStep);
            server.m_5594_(null, stepPos, SoundEvents.f_12024_, SoundSource.BLOCKS, 0.4f, 1.0f);
            ++state.currentStep;
        }
    }

    private static void handleBreakSounds(ServerLevel server, LadderEventState state) {
        if (state.tickCount % 25 == 0 && !state.ladderPositions.isEmpty()) {
            BlockPos randomLadder = state.ladderPositions.get(server.m_213780_().m_188503_(state.ladderPositions.size()));
            server.m_5594_(null, randomLadder, SoundEvents.f_12630_, SoundSource.BLOCKS, 0.3f, 0.8f + server.m_213780_().m_188501_() * 0.4f);
        }
    }

    private static void handleBreathSound(ServerLevel server, LadderEventState state) {
        if (state.tickCount % 60 == 0 && LadderEventsProcedure.isPlayerOnLadder(state.player)) {
            Vec3 lookAngle = state.player.m_20154_();
            Vec3 behindPlayer = state.player.m_20182_().m_82492_(lookAngle.f_82479_ * 2.0, 0.0, lookAngle.f_82481_ * 2.0);
            BlockPos soundPos = new BlockPos(Mth.m_14107_((double)behindPlayer.f_82479_), Mth.m_14107_((double)behindPlayer.f_82480_), Mth.m_14107_((double)behindPlayer.f_82481_));
            server.m_5594_(null, soundPos, SoundEvents.f_12320_, SoundSource.AMBIENT, 0.5f, 1.0f);
        }
    }

    private static boolean isPlayerOnLadder(Player player) {
        BlockPos playerPos = player.m_20183_();
        return player.m_9236_().m_8055_(playerPos).m_60734_() instanceof LadderBlock || player.m_9236_().m_8055_(playerPos.m_7495_()).m_60734_() instanceof LadderBlock;
    }

    private static enum LadderEvent {
        LADDER_STEP_SOUNDS,
        LADDER_BREAK_SOUNDS,
        LADDER_BREATH_SOUND;

    }

    private static class LadderEventState {
        LadderEvent event;
        Player player;
        List<BlockPos> ladderPositions;
        int tickCount;
        int currentStep;

        LadderEventState(LadderEvent event, Player player, List<BlockPos> ladderPositions) {
            this.event = event;
            this.player = player;
            this.ladderPositions = ladderPositions;
            this.tickCount = 0;
            this.currentStep = 0;
        }
    }
}

