/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.List;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PossessedAquaticAbilitiesProcedure {
    private static final double SQUID_HOVER_SPEED = 0.3;
    private static final int SQUID_INK_COOLDOWN_CLOSE = 30;
    private static final int SQUID_INK_COOLDOWN_NORMAL = 60;
    private static final int SQUID_INK_PARTICLE_COOLDOWN = 40;
    private static final double SQUID_DETECTION_RANGE = 32.0;
    private static final double SQUID_CLOSE_RANGE = 4.0;
    private static final double SQUID_INK_SPEED = 1.2;
    private static final double SALMON_SPEED = 1.6;
    private static final double SALMON_DASH_PROB = 0.01;
    private static final int SALMON_DASH_DURATION = 30;
    private static final int SALMON_DASH_COOLDOWN = 80;
    private static final double SALMON_DASH_SPEED = 1.9;
    private static final double SALMON_ATTACK_RANGE = 2.5;
    private static final float SALMON_DAMAGE = 1.5f;
    private static final double GOAT_CHARGE_PROB = 0.008;
    private static final int GOAT_CHARGE_STARE = 20;
    private static final int GOAT_CHARGE_DURATION = 50;
    private static final int GOAT_CHARGE_COOLDOWN = 100;
    private static final double GOAT_CHARGE_SPEED = 1.9;
    private static final double GOAT_ATTACK_RANGE = 3.5;
    private static final float GOAT_DAMAGE = 6.0f;
    private static final double GOAT_NORMAL_SPEED = 1.45;

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().f_46443_) {
            return;
        }
        if (mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_SQ.get()) || mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_SAL.get()) || mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_G.get())) {
            CompoundTag pd = mob.getPersistentData();
            long now = mob.m_9236_().m_46467_();
            pd.m_128356_("aquatic_angry_time", now);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        EntityType type = mob.m_6095_();
        if (!(type.equals(FromTheCavesModEntities.POSSESSED_SQ.get()) || type.equals(FromTheCavesModEntities.POSSESSED_SAL.get()) || type.equals(FromTheCavesModEntities.POSSESSED_G.get()))) {
            return;
        }
        Player tgt = server.m_45930_((Entity)mob, 64.0);
        if (tgt == null) {
            return;
        }
        CompoundTag pd = mob.getPersistentData();
        long now = server.m_46467_();
        double dist = mob.m_20270_((Entity)tgt);
        if (type.equals(FromTheCavesModEntities.POSSESSED_SQ.get())) {
            PossessedAquaticAbilitiesProcedure.handleSquidBehavior(mob, tgt, pd, now, dist, server);
        } else if (type.equals(FromTheCavesModEntities.POSSESSED_SAL.get())) {
            PossessedAquaticAbilitiesProcedure.handleSalmonBehavior(mob, tgt, pd, now, dist, server);
        } else if (type.equals(FromTheCavesModEntities.POSSESSED_G.get())) {
            PossessedAquaticAbilitiesProcedure.handleGoatBehavior(mob, tgt, pd, now, dist, server);
        }
    }

    private static void handleSquidBehavior(Mob mob, Player tgt, CompoundTag pd, long now, double dist, ServerLevel server) {
        long lastInk;
        long lastInkParticle;
        int shootCooldown;
        if (!pd.m_128441_("squid_wander_x")) {
            PossessedAquaticAbilitiesProcedure.setNewWanderTarget(mob, pd, tgt, now);
        }
        double dx = tgt.m_20185_() - mob.m_20185_();
        double dz = tgt.m_20189_() - mob.m_20189_();
        double dy = tgt.m_20186_() + (double)tgt.m_20192_() - (mob.m_20186_() + (double)mob.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float flat = (float)Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_146926_(pitch);
        long lastWanderChange = pd.m_128454_("squid_last_wander_change");
        if (now - lastWanderChange > 60L || Math.random() < 0.03) {
            PossessedAquaticAbilitiesProcedure.setNewWanderTarget(mob, pd, tgt, now);
        }
        double wanderX = pd.m_128459_("squid_wander_x");
        double wanderY = pd.m_128459_("squid_wander_y");
        double wanderZ = pd.m_128459_("squid_wander_z");
        Vec3 wanderPos = new Vec3(wanderX, wanderY, wanderZ);
        double wanderDist = mob.m_20182_().m_82554_(wanderPos);
        if (wanderDist > 2.0) {
            mob.m_21573_().m_26519_(wanderX, wanderY, wanderZ, 0.3);
        } else {
            PossessedAquaticAbilitiesProcedure.setNewWanderTarget(mob, pd, tgt, now);
        }
        boolean isClose = dist <= 4.0;
        int n = shootCooldown = isClose ? 30 : 60;
        if (isClose && now - (lastInkParticle = pd.m_128454_("squid_last_ink_particle")) >= 40L) {
            PossessedAquaticAbilitiesProcedure.spawnInkParticleCloud(mob, tgt, pd, now, server);
        }
        if (dist <= 32.0 && now - (lastInk = pd.m_128454_("squid_last_ink")) >= (long)shootCooldown) {
            PossessedAquaticAbilitiesProcedure.shootInkSac(mob, tgt, pd, now, server);
        }
        if (now % 20L == 0L) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123795_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 2, 0.3, 0.3, 0.3, 0.01);
        }
    }

    private static void setNewWanderTarget(Mob mob, CompoundTag pd, Player tgt, long now) {
        double angle = Math.random() * 2.0 * Math.PI;
        double radius = 6.0 + Math.random() * 10.0;
        double offsetX = Math.cos(angle) * radius;
        double offsetZ = Math.sin(angle) * radius;
        double targetX = tgt.m_20185_() + offsetX;
        double targetZ = tgt.m_20189_() + offsetZ;
        double targetY = tgt.m_20186_() + (Math.random() - 0.5) * 6.0;
        pd.m_128347_("squid_wander_x", targetX);
        pd.m_128347_("squid_wander_y", targetY);
        pd.m_128347_("squid_wander_z", targetZ);
        pd.m_128356_("squid_last_wander_change", now);
    }

    private static void spawnInkParticleCloud(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        double cloudX = mob.m_20185_();
        double cloudY = mob.m_20186_() + 0.5;
        double cloudZ = mob.m_20189_();
        server.m_8767_((ParticleOptions)ParticleTypes.f_123765_, cloudX, cloudY, cloudZ, 30, 1.0, 1.0, 1.0, 0.1);
        AABB damageBox = new AABB(cloudX - 1.5, cloudY - 1.5, cloudZ - 1.5, cloudX + 1.5, cloudY + 1.5, cloudZ + 1.5);
        List players = server.m_45976_(Player.class, damageBox);
        for (Player player : players) {
            if (!((double)player.m_20270_((Entity)mob) <= 2.0)) continue;
            player.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 2.0f);
        }
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12441_, SoundSource.HOSTILE, 1.0f, 0.8f);
        pd.m_128356_("squid_last_ink_particle", now);
    }

    private static void shootInkSac(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        Snowball inkSac = new Snowball((Level)server, (LivingEntity)mob);
        inkSac.getPersistentData().m_128379_("is_ink_sac", true);
        Vec3 dir = tgt.m_146892_().m_82546_(mob.m_146892_()).m_82541_();
        inkSac.m_20256_(dir.m_82490_(1.2));
        inkSac.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
        server.m_7967_((Entity)inkSac);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123765_, mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_(), 10, 0.3, 0.3, 0.3, 0.05);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12441_, SoundSource.HOSTILE, 1.0f, 1.0f);
        pd.m_128356_("squid_last_ink", now);
    }

    private static void handleSalmonBehavior(Mob mob, Player tgt, CompoundTag pd, long now, double dist, ServerLevel server) {
        int dashState = pd.m_128451_("salmon_dash_state");
        long dashStart = pd.m_128454_("salmon_dash_start");
        long lastDashEnd = pd.m_128454_("salmon_last_dash_end");
        double dx = tgt.m_20185_() - mob.m_20185_();
        double dz = tgt.m_20189_() - mob.m_20189_();
        double dy = tgt.m_20186_() + (double)tgt.m_20192_() - (mob.m_20186_() + (double)mob.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float flat = (float)Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_146926_(pitch);
        if (dashState == 0) {
            mob.m_6710_((LivingEntity)tgt);
            if (!pd.m_128441_("salmon_wander_x") || Math.random() < 0.02) {
                PossessedAquaticAbilitiesProcedure.setNewSalmonWanderTarget(mob, pd, tgt, now);
            }
            double wanderX = pd.m_128459_("salmon_wander_x");
            double wanderY = pd.m_128459_("salmon_wander_y");
            double wanderZ = pd.m_128459_("salmon_wander_z");
            Vec3 wanderPos = new Vec3(wanderX, wanderY, wanderZ);
            double wanderDist = mob.m_20182_().m_82554_(wanderPos);
            if (dist > 2.5) {
                if (wanderDist > 2.0) {
                    mob.m_21573_().m_26519_(wanderX, wanderY, wanderZ, 1.6);
                } else {
                    PossessedAquaticAbilitiesProcedure.setNewSalmonWanderTarget(mob, pd, tgt, now);
                }
            } else {
                long lastAttack = pd.m_128454_("salmon_last_attack");
                if (now - lastAttack >= 15L) {
                    tgt.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 1.5f);
                    pd.m_128356_("salmon_last_attack", now);
                }
            }
            if (now - lastDashEnd >= 80L && dist >= 5.0 && dist <= 20.0 && Math.random() < 0.01) {
                Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                pd.m_128347_("dash_dir_x", dir.f_82479_);
                pd.m_128347_("dash_dir_y", dir.f_82480_);
                pd.m_128347_("dash_dir_z", dir.f_82481_);
                pd.m_128405_("salmon_dash_state", 1);
                pd.m_128356_("salmon_dash_start", now);
                server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12329_, SoundSource.HOSTILE, 1.5f, 0.8f);
            }
        } else if (dashState == 1) {
            long elapsed = now - dashStart;
            double dirX = pd.m_128459_("dash_dir_x");
            double dirY = pd.m_128459_("dash_dir_y");
            double dirZ = pd.m_128459_("dash_dir_z");
            mob.m_20334_(dirX * 1.9, dirY * 1.9, dirZ * 1.9);
            if (elapsed % 3L == 0L) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123795_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 5, 0.3, 0.3, 0.3, 0.1);
            }
            AABB hitbox = mob.m_20191_().m_82400_(0.5);
            List players = server.m_45976_(Player.class, hitbox);
            for (Player player : players) {
                if (pd.m_128471_("dash_hit_" + String.valueOf(player.m_20148_()))) continue;
                player.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 2.25f);
                player.m_147240_(1.0, mob.m_20185_() - player.m_20185_(), mob.m_20189_() - player.m_20189_());
                pd.m_128379_("dash_hit_" + String.valueOf(player.m_20148_()), true);
            }
            if (elapsed >= 30L) {
                pd.m_128405_("salmon_dash_state", 0);
                pd.m_128356_("salmon_last_dash_end", now);
                pd.m_128473_("dash_hit_" + String.valueOf(tgt.m_20148_()));
            }
        }
    }

    private static void setNewSalmonWanderTarget(Mob mob, CompoundTag pd, Player tgt, long now) {
        double angle = Math.random() * 2.0 * Math.PI;
        double radius = 4.0 + Math.random() * 8.0;
        double offsetX = Math.cos(angle) * radius;
        double offsetZ = Math.sin(angle) * radius;
        double targetX = tgt.m_20185_() + offsetX;
        double targetZ = tgt.m_20189_() + offsetZ;
        double targetY = tgt.m_20186_() + (Math.random() - 0.5) * 4.0;
        pd.m_128347_("salmon_wander_x", targetX);
        pd.m_128347_("salmon_wander_y", targetY);
        pd.m_128347_("salmon_wander_z", targetZ);
    }

    private static void handleGoatBehavior(Mob mob, Player tgt, CompoundTag pd, long now, double dist, ServerLevel server) {
        int chargeState = pd.m_128451_("goat_charge_state");
        long chargeStart = pd.m_128454_("goat_charge_start");
        long lastChargeEnd = pd.m_128454_("goat_last_charge_end");
        double dx = tgt.m_20185_() - mob.m_20185_();
        double dz = tgt.m_20189_() - mob.m_20189_();
        double dy = tgt.m_20186_() + (double)tgt.m_20192_() - (mob.m_20186_() + (double)mob.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float flat = (float)Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_146926_(pitch);
        if (chargeState == 0) {
            mob.m_6710_((LivingEntity)tgt);
            if (dist > 3.5) {
                mob.m_21573_().m_5624_((Entity)tgt, 1.45);
            } else {
                mob.m_21573_().m_26573_();
                long lastAttack = pd.m_128454_("goat_last_attack");
                if (now - lastAttack >= 20L) {
                    tgt.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 4.2f);
                    pd.m_128356_("goat_last_attack", now);
                }
            }
            if (now - lastChargeEnd >= 100L && dist >= 5.0 && dist <= 15.0 && Math.random() < 0.008) {
                pd.m_128405_("goat_charge_state", 1);
                pd.m_128356_("goat_charge_start", now);
                mob.m_21573_().m_26573_();
                Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                pd.m_128347_("charge_dir_x", dir.f_82479_);
                pd.m_128347_("charge_dir_z", dir.f_82481_);
                server.m_5594_(null, mob.m_20183_(), SoundEvents.f_144169_, SoundSource.HOSTILE, 2.0f, 1.0f);
            }
        } else if (chargeState == 1) {
            long elapsed = now - chargeStart;
            mob.m_21573_().m_26573_();
            mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
            if (elapsed % 5L == 0L) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123792_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 1, 0.3, 0.3, 0.3, 0.0);
            }
            if (elapsed >= 20L) {
                pd.m_128405_("goat_charge_state", 2);
                pd.m_128356_("goat_charge_start", now);
            }
        } else if (chargeState == 2) {
            long elapsed = now - chargeStart;
            double dirX = pd.m_128459_("charge_dir_x");
            double dirZ = pd.m_128459_("charge_dir_z");
            mob.m_20334_(dirX * 1.9, mob.m_20184_().f_82480_, dirZ * 1.9);
            if (elapsed % 3L == 0L) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, mob.m_20185_(), mob.m_20186_() + 0.2, mob.m_20189_(), 3, 0.2, 0.1, 0.2, 0.02);
            }
            if (elapsed % 10L == 0L) {
                server.m_5594_(null, mob.m_20183_(), SoundEvents.f_144151_, SoundSource.HOSTILE, 1.0f, 0.8f);
            }
            AABB hitbox = mob.m_20191_().m_82400_(0.8);
            List players = server.m_45976_(Player.class, hitbox);
            for (Player player : players) {
                if (pd.m_128471_("charge_hit_" + String.valueOf(player.m_20148_()))) continue;
                player.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 10.799999f);
                player.m_147240_(2.0, mob.m_20185_() - player.m_20185_(), mob.m_20189_() - player.m_20189_());
                pd.m_128379_("charge_hit_" + String.valueOf(player.m_20148_()), true);
                server.m_5594_(null, mob.m_20183_(), SoundEvents.f_144170_, SoundSource.HOSTILE, 2.0f, 1.0f);
            }
            if (elapsed >= 50L || mob.f_19862_) {
                pd.m_128405_("goat_charge_state", 0);
                pd.m_128356_("goat_last_charge_end", now);
                pd.m_128473_("charge_hit_" + String.valueOf(tgt.m_20148_()));
                if (mob.f_19862_) {
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
                    server.m_5594_(null, mob.m_20183_(), SoundEvents.f_144170_, SoundSource.HOSTILE, 1.5f, 0.9f);
                }
            }
        }
    }
}

