/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2STEALEntity;
import net.mcreator.fromthecaves.procedures.StealManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ThiefBehaviorProcedure {
    private static final int BREAK_INTERVAL = 5;
    private static final double CHASE_SPEED = 0.6;
    private static final double ESCAPE_SPEED = 0.8;
    private static final int ESCAPE_RADIUS = 40;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity ent = event.getEntity();
        if (!(ent instanceof FROMTHECAVES2STEALEntity)) {
            return;
        }
        FROMTHECAVES2STEALEntity thief = (FROMTHECAVES2STEALEntity)ent;
        if (ent.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)ent.m_9236_();
        CompoundTag data = thief.getPersistentData();
        int bc = data.m_128451_("breakCounter") + 1;
        if (bc >= 5) {
            BlockPos pos = ent.m_20183_();
            Direction facing = ent.m_6350_();
            BlockPos blockFeet = pos.m_121945_(facing);
            BlockPos blockHead = blockFeet.m_7494_();
            if (!level.m_8055_(blockFeet).m_60795_()) {
                level.m_46961_(blockFeet, true);
            }
            if (!level.m_8055_(blockHead).m_60795_()) {
                level.m_46961_(blockHead, false);
            }
            bc = 0;
        }
        data.m_128405_("breakCounter", bc);
        Player target = level.m_45930_((Entity)ent, 16.0);
        if (target == null) {
            return;
        }
        if (target.m_150109_().m_7983_()) {
            thief.m_146870_();
            return;
        }
        boolean stolen = data.m_128471_("stolen");
        PathNavigation nav = thief.m_21573_();
        if (!stolen) {
            thief.m_21557_(false);
            Path path = nav.m_6570_((Entity)target, 0);
            if (path != null) {
                nav.m_26536_(path, 0.6);
            }
            if ((double)ent.m_20270_((Entity)target) <= 1.0) {
                ThiefBehaviorProcedure.stealFromPlayer(thief, target, level, data);
            }
        } else {
            double ex = data.m_128459_("escapeX");
            double ey = data.m_128459_("escapeY");
            double ez = data.m_128459_("escapeZ");
            nav.m_26519_(ex, ey, ez, 0.8);
            if (!target.m_142582_((Entity)ent)) {
                ItemStack stolenStack = ItemStack.m_41712_((CompoundTag)data.m_128469_("stolenItem"));
                StealManagerProcedure.scheduleReturn((ResourceKey<Level>)level.m_46472_(), stolenStack, level.m_46467_());
                thief.m_146870_();
            }
        }
    }

    private static void stealFromPlayer(FROMTHECAVES2STEALEntity thief, Player player, ServerLevel level, CompoundTag data) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int size = player.m_150109_().m_6643_();
        for (int i = 0; i < size; ++i) {
            if (player.m_150109_().m_8020_(i).m_41619_()) continue;
            slots.add(i);
        }
        if (slots.isEmpty()) {
            return;
        }
        RandomSource rng = player.m_217043_();
        int slotIdx = (Integer)slots.get(rng.m_188503_(slots.size()));
        ItemStack stack = player.m_150109_().m_8020_(slotIdx);
        ItemStack stolen = stack.m_41620_(1);
        player.m_150109_().m_6836_(slotIdx, stack);
        thief.m_8061_(EquipmentSlot.MAINHAND, stolen);
        data.m_128379_("stolen", true);
        data.m_128365_("stolenItem", (Tag)stolen.serializeNBT());
        double ex = thief.m_20185_() + (rng.m_188500_() * 2.0 - 1.0) * 40.0;
        double ez = thief.m_20189_() + (rng.m_188500_() * 2.0 - 1.0) * 40.0;
        data.m_128347_("escapeX", ex);
        data.m_128347_("escapeY", thief.m_20186_());
        data.m_128347_("escapeZ", ez);
        thief.m_21051_(Attributes.f_22279_).m_22100_(0.8);
        thief.m_21573_().m_26519_(ex, thief.m_20186_(), ez, 0.8);
    }
}

