/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CatsEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 4.0E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 5.0E-5;
    private static final double MAX_PROB_PHASE2 = 5.5E-5;
    private static final int SCAN_RADIUS = 20;
    private static final int DURATION_TICKS = 160;
    private static final int MIN_DELAY_TICKS = 200;
    private static final int MAX_DELAY_TICKS = 600;
    private static final Map<Integer, CatState> active = new HashMap<Integer, CatState>();
    private static int counter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 4.0E-5 : 5.0E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<Entity> cats = CatsEventsProcedure.findCats(server, player);
        if (cats.isEmpty()) {
            return;
        }
        CatEvent choice = CatEvent.values()[server.m_213780_().m_188503_(CatEvent.values().length)];
        active.put(counter++, new CatState(choice, player, cats));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, CatState>> it = active.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, CatState> entry = it.next();
            CatState s = entry.getValue();
            if (!(s.player.m_9236_() instanceof ServerLevel)) {
                it.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)s.player.m_9236_();
            ++s.tickCount;
            long now = server.m_46467_();
            Iterator<UUID> catIt = s.cats.iterator();
            while (catIt.hasNext()) {
                UUID id = catIt.next();
                Entity en = CatsEventsProcedure.findEntityByUUID(server, s.player, id, 20.0);
                if (en == null || en.m_213877_() || en.m_6095_() != EntityType.f_20553_) {
                    catIt.remove();
                    s.nextSoundTicks.remove(id);
                    if (s.event != CatEvent.ALL_FLEE) continue;
                    s.addedGoals.remove(id);
                    continue;
                }
                Cat c = (Cat)en;
                if (!c.m_6084_()) {
                    catIt.remove();
                    s.nextSoundTicks.remove(id);
                    if (s.event != CatEvent.ALL_FLEE) continue;
                    s.addedGoals.remove(id);
                    continue;
                }
                if (s.event == CatEvent.TRACK_INVISIBLE) {
                    double px = c.m_20185_() + Math.cos((double)(s.tickCount + c.m_19879_()) * 0.1) * 2.0;
                    double pz = c.m_20189_() + Math.sin((double)(s.tickCount + c.m_19879_()) * 0.1) * 2.0;
                    float yaw = (float)(Mth.m_14136_((double)(pz - c.m_20189_()), (double)(px - c.m_20185_())) * 57.29577951308232) - 90.0f;
                    c.m_146922_(yaw);
                    c.f_20885_ = yaw;
                    c.m_20256_(Vec3.f_82478_);
                    continue;
                }
                if (s.event == CatEvent.ALL_FLEE) {
                    long nextSound = s.nextSoundTicks.getOrDefault(id, 0L);
                    if (now < nextSound) continue;
                    ResourceLocation rl = new ResourceLocation("minecraft", "entity.cat.hiss");
                    SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound != null) {
                        server.m_5594_(null, c.m_20183_(), sound, SoundSource.NEUTRAL, 0.7f, 1.0f + server.m_213780_().m_188501_() * 0.2f);
                    }
                    int delay = 200 + server.m_213780_().m_188503_(401);
                    s.nextSoundTicks.put(id, now + (long)(delay / 2) + (long)server.m_213780_().m_188503_(delay / 2));
                    continue;
                }
                if (s.event != CatEvent.FREEZE_LOOK) continue;
                float yaw = (float)(Mth.m_14136_((double)(s.player.m_20189_() - c.m_20189_()), (double)(s.player.m_20185_() - c.m_20185_())) * 57.29577951308232) - 90.0f;
                c.m_146922_(yaw);
                c.f_20885_ = yaw;
                c.m_20256_(Vec3.f_82478_);
                long nextSound = s.nextSoundTicks.getOrDefault(id, 0L);
                if (now < nextSound) continue;
                ResourceLocation rl = new ResourceLocation("minecraft", "entity.cat.purr");
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                if (sound != null) {
                    server.m_5594_(null, c.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 0.9f + server.m_213780_().m_188501_() * 0.2f);
                }
                int delay = 200 + server.m_213780_().m_188503_(401);
                s.nextSoundTicks.put(id, now + (long)(delay / 2) + (long)server.m_213780_().m_188503_(delay / 2));
            }
            if (s.tickCount < 160 && !s.cats.isEmpty()) continue;
            if (s.event == CatEvent.ALL_FLEE) {
                for (UUID id : new ArrayList<UUID>(s.cats)) {
                    Entity en = CatsEventsProcedure.findEntityByUUID(server, s.player, id, 20.0);
                    if (!(en instanceof Mob)) continue;
                    Mob mob = (Mob)en;
                    Goal goal = s.addedGoals.get(id);
                    if (goal == null) continue;
                    mob.f_21345_.m_25363_(goal);
                }
            }
            it.remove();
        }
    }

    private static List<Entity> findCats(ServerLevel server, Player player) {
        AABB box = player.m_20191_().m_82400_(20.0);
        return server.m_6443_(Entity.class, box, e -> e.m_6095_() == EntityType.f_20553_);
    }

    private static Entity findEntityByUUID(ServerLevel server, Player player, UUID id, double radius) {
        AABB box = player.m_20191_().m_82400_(radius);
        for (Entity en : server.m_6443_(Entity.class, box, e -> true)) {
            if (!en.m_20148_().equals(id)) continue;
            return en;
        }
        return null;
    }

    private static enum CatEvent {
        TRACK_INVISIBLE,
        ALL_FLEE,
        FREEZE_LOOK;

    }

    private static class CatState {
        CatEvent event;
        Player player;
        List<UUID> cats;
        int tickCount;
        Map<UUID, Long> nextSoundTicks;
        Map<UUID, Goal> addedGoals;

        CatState(CatEvent event, Player player, List<Entity> cats) {
            UUID id;
            this.event = event;
            this.player = player;
            this.cats = new ArrayList<UUID>();
            this.nextSoundTicks = new HashMap<UUID, Long>();
            this.addedGoals = new HashMap<UUID, Goal>();
            for (Entity e : cats) {
                id = e.m_20148_();
                this.cats.add(id);
                this.nextSoundTicks.put(id, 0L);
            }
            if (this.event == CatEvent.ALL_FLEE) {
                for (Entity e : cats) {
                    id = e.m_20148_();
                    Cat c = (Cat)e;
                    Predicate<LivingEntity> toAvoid = ent -> ent == this.player;
                    Predicate<LivingEntity> ignore = ent -> false;
                    AvoidEntityGoal goal = new AvoidEntityGoal((PathfinderMob)c, Player.class, toAvoid, 12.0f, 1.0, 1.5, ignore);
                    c.f_21345_.m_25352_(0, (Goal)goal);
                    this.addedGoals.put(id, (Goal)goal);
                }
            }
            this.tickCount = 0;
        }
    }
}

