/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class DisableMinersMineStructureProcedure {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        ServerLevel level = event.getServer().m_129783_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        DisableMinersMineStructureProcedure.createDynamicDatapack(phase);
    }

    private static void createDynamicDatapack(int phase) {
        try {
            Path datapackPath = FMLPaths.GAMEDIR.get().resolve("config").resolve("fromthecaves_dynamic_datapack");
            Path dataPath = datapackPath.resolve("data").resolve("fromthecaves").resolve("worldgen");
            Path structureSetPath = dataPath.resolve("structure_set");
            Files.createDirectories(structureSetPath, new FileAttribute[0]);
            JsonObject packMcmeta = new JsonObject();
            JsonObject pack = new JsonObject();
            pack.addProperty("pack_format", (Number)15);
            pack.addProperty("description", "Dynamic structure configuration");
            packMcmeta.add("pack", (JsonElement)pack);
            Files.writeString(datapackPath.resolve("pack.mcmeta"), (CharSequence)GSON.toJson((JsonElement)packMcmeta), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            int spacing = 28;
            int separation = 25;
            if (phase == 1 || phase == 2 || phase == 3) {
                spacing = 15000;
                separation = 14500;
            }
            JsonObject structureSet = new JsonObject();
            JsonArray structures = new JsonArray();
            JsonObject structureEntry = new JsonObject();
            structureEntry.addProperty("structure", "from_the_caves:miners_mine");
            structureEntry.addProperty("weight", (Number)1);
            structures.add((JsonElement)structureEntry);
            structureSet.add("structures", (JsonElement)structures);
            JsonObject placement = new JsonObject();
            placement.addProperty("type", "minecraft:random_spread");
            placement.addProperty("spacing", (Number)spacing);
            placement.addProperty("separation", (Number)separation);
            placement.addProperty("salt", (Number)1159639991);
            structureSet.add("placement", (JsonElement)placement);
            Files.writeString(structureSetPath.resolve("miners_mine.json"), (CharSequence)GSON.toJson((JsonElement)structureSet), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

