/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import net.mcreator.fromthecaves.procedures.NoAfectarProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GhostPathfindingProcedure {
    private static final double PHASE_THROUGH_SPEED = 0.3;
    private static final String TAG_TRANSPARENT_BREAK_COOLDOWN = "fromCavesTransparentBreakCd";
    private static final int COOLDOWN_TICKS = 20;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (NoAfectarProcedure.shouldSkip((Entity)entity)) {
            return;
        }
        ResourceLocation entityId = entity.m_6095_().m_204041_().m_205785_().m_135782_();
        if (entityId == null) {
            return;
        }
        if (!entityId.m_135827_().equals("from_the_caves")) {
            return;
        }
        if (entityId.m_135815_().startsWith("possessed_")) {
            return;
        }
        Level level = mob.m_9236_();
        BlockPos currentPos = mob.m_20183_();
        CompoundTag data = mob.getPersistentData();
        if (data.m_128441_(TAG_TRANSPARENT_BREAK_COOLDOWN)) {
            int cd = data.m_128451_(TAG_TRANSPARENT_BREAK_COOLDOWN) - 1;
            if (cd > 0) {
                data.m_128405_(TAG_TRANSPARENT_BREAK_COOLDOWN, cd);
            } else {
                data.m_128473_(TAG_TRANSPARENT_BREAK_COOLDOWN);
            }
            return;
        }
        BlockPos feetPos = currentPos;
        BlockPos headPos = currentPos.m_7494_();
        BlockState feetState = level.m_8055_(feetPos);
        BlockState headState = level.m_8055_(headPos);
        boolean feetTransparent = GhostPathfindingProcedure.isTransparentObstacle(feetState);
        boolean headTransparent = GhostPathfindingProcedure.isTransparentObstacle(headState);
        if (feetTransparent || headTransparent) {
            GhostPathfindingProcedure.handlePhaseThrough(mob, level, feetPos, headPos, feetTransparent, headTransparent);
            GhostPathfindingProcedure.breakTransparentBlocksInCube(mob, currentPos);
            data.m_128405_(TAG_TRANSPARENT_BREAK_COOLDOWN, 20);
        }
    }

    private static void breakTransparentBlocksInCube(Mob mob, BlockPos centerPos) {
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ArrayList<BlockPos> transparentPositions = new ArrayList<BlockPos>();
        for (int dx = 0; dx < 2; ++dx) {
            for (int dy = 0; dy < 2; ++dy) {
                for (int dz = 0; dz < 2; ++dz) {
                    BlockPos checkPos = centerPos.m_7918_(dx, dy, dz);
                    BlockState state = level.m_8055_(checkPos);
                    if (ProtectedBlocksProcedure.isProtected(state) || !GhostPathfindingProcedure.isTransparentObstacle(state) || state.m_60795_()) continue;
                    transparentPositions.add(checkPos.m_7949_());
                }
            }
        }
        for (BlockPos transparentPos : transparentPositions) {
            if (transparentPos == null) continue;
            RestoreBrokenBlocksManagerProcedure.destroyAndRecord(serverLevel, transparentPos, false);
        }
    }

    private static void handlePhaseThrough(Mob mob, Level level, BlockPos feetPos, BlockPos headPos, boolean feetTransparent, boolean headTransparent) {
        AttributeInstance speedAttr;
        Vec3 phaseMotion;
        Vec3 horizontalMotion;
        Vec3 motion = mob.m_20184_();
        if (feetTransparent && motion.m_165925_() > 0.001) {
            horizontalMotion = new Vec3(motion.f_82479_, 0.0, motion.f_82481_).m_82541_();
            phaseMotion = new Vec3(horizontalMotion.f_82479_ * 0.3, motion.f_82480_, horizontalMotion.f_82481_ * 0.3);
            mob.m_20256_(phaseMotion);
        }
        if (headTransparent && motion.m_165925_() > 0.001) {
            horizontalMotion = new Vec3(motion.f_82479_, 0.0, motion.f_82481_).m_82541_();
            phaseMotion = new Vec3(horizontalMotion.f_82479_ * 0.3, motion.f_82480_, horizontalMotion.f_82481_ * 0.3);
            mob.m_20256_(phaseMotion);
        }
        if (mob.m_21573_() != null && mob.m_21573_().m_26570_() != null && (feetTransparent || headTransparent) && (speedAttr = mob.m_21051_(Attributes.f_22279_)) != null) {
            double baseSpeed = speedAttr.m_22115_();
            speedAttr.m_22100_(baseSpeed * 1.2);
        }
    }

    private static boolean isTransparentObstacle(BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        if (state.m_60713_(Blocks.f_50058_) || state.m_60713_(Blocks.f_50147_) || state.m_60713_(Blocks.f_50148_) || state.m_60713_(Blocks.f_50202_) || state.m_60713_(Blocks.f_50203_) || state.m_60713_(Blocks.f_50204_) || state.m_60713_(Blocks.f_50205_) || state.m_60713_(Blocks.f_50206_) || state.m_60713_(Blocks.f_50207_) || state.m_60713_(Blocks.f_50208_) || state.m_60713_(Blocks.f_50209_) || state.m_60713_(Blocks.f_50210_) || state.m_60713_(Blocks.f_50211_) || state.m_60713_(Blocks.f_50212_) || state.m_60713_(Blocks.f_50213_) || state.m_60713_(Blocks.f_50214_) || state.m_60713_(Blocks.f_50215_) || state.m_60713_(Blocks.f_152498_)) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50185_) || state.m_60713_(Blocks.f_50303_) || state.m_60713_(Blocks.f_50304_) || state.m_60713_(Blocks.f_50305_) || state.m_60713_(Blocks.f_50306_) || state.m_60713_(Blocks.f_50307_) || state.m_60713_(Blocks.f_50361_) || state.m_60713_(Blocks.f_50362_) || state.m_60713_(Blocks.f_50363_) || state.m_60713_(Blocks.f_50364_) || state.m_60713_(Blocks.f_50365_) || state.m_60713_(Blocks.f_50366_) || state.m_60713_(Blocks.f_50367_) || state.m_60713_(Blocks.f_50368_) || state.m_60713_(Blocks.f_50369_) || state.m_60713_(Blocks.f_50370_) || state.m_60713_(Blocks.f_50371_)) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50132_) || state.m_60713_(Blocks.f_50479_) || state.m_60713_(Blocks.f_50480_) || state.m_60713_(Blocks.f_50481_) || state.m_60713_(Blocks.f_50482_) || state.m_60713_(Blocks.f_50483_) || state.m_60713_(Blocks.f_220852_) || state.m_60713_(Blocks.f_271219_) || state.m_60713_(Blocks.f_244641_) || state.m_60713_(Blocks.f_50661_) || state.m_60713_(Blocks.f_50662_) || state.m_60713_(Blocks.f_50198_)) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50192_) || state.m_60713_(Blocks.f_50474_) || state.m_60713_(Blocks.f_50475_) || state.m_60713_(Blocks.f_50476_) || state.m_60713_(Blocks.f_50477_) || state.m_60713_(Blocks.f_50478_) || state.m_60713_(Blocks.f_220850_) || state.m_60713_(Blocks.f_271274_) || state.m_60713_(Blocks.f_244313_) || state.m_60713_(Blocks.f_50665_) || state.m_60713_(Blocks.f_50666_)) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50183_) || state.m_60713_(Blocks.f_50184_) || state.m_60713_(Blocks.f_50033_)) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50050_) || state.m_60713_(Blocks.f_50051_) || state.m_60713_(Blocks.f_50052_) || state.m_60713_(Blocks.f_50053_) || state.m_60713_(Blocks.f_50054_) || state.m_60713_(Blocks.f_50055_) || state.m_60713_(Blocks.f_220838_) || state.m_60713_(Blocks.f_271115_) || state.m_60713_(Blocks.f_152470_) || state.m_60713_(Blocks.f_152471_)) {
            return true;
        }
        return !state.m_60815_();
    }
}

