/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.NoAfectarSaltoProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class JumpWhenNoPathProcedure {
    private static final double MAX_CHECK_DIST = 64.0;
    private static final double MIN_DIST_TO_FLY = 4.0;
    private static final int STUCK_TICKS_THRESHOLD = 8;
    private static final double MIN_HEIGHT_DIFF_TO_FLY = 3.0;
    private static final String KEY_STUCK_TICKS = "ftc_noPathTicks";
    private static final String KEY_FLY_COOLDOWN = "ftc_flyCooldown";
    private static final String KEY_FLYING = "ftc_flying";
    private static final String KEY_FLY_START_TIME = "ftc_flyStartTime";
    private static final int FLY_COOLDOWN_TICKS = 200;
    private static final int FLY_DURATION_TICKS = 300;
    private static final double BASE_PURSUIT_SPEED = 0.7;
    private static final double MAX_PURSUIT_SPEED = 0.7;
    private static final double MIN_PURSUIT_SPEED = 0.7;
    private static final double VERTICAL_SPEED_MULTIPLIER = 1.2;
    private static final double RANDOM_DRIFT_FACTOR = 0.05;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent ev) {
        boolean hasPath;
        double dz;
        double dy;
        int cooldown;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        ResourceLocation rl = BuiltInRegistries.f_256780_.m_7981_((Object)mob.m_6095_());
        if (rl == null) {
            return;
        }
        if (!"from_the_caves".equals(rl.m_135827_())) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (data.m_128471_(KEY_FLYING)) {
            JumpWhenNoPathProcedure.handleFlyingBehavior(mob, server, data);
            return;
        }
        if (data.m_128441_(KEY_FLY_COOLDOWN) && (cooldown = data.m_128451_(KEY_FLY_COOLDOWN)) > 0) {
            data.m_128405_(KEY_FLY_COOLDOWN, --cooldown);
            if (cooldown <= 0) {
                data.m_128473_(KEY_FLY_COOLDOWN);
            }
            return;
        }
        Player target = server.m_45930_((Entity)mob, 64.0);
        if (target == null) {
            data.m_128473_(KEY_STUCK_TICKS);
            return;
        }
        if (NoAfectarSaltoProcedure.deberiaSaltear((Entity)mob)) {
            return;
        }
        double dx = target.m_20185_() - mob.m_20185_();
        double distSq = dx * dx + (dy = target.m_20186_() - mob.m_20186_()) * dy + (dz = target.m_20189_() - mob.m_20189_()) * dz;
        if (distSq <= 16.0) {
            data.m_128473_(KEY_STUCK_TICKS);
            return;
        }
        boolean shouldFlyDueToHeight = dy >= 3.0;
        PathNavigation nav = mob.m_21573_();
        boolean bl = hasPath = !nav.m_26571_();
        if (hasPath && !shouldFlyDueToHeight) {
            data.m_128473_(KEY_STUCK_TICKS);
            return;
        }
        double motionSpeedSq = mob.m_20184_().f_82479_ * mob.m_20184_().f_82479_ + mob.m_20184_().f_82481_ * mob.m_20184_().f_82481_;
        if (motionSpeedSq > 1.0E-4 && !shouldFlyDueToHeight) {
            data.m_128473_(KEY_STUCK_TICKS);
            return;
        }
        if (shouldFlyDueToHeight && JumpWhenNoPathProcedure.hasLineOfSight(mob, target)) {
            JumpWhenNoPathProcedure.startFlying(mob, server, data);
            return;
        }
        int stuck = data.m_128441_(KEY_STUCK_TICKS) ? data.m_128451_(KEY_STUCK_TICKS) : 0;
        data.m_128405_(KEY_STUCK_TICKS, ++stuck);
        if (stuck >= 8) {
            JumpWhenNoPathProcedure.startFlying(mob, server, data);
        }
    }

    private static boolean hasLineOfSight(Mob mob, Player target) {
        Vec3 mobEye = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_(), 0.0);
        Vec3 targetEye = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        ClipContext context = new ClipContext(mobEye, targetEye, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob);
        BlockHitResult result = mob.m_9236_().m_45547_(context);
        return result.m_6662_() == HitResult.Type.MISS;
    }

    private static void startFlying(Mob mob, ServerLevel server, CompoundTag data) {
        data.m_128379_(KEY_FLYING, true);
        data.m_128356_(KEY_FLY_START_TIME, server.m_46467_());
        data.m_128473_(KEY_STUCK_TICKS);
        mob.m_20242_(true);
        mob.m_21557_(true);
    }

    private static void handleFlyingBehavior(Mob mob, ServerLevel server, CompoundTag data) {
        long flyStartTime = data.m_128454_(KEY_FLY_START_TIME);
        long currentTime = server.m_46467_();
        long flyTimeElapsed = currentTime - flyStartTime;
        if (flyTimeElapsed >= 300L) {
            JumpWhenNoPathProcedure.stopFlying(mob, data);
            return;
        }
        Player target = server.m_45930_((Entity)mob, 64.0);
        if (target == null) {
            JumpWhenNoPathProcedure.stopFlying(mob, data);
            return;
        }
        mob.m_21391_((Entity)target, 360.0f, 360.0f);
        double dx = target.m_20185_() - mob.m_20185_();
        double dz = target.m_20189_() - mob.m_20189_();
        double dy = target.m_20188_() - (mob.m_20186_() + (double)mob.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * 180.0 / Math.PI);
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_146926_(pitch);
        Vec3 fromMobEye = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_(), 0.0);
        Vec3 toPlayerEye = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        Vec3 dir = toPlayerEye.m_82546_(fromMobEye).m_82541_();
        double distanceToPlayer = fromMobEye.m_82554_(toPlayerEye);
        double speedFactor = Math.min(1.0, distanceToPlayer / 20.0);
        double pursuitSpeed = 0.7 + speedFactor * 0.0;
        double verticalAdjustment = dir.f_82480_ > 0.0 ? 1.2 : (dir.f_82480_ < 0.0 ? 1.2 : 1.0);
        Vec3 adjustedDir = new Vec3(dir.f_82479_, dir.f_82480_ * verticalAdjustment, dir.f_82481_).m_82541_();
        double randomAngle = server.f_46441_.m_188500_() * Math.PI * 2.0;
        double driftX = Math.cos(randomAngle) * 0.05;
        double driftZ = Math.sin(randomAngle) * 0.05;
        Vec3 drift = new Vec3(driftX, 0.0, driftZ);
        adjustedDir = adjustedDir.m_82549_(drift).m_82541_();
        Vec3 motion = adjustedDir.m_82490_(pursuitSpeed);
        mob.m_20256_(motion);
        mob.f_19794_ = true;
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        mob.f_19794_ = false;
    }

    private static void stopFlying(Mob mob, CompoundTag data) {
        data.m_128473_(KEY_FLYING);
        data.m_128473_(KEY_FLY_START_TIME);
        data.m_128405_(KEY_FLY_COOLDOWN, 200);
        mob.m_20242_(false);
        mob.m_21557_(false);
    }
}

