/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LeverEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.0E-5;
    private static final double BASE_PROB_PHASE2 = 4.0E-5;
    private static final double MAX_PROB_PHASE2 = 4.5E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int SOUND_DURATION = 200;
    private static final Map<Integer, LeverEventState> activeEvents = new HashMap<Integer, LeverEventState>();
    private static final Map<BlockPos, Long> leverCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double maxProb = phase == 1 ? 4.0E-5 : 4.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validLevers = LeverEventsProcedure.findValidLevers(server, player);
        if (validLevers.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validLevers.removeIf(pos -> leverCooldowns.containsKey(pos) && currentTime < leverCooldowns.get(pos));
        if (validLevers.isEmpty()) {
            return;
        }
        BlockPos chosen = validLevers.get(server.m_213780_().m_188503_(validLevers.size()));
        leverCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new LeverEventState(player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, LeverEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, LeverEventState> entry = iterator.next();
            LeverEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            LeverEventsProcedure.handleLeverSwitches(server, state);
            if (state.tickCount < 200 && state.switchesRemaining > 0) continue;
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidLevers(ServerLevel server, Player player) {
        ArrayList<BlockPos> levers = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof LeverBlock)) continue;
                    levers.add(pos.m_7949_());
                }
            }
        }
        return levers;
    }

    private static void handleLeverSwitches(ServerLevel server, LeverEventState state) {
        if (state.tickCount >= state.nextSwitchTick && state.switchesRemaining > 0) {
            float pitch = 0.5f + server.m_213780_().m_188501_() * 1.0f;
            server.m_5594_(null, state.leverPos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.7f, pitch);
            if (server.m_213780_().m_188500_() < 0.4) {
                server.m_5594_(null, state.leverPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.2f, 1.5f + server.m_213780_().m_188501_() * 0.5f);
            }
            --state.switchesRemaining;
            state.nextSwitchTick = state.tickCount + 6 + server.m_213780_().m_188503_(4);
        }
    }

    private static class LeverEventState {
        Player player;
        BlockPos leverPos;
        int tickCount;
        int switchesRemaining;
        int nextSwitchTick;

        LeverEventState(Player player, BlockPos leverPos) {
            this.player = player;
            this.leverPos = leverPos;
            this.tickCount = 0;
            this.switchesRemaining = 3 + player.m_9236_().m_213780_().m_188503_(5);
            this.nextSwitchTick = 6 + player.m_9236_().m_213780_().m_188503_(4);
        }
    }
}

