/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESMINEREntity;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MinerAIProcedure {
    private static final int MIN_BREAK_INTERVAL = 5;
    private static final int MAX_BREAK_INTERVAL = 20;
    private static final int SIGHT_DELAY = 20;
    private static final int BLIND_TICKS = 100;
    private static final int FREEZE_DURATION = 40;
    private static final double FOLLOW_SPEED = 0.3;
    private static final double HIT_DISTANCE = 0.8;
    private static final double VISIBILITY_CHECK_RANGE = 32.0;
    private static final double SOUND_CHANCE = 0.007;
    private static final float SOUND_PITCH = 0.3f;
    private static final double MIN_BREAK_DISTANCE = 0.3;
    private static final double MAX_BREAK_DISTANCE = 1.0;

    @SubscribeEvent
    public static void onMinerTick(LivingEvent.LivingTickEvent ev) {
        long freezeUntil;
        SoundEvent scarySound;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof FROMTHECAVESMINEREntity)) {
            return;
        }
        FROMTHECAVESMINEREntity miner = (FROMTHECAVESMINEREntity)ent;
        if (miner.m_9236_().m_5776_()) {
            return;
        }
        Level level = miner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        if (!miner.getPersistentData().m_128471_("isMiner")) {
            return;
        }
        UUID tid = miner.getPersistentData().m_128342_("targetUUID");
        Player player = server.m_46003_(tid);
        if (player == null) {
            return;
        }
        CompoundTag nbt = miner.getPersistentData();
        long now = server.m_46467_();
        long firstSight = nbt.m_128454_("sightedTick");
        if (miner.f_19797_ % 2 == 0 && (double)server.f_46441_.m_188501_() < 0.007 && (scarySound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", "it_10"))) != null) {
            server.m_6263_(null, miner.m_20185_(), miner.m_20186_(), miner.m_20189_(), scarySound, SoundSource.AMBIENT, 1.0f, 0.3f);
        }
        if (firstSight == 0L && player.m_142582_((Entity)miner)) {
            nbt.m_128356_("sightedTick", now);
        }
        if (!nbt.m_128441_("nextBreakInterval")) {
            nbt.m_128405_("nextBreakInterval", 5 + server.f_46441_.m_188503_(16));
        }
        if (now < (freezeUntil = nbt.m_128454_("freezeUntil"))) {
            miner.m_20256_(Vec3.f_82478_);
            return;
        }
        int breakInterval = nbt.m_128451_("nextBreakInterval");
        if (miner.f_19797_ % breakInterval == 0) {
            MinerAIProcedure.breakBlocksInFront(server, miner, player);
            nbt.m_128405_("nextBreakInterval", 5 + server.f_46441_.m_188503_(16));
            if (!MinerAIProcedure.isVisibleToAnyPlayer(server, miner) && server.f_46441_.m_188501_() < 0.3f) {
                nbt.m_128356_("freezeUntil", now + 40L);
                return;
            }
        }
        if (firstSight > 0L && miner.m_21525_() && now >= firstSight + 20L) {
            miner.m_21557_(false);
        }
        if (!miner.m_21525_()) {
            Vec3 diff = player.m_20182_().m_82546_(miner.m_20182_());
            float yaw = (float)Math.toDegrees(Math.atan2(diff.f_82481_, diff.f_82479_)) - 90.0f;
            miner.m_146922_(yaw);
            miner.f_20885_ = yaw;
            miner.f_20883_ = yaw;
            Vec3 vel = diff.m_82541_().m_82490_(0.3);
            miner.m_20334_(vel.f_82479_, miner.m_20184_().f_82480_, vel.f_82481_);
            miner.m_6478_(MoverType.SELF, miner.m_20184_());
            if ((double)miner.m_20270_((Entity)player) < 0.8) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, false));
                SoundEvent cave = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambient.cave"));
                if (cave != null) {
                    server.m_6263_(null, miner.m_20185_(), miner.m_20186_(), miner.m_20189_(), cave, SoundSource.AMBIENT, 1.0f, 0.9f);
                }
                MinerAIProcedure.restoreMinersBlocks(server, miner);
                miner.m_146870_();
            }
        }
    }

    private static boolean isVisibleToAnyPlayer(ServerLevel server, FROMTHECAVESMINEREntity miner) {
        Vec3 minerEye = miner.m_146892_();
        for (Player player : server.m_6907_()) {
            ClipContext context;
            BlockHitResult result;
            Vec3 toMiner;
            if ((double)player.m_20270_((Entity)miner) > 32.0) continue;
            Vec3 playerEye = player.m_146892_();
            Vec3 lookVec = player.m_20154_();
            double dot = lookVec.m_82526_(toMiner = minerEye.m_82546_(playerEye).m_82541_());
            if (!(dot > 0.5) || (result = server.m_45547_(context = new ClipContext(playerEye, minerEye, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() != HitResult.Type.MISS) continue;
            return true;
        }
        return false;
    }

    private static void breakBlocksInFront(ServerLevel server, FROMTHECAVESMINEREntity miner, Player player) {
        Vec3 lookVec = miner.m_20154_();
        BlockPos minerPos = miner.m_20183_();
        double minerY = miner.m_20186_();
        double playerY = player.m_20186_();
        ArrayList<BlockPos> positionsToBreak = new ArrayList<BlockPos>();
        boolean canBreakDown = minerY - playerY >= 1.0;
        for (double distance = 0.3; distance <= 1.0; distance += 1.0) {
            int forwardX = (int)Math.round(lookVec.f_82479_ * distance);
            int forwardZ = (int)Math.round(lookVec.f_82481_ * distance);
            BlockPos headLevel = minerPos.m_7918_(forwardX, 1, forwardZ);
            positionsToBreak.add(headLevel);
            if (!canBreakDown) continue;
            BlockPos feetLevel = minerPos.m_7918_(forwardX, 0, forwardZ);
            positionsToBreak.add(feetLevel);
            BlockPos belowFeet = minerPos.m_7918_(forwardX, -1, forwardZ);
            positionsToBreak.add(belowFeet);
        }
        for (BlockPos pos : positionsToBreak) {
            BlockState state = server.m_8055_(pos);
            if (ProtectedBlocksProcedure.isProtected(state) || !MinerAIProcedure.isBreakableBlock(server, pos)) continue;
            RestoreBrokenBlocksManagerProcedure.destroyAndRecord(server, pos, false);
            SoundEvent breakSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.stone.break"));
            if (breakSound == null) continue;
            server.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), breakSound, SoundSource.BLOCKS, 0.8f, 0.9f + server.f_46441_.m_188501_() * 0.2f);
        }
    }

    private static boolean isBreakableBlock(ServerLevel server, BlockPos pos) {
        BlockState state = server.m_8055_(pos);
        return !state.m_60795_() && state.m_60734_() != Blocks.f_50752_ && state.m_60800_((BlockGetter)server, pos) >= 0.0f && !ProtectedBlocksProcedure.isProtected(state);
    }

    private static void saveBlockForRestoration(ServerLevel server, FROMTHECAVESMINEREntity miner, BlockPos pos) {
        BlockState state = server.m_8055_(pos);
        CompoundTag minerNbt = miner.getPersistentData();
        ListTag brokenBlocksList = minerNbt.m_128425_("brokenBlocksList", 9) ? minerNbt.m_128437_("brokenBlocksList", 10) : new ListTag();
        CompoundTag blockData = new CompoundTag();
        blockData.m_128405_("x", pos.m_123341_());
        blockData.m_128405_("y", pos.m_123342_());
        blockData.m_128405_("z", pos.m_123343_());
        CompoundTag stateTag = new CompoundTag();
        stateTag.m_128359_("blockId", ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString());
        CompoundTag propertiesTag = new CompoundTag();
        state.m_61148_().forEach((property, value) -> propertiesTag.m_128359_(property.m_61708_(), value.toString()));
        stateTag.m_128365_("properties", (Tag)propertiesTag);
        blockData.m_128365_("state", (Tag)stateTag);
        BlockEntity blockEntity = server.m_7702_(pos);
        if (blockEntity != null) {
            CompoundTag beTag = blockEntity.m_187480_();
            blockData.m_128365_("blockEntity", (Tag)beTag);
        }
        brokenBlocksList.add((Object)blockData);
        minerNbt.m_128365_("brokenBlocksList", (Tag)brokenBlocksList);
    }

    public static void restoreMinersBlocks(ServerLevel server, FROMTHECAVESMINEREntity miner) {
        CompoundTag minerNbt = miner.getPersistentData();
        if (!minerNbt.m_128425_("brokenBlocksList", 9)) {
            return;
        }
        ListTag brokenBlocksList = minerNbt.m_128437_("brokenBlocksList", 10);
        for (int i = 0; i < brokenBlocksList.size(); ++i) {
            CompoundTag blockData = brokenBlocksList.m_128728_(i);
            int x = blockData.m_128451_("x");
            int y = blockData.m_128451_("y");
            int z = blockData.m_128451_("z");
            BlockPos pos = new BlockPos(x, y, z);
            CompoundTag stateTag = blockData.m_128469_("state");
            String blockId = stateTag.m_128461_("blockId");
            BlockState state = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId))).m_49966_();
            if (stateTag.m_128441_("properties")) {
                CompoundTag propertiesTag = stateTag.m_128469_("properties");
                state.m_61147_().forEach(property -> {
                    String propName = property.m_61708_();
                    if (propertiesTag.m_128441_(propName)) {
                        String valueStr = propertiesTag.m_128461_(propName);
                        property.m_6215_(valueStr).ifPresent(value -> {});
                    }
                });
            }
            server.m_7731_(pos, state, 3);
            if (!blockData.m_128441_("blockEntity")) continue;
            CompoundTag beTag = blockData.m_128469_("blockEntity");
            BlockEntity newBE = server.m_7702_(pos);
            if (newBE == null) continue;
            newBE.m_142466_(beTag);
            newBE.m_6596_();
        }
        minerNbt.m_128473_("brokenBlocksList");
    }
}

