/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Phase1WatcherOutProcedure {
    private static final double BASE_PROB = 5.0E-5;
    private static final double MAX_PROB = 9.0E-5;
    private static final double MIN_DIST = 10.0;
    private static final double MAX_DIST = 50.0;
    private static final double DETECTION_RANGE = 70.0;
    private static final double APPROACH_TRIGGER_DIST = 8.0;
    private static final int STARE_DURATION_TICKS = 20;
    private static final double STALK_SPEED = 0.25;
    private static final double RETREAT_SPEED = 0.55;
    private static final int RETREAT_DURATION_TICKS = 160;
    private static final double TELEPORT_CHANCE = 0.12;
    private static final int TELEPORT_COOLDOWN = 120;
    private static final double DARKNESS_MANIPULATION_CHANCE = 0.15;
    private static final int DARKNESS_COOLDOWN = 200;
    private static final double BEHIND_WALL_CHANCE = 0.2;
    private static final double IN_SHADOWS_CHANCE = 0.25;
    private static final double UPSIDE_DOWN_CHANCE = 0.15;
    private static final double IN_WATER_CHANCE = 0.1;
    private static final double NEAR_STAIRS_CHANCE = 0.12;
    private static final double CORNER_LURK_CHANCE = 0.18;
    private static final int MAX_SPAWN_ATTEMPTS = 20;
    private static final int MAX_LIGHT_LEVEL = 4;
    private static final double PHASE_OUT_DISTANCE = 40.0;
    private static final int PHASE_OUT_TICKS = 60;
    private static final String KEY_SPAWN_TIME = "stalker_spawnTime";
    private static final String KEY_STARE_START = "stalker_stareStart";
    private static final String KEY_STALKING = "stalker_stalking";
    private static final String KEY_RETREATING = "stalker_retreating";
    private static final String KEY_RETREAT_START = "stalker_retreatStart";
    private static final String KEY_LAST_TELEPORT = "stalker_lastTeleport";
    private static final String KEY_LAST_DARKNESS = "stalker_lastDarkness";
    private static final String KEY_PHASE_OUT_START = "stalker_phaseOutStart";
    private static final String KEY_PHASING = "stalker_phasing";
    private static final String KEY_SPAWN_TYPE = "stalker_spawnType";
    private static final String KEY_TARGET_POS = "stalker_targetPos";
    private static final String KEY_INVERTED = "stalker_inverted";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (player.m_20186_() < 50.0) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 1 && phase != 2) {
            return;
        }
        long time = level.m_46468_() % 24000L;
        if (time < 13000L || time > 23000L) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 5.0E-5, 9.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        EntityType<?> chosenEntity = Phase1WatcherOutProcedure.chooseRandomStalkerEntity();
        BlockPos spawnPos = Phase1WatcherOutProcedure.findOptimalStalkerSpawn(level, player, chosenEntity);
        if (spawnPos == null) {
            return;
        }
        Mob mob = (Mob)chosenEntity.m_262496_(level, spawnPos, MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        mob.f_19794_ = false;
        Phase1WatcherOutProcedure.makeEntityLookAtPlayer(mob, player);
        CompoundTag data = mob.getPersistentData();
        data.m_128379_("phase1watcher_mob", true);
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_STALKING, false);
        data.m_128379_(KEY_RETREATING, false);
        data.m_128379_(KEY_PHASING, false);
        data.m_128473_(KEY_STARE_START);
        data.m_128473_(KEY_RETREAT_START);
        data.m_128356_(KEY_LAST_TELEPORT, 0L);
        data.m_128356_(KEY_LAST_DARKNESS, 0L);
        String spawnType = Phase1WatcherOutProcedure.determineSpawnType();
        data.m_128359_(KEY_SPAWN_TYPE, spawnType);
        if (spawnType.equals("upside_down")) {
            data.m_128379_(KEY_INVERTED, true);
        } else {
            data.m_128379_(KEY_INVERTED, false);
        }
    }

    private static EntityType<?> chooseRandomStalkerEntity() {
        double roll = Math.random();
        if (roll < 0.4) {
            return (EntityType)FromTheCavesModEntities.WATCHEYES.get();
        }
        if (roll < 0.75) {
            return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOWLARGE.get();
        }
        return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOWSPIDER.get();
    }

    private static String determineSpawnType() {
        double totalChance = 1.0;
        double roll = Math.random() * totalChance;
        double accumulated = 0.0;
        if (roll < (accumulated += 0.2)) {
            return "behind_wall";
        }
        if (roll < (accumulated += 0.25)) {
            return "shadows";
        }
        if (roll < (accumulated += 0.15)) {
            return "upside_down";
        }
        if (roll < (accumulated += 0.1)) {
            return "water";
        }
        if (roll < (accumulated += 0.12)) {
            return "stairs";
        }
        if (roll < (accumulated += 0.18)) {
            return "corner";
        }
        return "normal";
    }

    private static BlockPos findOptimalStalkerSpawn(ServerLevel level, Player player, EntityType<?> entityType) {
        BlockPos corner;
        BlockPos stairs;
        BlockPos water;
        BlockPos ceiling;
        BlockPos shadow;
        BlockPos wall;
        String spawnType = Phase1WatcherOutProcedure.determineSpawnType();
        if (spawnType.equals("behind_wall") && (wall = Phase1WatcherOutProcedure.findPositionBehindWall(level, player)) != null) {
            return wall;
        }
        if (spawnType.equals("shadows") && (shadow = Phase1WatcherOutProcedure.findDarkSpot(level, player)) != null) {
            return shadow;
        }
        if (spawnType.equals("upside_down") && (ceiling = Phase1WatcherOutProcedure.findCeilingPosition(level, player)) != null) {
            return ceiling;
        }
        if (spawnType.equals("water") && (water = Phase1WatcherOutProcedure.findPositionInWater(level, player)) != null) {
            return water;
        }
        if (spawnType.equals("stairs") && (stairs = Phase1WatcherOutProcedure.findPositionNearStairs(level, player)) != null) {
            return stairs;
        }
        if (spawnType.equals("corner") && (corner = Phase1WatcherOutProcedure.findCornerLurkPosition(level, player)) != null) {
            return corner;
        }
        for (int attempt = 0; attempt < 20; ++attempt) {
            int lightLevel;
            double angle = Math.random() * Math.PI * 2.0;
            double dist = 10.0 + Math.random() * 40.0;
            double sx = player.m_20185_() + Math.cos(angle) * dist;
            double sz = player.m_20189_() + Math.sin(angle) * dist;
            BlockPos testPos = Phase1WatcherOutProcedure.findSuitableGroundPosition(level, BlockPos.m_274561_((double)sx, (double)player.m_20186_(), (double)sz));
            if (testPos == null || (lightLevel = level.m_46803_(testPos)) > 4 && attempt < 15 || !Phase1WatcherOutProcedure.isPositionValid(level, testPos, player)) continue;
            return testPos;
        }
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 10.0 + Math.random() * 40.0;
        return BlockPos.m_274561_((double)(player.m_20185_() + Math.cos(angle) * dist), (double)player.m_20186_(), (double)(player.m_20189_() + Math.sin(angle) * dist));
    }

    private static BlockPos findPositionBehindWall(ServerLevel level, Player player) {
        Vec3 lookDir = player.m_20252_(1.0f).m_82541_();
        for (int dist = 8; dist <= 25; ++dist) {
            BlockState state;
            BlockPos checkPos = BlockPos.m_274561_((double)(player.m_20185_() + lookDir.f_82479_ * (double)dist), (double)player.m_20186_(), (double)(player.m_20189_() + lookDir.f_82481_ * (double)dist));
            if (!level.m_46749_(checkPos) || !(state = level.m_8055_(checkPos)).m_280296_() || state.m_60713_(Blocks.f_50752_)) continue;
            Vec3 wallNormal = lookDir.m_82541_();
            for (int behind = 1; behind <= 4; ++behind) {
                int lightLevel;
                BlockPos spawnPos = BlockPos.m_274561_((double)((double)checkPos.m_123341_() + wallNormal.f_82479_ * (double)behind), (double)checkPos.m_123342_(), (double)((double)checkPos.m_123343_() + wallNormal.f_82481_ * (double)behind));
                BlockPos groundPos = Phase1WatcherOutProcedure.findSuitableGroundPosition(level, spawnPos);
                if (groundPos == null || !Phase1WatcherOutProcedure.isPositionValid(level, groundPos, player) || (lightLevel = level.m_46803_(groundPos)) > 7) continue;
                return groundPos;
            }
        }
        return null;
    }

    private static BlockPos findDarkSpot(ServerLevel level, Player player) {
        for (int attempt = 0; attempt < 25; ++attempt) {
            int lightLevel;
            double angle = Math.random() * Math.PI * 2.0;
            double dist = 10.0 + Math.random() * 40.0;
            double sx = player.m_20185_() + Math.cos(angle) * dist;
            double sz = player.m_20189_() + Math.sin(angle) * dist;
            BlockPos testPos = Phase1WatcherOutProcedure.findSuitableGroundPosition(level, BlockPos.m_274561_((double)sx, (double)player.m_20186_(), (double)sz));
            if (testPos == null || (lightLevel = level.m_46803_(testPos)) > 4 || !Phase1WatcherOutProcedure.isPositionValid(level, testPos, player)) continue;
            return testPos;
        }
        return null;
    }

    private static BlockPos findCeilingPosition(ServerLevel level, Player player) {
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 10.0 + Math.random() * 20.0;
        double sx = player.m_20185_() + Math.cos(angle) * dist;
        double sz = player.m_20189_() + Math.sin(angle) * dist;
        int y = (int)player.m_20186_() + 3;
        while ((double)y <= Math.min(player.m_20186_() + 15.0, (double)(level.m_151558_() - 1))) {
            BlockPos testPos = BlockPos.m_274561_((double)sx, (double)y, (double)sz);
            BlockPos above = testPos.m_7494_();
            if (level.m_46749_(testPos) && level.m_46749_(above)) {
                int lightLevel;
                BlockState stateAt = level.m_8055_(testPos);
                BlockState stateAbove = level.m_8055_(above);
                if (stateAt.m_60795_() && stateAbove.m_280296_() && !stateAbove.m_60713_(Blocks.f_50752_) && (lightLevel = level.m_46803_(testPos)) <= 8) {
                    return testPos;
                }
            }
            ++y;
        }
        return null;
    }

    private static BlockPos findPositionInWater(ServerLevel level, Player player) {
        for (int attempt = 0; attempt < 20; ++attempt) {
            double angle = Math.random() * Math.PI * 2.0;
            double dist = 10.0 + Math.random() * 15.0;
            double sx = player.m_20185_() + Math.cos(angle) * dist;
            double sz = player.m_20189_() + Math.sin(angle) * dist;
            for (int dy = -3; dy <= 2; ++dy) {
                double distance;
                BlockPos below;
                BlockState state;
                BlockPos testPos = BlockPos.m_274561_((double)sx, (double)(player.m_20186_() + (double)dy), (double)sz);
                if (!level.m_46749_(testPos) || !(state = level.m_8055_(testPos)).m_60713_(Blocks.f_49990_) || !level.m_46749_(below = testPos.m_7495_()) || level.m_8055_(below).m_60795_() || !((distance = Math.sqrt(testPos.m_203193_((Position)player.m_20182_()))) >= 10.0) || !(distance <= 50.0)) continue;
                return testPos;
            }
        }
        return null;
    }

    private static BlockPos findPositionNearStairs(ServerLevel level, Player player) {
        BlockPos playerPos = player.m_20183_();
        for (int radius = 5; radius <= 18; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -3; dy <= 3; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockState state;
                        BlockPos checkPos;
                        if (Math.abs(dx) != radius && Math.abs(dz) != radius || !level.m_46749_(checkPos = playerPos.m_7918_(dx, dy, dz)) || !((state = level.m_8055_(checkPos)).m_60734_() instanceof StairBlock)) continue;
                        for (int offset = 1; offset <= 3; ++offset) {
                            int lightLevel;
                            BlockPos spawnPos = checkPos.m_7918_(0, offset, 0);
                            if (!Phase1WatcherOutProcedure.isPositionValidForSpawn(level, spawnPos) || (lightLevel = level.m_46803_(spawnPos)) > 6) continue;
                            return spawnPos;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static BlockPos findCornerLurkPosition(ServerLevel level, Player player) {
        int lightLevel;
        int[][] directions;
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 10.0 + Math.random() * 18.0;
        double sx = player.m_20185_() + Math.cos(angle) * dist;
        double sz = player.m_20189_() + Math.sin(angle) * dist;
        BlockPos basePos = Phase1WatcherOutProcedure.findSuitableGroundPosition(level, BlockPos.m_274561_((double)sx, (double)player.m_20186_(), (double)sz));
        if (basePos == null) {
            return null;
        }
        int wallsNearby = 0;
        for (int[] dir : directions = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
            BlockPos wallCheck = basePos.m_7918_(dir[0], 0, dir[1]);
            if (!level.m_46749_(wallCheck) || !level.m_8055_(wallCheck).m_280296_()) continue;
            ++wallsNearby;
        }
        if (wallsNearby >= 2 && Phase1WatcherOutProcedure.isPositionValid(level, basePos, player) && (lightLevel = level.m_46803_(basePos)) <= 5) {
            return basePos;
        }
        return null;
    }

    private static boolean isPositionValidForSpawn(ServerLevel level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_);
    }

    private static BlockPos findSuitableGroundPosition(ServerLevel level, BlockPos start) {
        BlockPos.MutableBlockPos mutable = start.m_122032_();
        for (int dy = 3; dy >= -5; --dy) {
            mutable.m_122178_(start.m_123341_(), start.m_123342_() + dy, start.m_123343_());
            if (!level.m_46749_((BlockPos)mutable)) continue;
            BlockState stateAt = level.m_8055_((BlockPos)mutable);
            BlockState stateBelow = level.m_8055_(mutable.m_7495_());
            if (!stateAt.m_60795_() || stateBelow.m_60795_() || !stateBelow.m_280296_()) continue;
            return mutable.m_7949_();
        }
        return null;
    }

    private static boolean isPositionValid(ServerLevel level, BlockPos pos, Player player) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (!state.m_60795_() && !state.m_60713_(Blocks.f_49990_)) {
            return false;
        }
        BlockPos above = pos.m_7494_();
        if (level.m_46749_(above) && !level.m_8055_(above).m_60795_()) {
            return false;
        }
        double dist = Math.sqrt(pos.m_203193_((Position)player.m_20182_()));
        return !(dist < 10.0) && !(dist > 50.0);
    }

    private static void makeEntityLookAtPlayer(Mob mob, Player player) {
        double dx = player.m_20185_() - mob.m_20185_();
        double dz = player.m_20189_() - mob.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        double dy = player.m_20188_() - mob.m_20188_();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(Math.atan2(dy, horizontalDist) * 180.0 / Math.PI);
        mob.m_146926_(pitch);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        EntityType type = mob.m_6095_();
        if (!(type.equals(FromTheCavesModEntities.WATCHEYES.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESSHADOWLARGE.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESSHADOWSPIDER.get()))) {
            return;
        }
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        if (data.m_128471_("hcs_houseCorner")) {
            return;
        }
        if (data.m_128471_("jumpscare_mob")) {
            return;
        }
        if (!data.m_128441_(KEY_SPAWN_TIME)) {
            return;
        }
        long now = level.m_46467_();
        Player player = level.m_45930_((Entity)mob, 70.0);
        if (player == null) {
            mob.m_146870_();
            return;
        }
        double dist = mob.m_20270_((Entity)player);
        boolean stalking = data.m_128471_(KEY_STALKING);
        boolean retreating = data.m_128471_(KEY_RETREATING);
        boolean phasing = data.m_128471_(KEY_PHASING);
        boolean inverted = data.m_128471_(KEY_INVERTED);
        if (phasing) {
            Phase1WatcherOutProcedure.handlePhasingOut(mob, data, level, player, now);
            return;
        }
        if (retreating) {
            Phase1WatcherOutProcedure.handleRetreatBehavior(mob, data, level, player, now);
            return;
        }
        if (!stalking) {
            Phase1WatcherOutProcedure.handleStaringBehavior(mob, data, level, player, now, dist, inverted);
            return;
        }
        Phase1WatcherOutProcedure.handleStalkingBehavior(mob, data, level, player, now, dist);
    }

    private static void handleStaringBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now, double dist, boolean inverted) {
        boolean inSightCone;
        Phase1WatcherOutProcedure.makeEntityLookAtPlayer(mob, player);
        if (inverted) {
            mob.m_20242_(true);
        }
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        if (dist <= 8.0) {
            Phase1WatcherOutProcedure.startStalking(mob, data, now);
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
        Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20186_(), mob.m_20189_() - player.m_20189_());
        if (toMob.m_82553_() == 0.0) {
            data.m_128473_(KEY_STARE_START);
            return;
        }
        Vec3 toMobNorm = toMob.m_82541_();
        double dot = playerLook.f_82479_ * toMobNorm.f_82479_ + playerLook.f_82480_ * toMobNorm.f_82480_ + playerLook.f_82481_ * toMobNorm.f_82481_;
        boolean bl = inSightCone = dot > 0.88 && hasLOS;
        if (inSightCone) {
            if (!data.m_128441_(KEY_STARE_START)) {
                data.m_128356_(KEY_STARE_START, now);
            } else {
                long started = data.m_128454_(KEY_STARE_START);
                if (now - started >= 20L) {
                    Phase1WatcherOutProcedure.startStalking(mob, data, now);
                    return;
                }
            }
        } else {
            data.m_128473_(KEY_STARE_START);
            if (Math.random() < 0.01) {
                Phase1WatcherOutProcedure.startStalking(mob, data, now);
            }
        }
        long spawnTime = data.m_128454_(KEY_SPAWN_TIME);
        if (now - spawnTime > 800L && Math.random() < 0.015 && !hasLOS) {
            mob.m_146870_();
            return;
        }
        Phase1WatcherOutProcedure.trySpecialAbilities(mob, data, level, player, now, hasLOS);
    }

    private static void handleStalkingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now, double dist) {
        boolean hasLOS = player.m_142582_((Entity)mob);
        if (hasLOS && dist < 25.0) {
            Phase1WatcherOutProcedure.startRetreating(mob, data, now);
            return;
        }
        Vec3 toPlayer = new Vec3(player.m_20185_() - mob.m_20185_(), 0.0, player.m_20189_() - mob.m_20189_());
        if (toPlayer.m_82556_() < 1.0E-6) {
            return;
        }
        Vec3 moveDir = toPlayer.m_82541_();
        mob.m_21557_(true);
        mob.f_19794_ = true;
        Vec3 motion = new Vec3(moveDir.f_82479_ * 0.25, mob.m_20184_().f_82480_ * 0.8, moveDir.f_82481_ * 0.25);
        mob.m_20256_(motion);
        double newX = mob.m_20185_() + motion.f_82479_;
        double newY = mob.m_20186_() + motion.f_82480_;
        double newZ = mob.m_20189_() + motion.f_82481_;
        mob.m_6021_(newX, newY, newZ);
        Phase1WatcherOutProcedure.makeEntityLookAtPlayer(mob, player);
        if (dist <= 8.0 && !hasLOS) {
            data.m_128379_(KEY_PHASING, true);
            data.m_128356_(KEY_PHASE_OUT_START, now);
            return;
        }
        Phase1WatcherOutProcedure.trySpecialAbilities(mob, data, level, player, now, hasLOS);
    }

    private static void handleRetreatBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        Vec3 fleeDir = new Vec3(mob.m_20185_() - player.m_20185_(), 0.0, mob.m_20189_() - player.m_20189_());
        if (fleeDir.m_82556_() < 1.0E-6) {
            Vec3 look = player.m_20252_(1.0f).m_82541_();
            fleeDir = new Vec3(-look.f_82479_, 0.0, -look.f_82481_);
        }
        Vec3 moveDir = new Vec3(fleeDir.f_82479_, 0.0, fleeDir.f_82481_).m_82541_();
        mob.m_21557_(true);
        mob.f_19794_ = true;
        Vec3 motion = new Vec3(moveDir.f_82479_ * 0.55, mob.m_20184_().f_82480_ * 0.8, moveDir.f_82481_ * 0.55);
        mob.m_20256_(motion);
        double newX = mob.m_20185_() + motion.f_82479_;
        double newY = mob.m_20186_() + motion.f_82480_;
        double newZ = mob.m_20189_() + motion.f_82481_;
        mob.m_6021_(newX, newY, newZ);
        long retreatStart = data.m_128454_(KEY_RETREAT_START);
        if (now - retreatStart >= 160L) {
            mob.m_146870_();
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        double dist = mob.m_20270_((Entity)player);
        if (!hasLOS && dist > 40.0) {
            data.m_128379_(KEY_PHASING, true);
            data.m_128356_(KEY_PHASE_OUT_START, now);
            return;
        }
    }

    private static void handlePhasingOut(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        mob.m_20334_(0.0, 0.0, 0.0);
        mob.m_21557_(true);
        long phaseStart = data.m_128454_(KEY_PHASE_OUT_START);
        long elapsed = now - phaseStart;
        if (elapsed % 5L == 0L) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 3, 0.3, 0.5, 0.3, 0.01);
        }
        if (elapsed >= 60L) {
            mob.m_146870_();
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        if (hasLOS) {
            mob.m_146870_();
            return;
        }
    }

    private static void trySpecialAbilities(Mob mob, CompoundTag data, ServerLevel level, Player player, long now, boolean hasLOS) {
        long lastDarkness;
        long lastTeleport = data.m_128454_(KEY_LAST_TELEPORT);
        if (now - lastTeleport >= 120L && !hasLOS && Math.random() < 0.12) {
            Phase1WatcherOutProcedure.attemptTeleportBehindPlayer(mob, player, level);
            data.m_128356_(KEY_LAST_TELEPORT, now);
        }
        if (now - (lastDarkness = data.m_128454_(KEY_LAST_DARKNESS)) >= 200L && Math.random() < 0.15) {
            Phase1WatcherOutProcedure.createDarknessEffect(mob, level, player);
            data.m_128356_(KEY_LAST_DARKNESS, now);
        }
    }

    private static void attemptTeleportBehindPlayer(Mob mob, Player player, ServerLevel level) {
        int lightLevel;
        Vec3 lookDir = player.m_20252_(1.0f).m_82541_();
        Vec3 behindDir = new Vec3(-lookDir.f_82479_, 0.0, -lookDir.f_82481_).m_82541_();
        double dist = 8.0 + Math.random() * 8.0;
        double tx = player.m_20185_() + behindDir.f_82479_ * dist;
        double tz = player.m_20189_() + behindDir.f_82481_ * dist;
        BlockPos targetPos = Phase1WatcherOutProcedure.findSuitableGroundPosition(level, BlockPos.m_274561_((double)tx, (double)player.m_20186_(), (double)tz));
        if (targetPos != null && (lightLevel = level.m_46803_(targetPos)) <= 7) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 8, 0.3, 0.5, 0.3, 0.03);
            mob.m_6021_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.5);
            Phase1WatcherOutProcedure.makeEntityLookAtPlayer(mob, player);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 8, 0.3, 0.5, 0.3, 0.03);
        }
    }

    private static void createDarknessEffect(Mob mob, ServerLevel level, Player player) {
        BlockPos mobPos = mob.m_20183_();
        for (int i = 0; i < 6; ++i) {
            double angle = Math.random() * Math.PI * 2.0;
            double radius = 2.0 + Math.random() * 3.0;
            double px = (double)mobPos.m_123341_() + Math.cos(angle) * radius;
            double pz = (double)mobPos.m_123343_() + Math.sin(angle) * radius;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, px, (double)mobPos.m_123342_() + 1.0, pz, 4, 0.2, 0.4, 0.2, 0.02);
        }
        level.m_5594_(null, mobPos, SoundEvents.f_11937_, SoundSource.HOSTILE, 0.4f, 0.5f);
    }

    private static void startStalking(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_STALKING, true);
        data.m_128379_(KEY_RETREATING, false);
        data.m_128473_(KEY_STARE_START);
        mob.m_21557_(true);
    }

    private static void startRetreating(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_RETREATING, true);
        data.m_128379_(KEY_STALKING, false);
        data.m_128356_(KEY_RETREAT_START, now);
        mob.m_21557_(true);
        mob.f_19794_ = true;
    }
}

