/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.entity.FROMTHECAVES3STABEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Phase3StabBehaviourProcedure {
    private static final double CHASE_SPEED = 0.65;
    private static final int DAMAGE_INTERVAL = 20;
    private static final int MAX_DURATION_TICKS = 360;
    private static final double TINY_SPEED = 1.0E-7;
    private static final double CAMERA_PITCH_OFFSET = 60.0;
    private static final double TELEPORT_OFFSET = 1.0;
    private static final double PHASE1_TRIGGER_DISTANCE = 3.0;
    private static final double DAMAGE_DISTANCE = 5.0;

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        int phase;
        boolean client;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof FROMTHECAVES3STABEntity)) {
            return;
        }
        FROMTHECAVES3STABEntity stab = (FROMTHECAVES3STABEntity)ent;
        Player closest = stab.m_9236_().m_45930_((Entity)stab, 64.0);
        if (closest != null) {
            double dx = closest.m_20185_() - stab.m_20185_();
            double dz = closest.m_20189_() - stab.m_20189_();
            double dy = closest.m_20186_() + (double)closest.m_20192_() - (stab.m_20186_() + (double)stab.m_20192_());
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float flat = (float)Math.sqrt(dx * dx + dz * dz);
            float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
            stab.m_146922_(yaw);
            stab.f_20883_ = yaw;
            stab.f_20885_ = yaw;
            stab.m_146926_(pitch);
        }
        ServerLevel level = (client = stab.m_9236_().f_46443_) ? null : (ServerLevel)stab.m_9236_();
        CompoundTag data = stab.getPersistentData();
        if (!data.m_128441_("stabStart")) {
            long now = level != null ? level.m_46467_() : 0L;
            data.m_128356_("stabStart", now);
            data.m_128405_("stabPhase", 0);
        }
        if ((phase = data.m_128451_("stabPhase")) == 0 && !client) {
            Player tgt = stab.m_9236_().m_45930_((Entity)stab, 64.0);
            if (tgt != null) {
                stab.m_21573_().m_5624_((Entity)tgt, 0.65);
                stab.m_6710_((LivingEntity)tgt);
                if ((double)stab.m_20270_((Entity)tgt) < 3.0) {
                    data.m_128405_("stabPhase", 1);
                    data.m_128356_("stabStart", level.m_46467_());
                    double origSpeed = tgt.m_21051_(Attributes.f_22279_).m_22115_();
                    tgt.getPersistentData().m_128347_("origSpeed", origSpeed);
                    float origWalking = tgt.m_150110_().m_35947_();
                    tgt.getPersistentData().m_128350_("origWalking", origWalking);
                    MobEffectInstance oldJump = tgt.m_21124_(MobEffects.f_19603_);
                    if (oldJump != null) {
                        tgt.getPersistentData().m_128405_("origJumpAmp", oldJump.m_19564_());
                        tgt.getPersistentData().m_128405_("origJumpDur", oldJump.m_19557_());
                        tgt.getPersistentData().m_128379_("hadJumpEffect", true);
                        tgt.m_21195_(MobEffects.f_19603_);
                    }
                    tgt.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 720, -11, false, false));
                    tgt.m_21051_(Attributes.f_22279_).m_22100_(1.0E-7);
                    tgt.m_150110_().m_35948_(1.0E-7f);
                    if (tgt instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)tgt;
                        sp.m_6885_();
                    }
                    Phase3StabBehaviourProcedure.teleportPlayerInFront(tgt, stab);
                    Phase3StabBehaviourProcedure.lockPlayerCamera(tgt, stab);
                    stab.m_20124_(Pose.CROUCHING);
                    stab.m_20334_(0.0, 0.0, 0.0);
                    stab.m_21573_().m_26573_();
                    stab.setAnimation("animation.model.stab");
                }
            }
            return;
        }
        if (phase == 1 && !client) {
            Player tgt = level.m_45930_((Entity)stab, 5.0);
            if (tgt == null) {
                return;
            }
            tgt.m_21051_(Attributes.f_22279_).m_22100_(1.0E-7);
            tgt.m_150110_().m_35948_(1.0E-7f);
            if (tgt instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)tgt;
                sp.m_6885_();
            }
            Phase3StabBehaviourProcedure.lockPlayerCamera(tgt, stab);
            stab.m_20334_(0.0, 0.0, 0.0);
            stab.m_20124_(Pose.CROUCHING);
            stab.m_21573_().m_26573_();
            long gameTime = level.m_46467_();
            long lastDmg = data.m_128454_("lastDmg");
            if (lastDmg == 0L || gameTime - lastDmg >= 20L) {
                tgt.m_6469_(stab.m_269291_().m_269333_((LivingEntity)stab), 3.0f);
                if (tgt instanceof ServerPlayer) {
                    ServerPlayer shakePlayer = (ServerPlayer)tgt;
                    shakePlayer.f_8906_.m_9829_((Packet)new ClientboundEntityEventPacket((Entity)shakePlayer, 2));
                }
                data.m_128356_("lastDmg", gameTime);
                if (tgt.m_21224_()) {
                    Phase3StabBehaviourProcedure.cleanup(stab, tgt, false);
                    return;
                }
            }
            if (gameTime - data.m_128454_("stabStart") >= 360L) {
                Phase3StabBehaviourProcedure.cleanup(stab, tgt, true);
            }
        }
    }

    private static void lockPlayerCamera(Player tgt, FROMTHECAVES3STABEntity stab) {
        double dx = stab.m_20185_() - tgt.m_20185_();
        double dy = stab.m_20186_() + (double)stab.m_20192_() - (tgt.m_20186_() + (double)tgt.m_20192_());
        double dz = stab.m_20189_() - tgt.m_20189_();
        double flat = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
        pitch = (float)((double)pitch + 60.0);
        tgt.m_146922_(yaw);
        tgt.m_146926_(pitch);
        if (tgt instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)tgt;
            sp.f_8906_.m_9829_((Packet)new ClientboundRotateHeadPacket((Entity)sp, (byte)(yaw * 256.0f / 360.0f)));
        }
    }

    private static void teleportPlayerInFront(Player tgt, FROMTHECAVES3STABEntity stab) {
        Vec3 forward = stab.m_20156_();
        double mobY = stab.m_20186_();
        Vec3 frontPos = new Vec3(stab.m_20185_(), mobY, stab.m_20189_()).m_82549_(forward.m_82490_(1.0));
        tgt.m_6021_(frontPos.f_82479_, frontPos.f_82480_, frontPos.f_82481_);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof FROMTHECAVES3STABEntity)) {
            return;
        }
        FROMTHECAVES3STABEntity stab = (FROMTHECAVES3STABEntity)livingEntity;
        Entity entity = ev.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player tgt = (Player)entity;
        if (stab.m_9236_().f_46443_) {
            return;
        }
        CompoundTag data = stab.getPersistentData();
        int hits = data.m_128451_("stabHits") + 1;
        data.m_128405_("stabHits", hits);
        if (hits >= 5) {
            Phase3StabBehaviourProcedure.cleanup(stab, tgt, true);
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent ev) {
        LivingEntity target = ev.getEntity();
        LivingEntity attacker = target.m_21188_();
        if (target instanceof Player && attacker instanceof FROMTHECAVES3STABEntity) {
            ev.setCanceled(true);
        }
    }

    private static void cleanup(FROMTHECAVES3STABEntity stab, Player tgt, boolean playSound) {
        CompoundTag pd = tgt.getPersistentData();
        double origSpeed = pd.m_128441_("origSpeed") ? pd.m_128459_("origSpeed") : 0.1;
        float origWalking = pd.m_128441_("origWalking") ? pd.m_128457_("origWalking") : 0.1f;
        tgt.m_21051_(Attributes.f_22279_).m_22100_(origSpeed);
        tgt.m_150110_().m_35948_(origWalking);
        if (tgt instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)tgt;
            sp.m_6885_();
        }
        pd.m_128473_("origSpeed");
        pd.m_128473_("origWalking");
        tgt.m_21195_(MobEffects.f_19603_);
        if (pd.m_128471_("hadJumpEffect")) {
            int dur = pd.m_128451_("origJumpDur");
            int amp = pd.m_128451_("origJumpAmp");
            tgt.m_7292_(new MobEffectInstance(MobEffects.f_19603_, dur, amp, false, false));
            pd.m_128473_("hadJumpEffect");
            pd.m_128473_("origJumpAmp");
            pd.m_128473_("origJumpDur");
        }
        stab.m_146870_();
    }
}

