/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RBBSlowerProcedure {
    private static final long RESTORE_DELAY_TICKS = 500L;
    private static final int GRAVITY_SCAN_RADIUS = 8;
    private static final int GRAVITY_SCAN_HEIGHT = 16;
    private static final long GRAVITY_SNAPSHOT_MAX_AGE = 200L;
    private static final Map<ResourceKey<Level>, List<BrokenBlockInfo>> pendingRestores = new ConcurrentHashMap<ResourceKey<Level>, List<BrokenBlockInfo>>();
    private static final Map<ResourceKey<Level>, Map<BlockPos, GravityBlockSnapshot>> gravitySnapshots = new ConcurrentHashMap<ResourceKey<Level>, Map<BlockPos, GravityBlockSnapshot>>();
    private static final Set<Block> GRAVITY_BLOCKS = new HashSet<Block>(Arrays.asList(Blocks.f_49992_, Blocks.f_49993_, Blocks.f_49994_, Blocks.f_50322_, Blocks.f_50323_, Blocks.f_50324_, Blocks.f_50506_, Blocks.f_50507_, Blocks.f_50508_, Blocks.f_50509_, Blocks.f_50510_, Blocks.f_50511_, Blocks.f_50512_, Blocks.f_50513_, Blocks.f_50514_, Blocks.f_50515_, Blocks.f_50516_, Blocks.f_50517_, Blocks.f_50518_, Blocks.f_50519_, Blocks.f_50573_, Blocks.f_50574_, Blocks.f_50260_, Blocks.f_50616_));
    private static final Set<Block> DEPENDENT_BLOCKS = new HashSet<Block>(Arrays.asList(Blocks.f_50088_, Blocks.f_50174_, Blocks.f_50123_, Blocks.f_50146_, Blocks.f_50328_, Blocks.f_50164_, Blocks.f_50124_, Blocks.f_50251_, Blocks.f_50252_, Blocks.f_50253_, Blocks.f_50254_, Blocks.f_50308_, Blocks.f_50309_, Blocks.f_50669_, Blocks.f_50670_, Blocks.f_50710_, Blocks.f_220846_, Blocks.f_271396_, Blocks.f_244625_, Blocks.f_50081_, Blocks.f_50082_, Blocks.f_50139_, Blocks.f_50140_, Blocks.f_50683_, Blocks.f_50684_, Blocks.f_50156_, Blocks.f_50030_, Blocks.f_50031_, Blocks.f_50285_, Blocks.f_50336_, Blocks.f_50337_, Blocks.f_50338_, Blocks.f_50339_, Blocks.f_50340_, Blocks.f_50341_, Blocks.f_50342_, Blocks.f_50343_, Blocks.f_50344_, Blocks.f_50345_, Blocks.f_50346_, Blocks.f_50347_, Blocks.f_50348_, Blocks.f_50349_, Blocks.f_50350_, Blocks.f_50351_, Blocks.f_152543_, Blocks.f_50165_, Blocks.f_50167_, Blocks.f_50168_, Blocks.f_50169_, Blocks.f_50170_, Blocks.f_50171_, Blocks.f_50172_, Blocks.f_50659_, Blocks.f_50660_, Blocks.f_50709_, Blocks.f_220840_, Blocks.f_271227_, Blocks.f_244183_, Blocks.f_50326_, Blocks.f_50327_, Blocks.f_50267_, Blocks.f_50266_, Blocks.f_50716_, Blocks.f_50261_, Blocks.f_50112_, Blocks.f_50111_, Blocks.f_50113_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50116_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50119_, Blocks.f_50120_, Blocks.f_50121_, Blocks.f_50071_, Blocks.f_50070_, Blocks.f_50355_, Blocks.f_50356_, Blocks.f_50357_, Blocks.f_50358_, Blocks.f_50359_, Blocks.f_50360_, Blocks.f_50072_, Blocks.f_50073_, Blocks.f_50700_, Blocks.f_50691_, Blocks.f_50654_, Blocks.f_50693_, Blocks.f_50694_, Blocks.f_50036_, Blocks.f_50034_, Blocks.f_50035_, Blocks.f_50130_, Blocks.f_50092_, Blocks.f_50249_, Blocks.f_50250_, Blocks.f_50444_, Blocks.f_50685_, Blocks.f_50190_, Blocks.f_50189_, Blocks.f_50188_, Blocks.f_50187_, Blocks.f_50262_, Blocks.f_50200_, Blocks.f_50491_, Blocks.f_50490_, Blocks.f_50575_, Blocks.f_50576_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50567_, Blocks.f_50571_, Blocks.f_50570_, Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50702_, Blocks.f_50703_, Blocks.f_152475_, Blocks.f_152538_, Blocks.f_152539_, Blocks.f_152540_, Blocks.f_152541_, Blocks.f_152542_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152547_, Blocks.f_152548_, Blocks.f_50196_, Blocks.f_271329_, Blocks.f_276668_, Blocks.f_276665_, Blocks.f_271410_, Blocks.f_271445_, Blocks.f_50095_, Blocks.f_50149_, Blocks.f_50150_, Blocks.f_50152_, Blocks.f_50151_, Blocks.f_50153_, Blocks.f_50673_, Blocks.f_50674_, Blocks.f_220841_, Blocks.f_271516_, Blocks.f_244433_, Blocks.f_50158_, Blocks.f_50159_, Blocks.f_50160_, Blocks.f_50162_, Blocks.f_50161_, Blocks.f_50163_, Blocks.f_50675_, Blocks.f_50676_, Blocks.f_220839_, Blocks.f_271107_, Blocks.f_244608_, Blocks.f_244319_, Blocks.f_244633_, Blocks.f_243890_, Blocks.f_244263_, Blocks.f_243716_, Blocks.f_243960_, Blocks.f_244147_, Blocks.f_244396_, Blocks.f_244485_, Blocks.f_271116_, Blocks.f_244091_, Blocks.f_244093_, Blocks.f_243895_, Blocks.f_244296_, Blocks.f_243897_, Blocks.f_243773_, Blocks.f_243998_, Blocks.f_244281_, Blocks.f_244241_, Blocks.f_244385_, Blocks.f_271427_, Blocks.f_244462_, Blocks.f_50155_, Blocks.f_50616_, Blocks.f_50681_, Blocks.f_50682_, Blocks.f_50184_, Blocks.f_50145_, Blocks.f_50125_, Blocks.f_50191_, Blocks.f_152539_, Blocks.f_220856_, Blocks.f_50414_, Blocks.f_50415_, Blocks.f_50416_, Blocks.f_50417_, Blocks.f_50418_, Blocks.f_50419_, Blocks.f_50420_, Blocks.f_50421_, Blocks.f_50422_, Blocks.f_50423_, Blocks.f_50424_, Blocks.f_50425_, Blocks.f_50426_, Blocks.f_50427_, Blocks.f_50428_, Blocks.f_50429_, Blocks.f_50430_, Blocks.f_50431_, Blocks.f_50432_, Blocks.f_50433_, Blocks.f_50434_, Blocks.f_50435_, Blocks.f_50436_, Blocks.f_50437_, Blocks.f_50438_, Blocks.f_50439_, Blocks.f_50388_, Blocks.f_50389_, Blocks.f_50390_, Blocks.f_50391_, Blocks.f_50392_, Blocks.f_50393_, Blocks.f_50680_, Blocks.f_152482_, Blocks.f_152483_, Blocks.f_152484_, Blocks.f_152511_, Blocks.f_152512_, Blocks.f_152513_, Blocks.f_152514_, Blocks.f_152515_, Blocks.f_152516_, Blocks.f_152517_, Blocks.f_152518_, Blocks.f_152519_, Blocks.f_152520_, Blocks.f_152521_, Blocks.f_152522_, Blocks.f_152523_, Blocks.f_152524_, Blocks.f_152525_, Blocks.f_152526_, Blocks.f_152527_, Blocks.f_152528_, Blocks.f_152529_, Blocks.f_152530_, Blocks.f_152531_, Blocks.f_152532_, Blocks.f_152533_, Blocks.f_152534_, Blocks.f_152535_, Blocks.f_152536_, Blocks.f_152485_, Blocks.f_152486_, Blocks.f_152487_, Blocks.f_152488_, Blocks.f_152489_, Blocks.f_50489_, Blocks.f_152587_, Blocks.f_50128_));

    private static void captureGravityBlocksInArea(ServerLevel server, BlockPos centerPos) {
        if (!FromTheCavesToggleManagerProcedure.isAutoRestoreBrokenEnabled()) {
            return;
        }
        ResourceKey dimension = server.m_46472_();
        Map gravityMap = gravitySnapshots.computeIfAbsent((ResourceKey<Level>)dimension, k -> new ConcurrentHashMap());
        long currentTick = server.m_46467_();
        for (int x = -8; x <= 8; ++x) {
            for (int y = -2; y <= 16; ++y) {
                for (int z = -8; z <= 8; ++z) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(checkPos);
                    if (!GRAVITY_BLOCKS.contains(state.m_60734_()) || gravityMap.containsKey(checkPos)) continue;
                    CompoundTag nbt = RBBSlowerProcedure.captureBlockEntityNbt(server.m_7702_(checkPos));
                    gravityMap.put(checkPos.m_7949_(), new GravityBlockSnapshot(checkPos.m_7949_(), state, nbt, currentTick));
                }
            }
        }
    }

    private static List<DependentBlockInfo> collectFallenGravityBlocks(ServerLevel server, BlockPos centerPos) {
        ArrayList<DependentBlockInfo> fallen = new ArrayList<DependentBlockInfo>();
        ResourceKey dimension = server.m_46472_();
        Map<BlockPos, GravityBlockSnapshot> gravityMap = gravitySnapshots.get(dimension);
        if (gravityMap == null || gravityMap.isEmpty()) {
            return fallen;
        }
        gravityMap.entrySet().removeIf(entry -> {
            BlockPos originalPos = (BlockPos)entry.getKey();
            GravityBlockSnapshot snapshot = (GravityBlockSnapshot)entry.getValue();
            BlockState currentState = server.m_8055_(originalPos);
            if (currentState.m_60795_() || !currentState.m_60713_(snapshot.state.m_60734_())) {
                fallen.add(new DependentBlockInfo(snapshot.originalPos, snapshot.state, snapshot.blockEntityNbt));
                return true;
            }
            return false;
        });
        if (gravityMap.isEmpty()) {
            gravitySnapshots.remove(dimension);
        }
        return fallen;
    }

    private static List<DependentBlockInfo> findDependentBlocks(ServerLevel server, BlockPos pos) {
        BlockPos[] positions;
        ArrayList<DependentBlockInfo> dependents = new ArrayList<DependentBlockInfo>();
        for (BlockPos checkPos : positions = new BlockPos[]{pos.m_7494_(), pos.m_6630_(2), pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7495_()}) {
            BlockState state = server.m_8055_(checkPos);
            Block block = state.m_60734_();
            if (!DEPENDENT_BLOCKS.contains(block) && !ProtectedBlocksProcedure.isProtected(state)) continue;
            if (ProtectedBlocksProcedure.isProtected(state)) {
                ProtectedBlocksProcedure.cacheBlockData(server, checkPos);
                continue;
            }
            CompoundTag nbt = RBBSlowerProcedure.captureBlockEntityNbt(server.m_7702_(checkPos));
            dependents.add(new DependentBlockInfo(checkPos.m_7949_(), state, nbt));
        }
        return dependents;
    }

    public static void destroyAndRecord(ServerLevel server, BlockPos pos) {
        RBBSlowerProcedure.destroyAndRecord(server, pos, false);
    }

    public static void destroyAndRecord(ServerLevel server, BlockPos pos, boolean dropItems) {
        if (server == null || pos == null) {
            return;
        }
        BlockState state = server.m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        if (ProtectedBlocksProcedure.isProtected(state)) {
            ProtectedBlocksProcedure.cacheBlockData(server, pos);
            return;
        }
        boolean isGravityBlock = GRAVITY_BLOCKS.contains(state.m_60734_());
        if (isGravityBlock) {
            RBBSlowerProcedure.captureGravityBlocksInArea(server, pos);
        }
        List<DependentBlockInfo> dependents = RBBSlowerProcedure.findDependentBlocks(server, pos);
        CompoundTag blockEntityNbt = RBBSlowerProcedure.captureBlockEntityNbt(server.m_7702_(pos));
        for (DependentBlockInfo dep : dependents) {
            RBBSlowerProcedure.safeDestroyBlock(server, dep.pos, false);
        }
        RBBSlowerProcedure.safeDestroyBlock(server, pos, dropItems);
        if (isGravityBlock) {
            server.m_7654_().execute(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List<DependentBlockInfo> fallen = RBBSlowerProcedure.collectFallenGravityBlocks(server, pos);
                dependents.addAll(fallen);
            });
        }
        if (!FromTheCavesToggleManagerProcedure.isAutoRestoreBrokenEnabled()) {
            return;
        }
        long restoreTick = server.m_46467_() + 500L;
        ResourceKey dimension = server.m_46472_();
        pendingRestores.computeIfAbsent((ResourceKey<Level>)dimension, k -> Collections.synchronizedList(new ArrayList())).add(new BrokenBlockInfo(pos.m_7949_(), state, blockEntityNbt, restoreTick, dependents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.f_46443_) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        RBBSlowerProcedure.cleanupOldGravitySnapshots(server);
        ResourceKey dimension = server.m_46472_();
        List<BrokenBlockInfo> pendingList = pendingRestores.get(dimension);
        if (pendingList == null || pendingList.isEmpty()) {
            return;
        }
        long currentTick = server.m_46467_();
        List<BrokenBlockInfo> list = pendingList;
        synchronized (list) {
            pendingList.removeIf(info -> {
                if (currentTick >= info.restoreAtTick) {
                    RBBSlowerProcedure.restoreBlock(server, info);
                    return true;
                }
                return false;
            });
            if (pendingList.isEmpty()) {
                pendingRestores.remove(dimension);
            }
        }
    }

    private static void restoreBlock(ServerLevel server, BrokenBlockInfo info) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                BlockEntity blockEntity;
                server.m_7731_(info.pos, info.state, 3);
                if (info.blockEntityNbt == null || (blockEntity = server.m_7702_(info.pos)) == null) break;
                RBBSlowerProcedure.restoreBlockEntityFromNbt(blockEntity, info.blockEntityNbt);
                blockEntity.m_6596_();
                server.m_7260_(info.pos, info.state, info.state, 3);
                break;
            }
            catch (Throwable blockEntity) {
                continue;
            }
        }
        for (DependentBlockInfo dep : info.dependents) {
            try {
                BlockEntity depEntity;
                server.m_7731_(dep.pos, dep.state, 3);
                if (dep.blockEntityNbt == null || (depEntity = server.m_7702_(dep.pos)) == null) continue;
                RBBSlowerProcedure.restoreBlockEntityFromNbt(depEntity, dep.blockEntityNbt);
                depEntity.m_6596_();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void cleanupOldGravitySnapshots(ServerLevel server) {
        ResourceKey dimension = server.m_46472_();
        Map<BlockPos, GravityBlockSnapshot> gravityMap = gravitySnapshots.get(dimension);
        if (gravityMap == null || gravityMap.isEmpty()) {
            return;
        }
        long currentTick = server.m_46467_();
        gravityMap.entrySet().removeIf(entry -> currentTick - ((GravityBlockSnapshot)entry.getValue()).capturedTick > 200L);
        if (gravityMap.isEmpty()) {
            gravitySnapshots.remove(dimension);
        }
    }

    private static void safeDestroyBlock(ServerLevel server, BlockPos pos, boolean dropItems) {
        try {
            server.m_46961_(pos, dropItems);
        }
        catch (Throwable t) {
            try {
                server.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static CompoundTag captureBlockEntityNbt(BlockEntity blockEntity) {
        String[] methods;
        if (blockEntity == null) {
            return null;
        }
        for (String methodName : methods = new String[]{"saveWithFullMetadata", "saveWithId", "saveWithoutMetadata", "createNbtWithIdentifyingData", "createNbt", "serializeNBT", "save"}) {
            try {
                Method method = blockEntity.getClass().getMethod(methodName, new Class[0]);
                Object result = method.invoke((Object)blockEntity, new Object[0]);
                if (!(result instanceof CompoundTag)) continue;
                return (CompoundTag)result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            CompoundTag tag = new CompoundTag();
            Method method = blockEntity.getClass().getMethod("save", CompoundTag.class);
            method.invoke((Object)blockEntity, tag);
            return tag;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void restoreBlockEntityFromNbt(BlockEntity blockEntity, CompoundTag tag) {
        String[] methods;
        if (blockEntity == null || tag == null) {
            return;
        }
        for (String methodName : methods = new String[]{"load", "readNbt", "deserializeNBT", "fromTag", "read"}) {
            try {
                Method method = blockEntity.getClass().getMethod(methodName, CompoundTag.class);
                method.invoke((Object)blockEntity, tag);
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    private static class GravityBlockSnapshot {
        final BlockPos originalPos;
        final BlockState state;
        final CompoundTag blockEntityNbt;
        final long capturedTick;

        GravityBlockSnapshot(BlockPos pos, BlockState state, CompoundTag nbt, long tick) {
            this.originalPos = pos;
            this.state = state;
            this.blockEntityNbt = nbt;
            this.capturedTick = tick;
        }
    }

    private static class DependentBlockInfo {
        final BlockPos pos;
        final BlockState state;
        final CompoundTag blockEntityNbt;

        DependentBlockInfo(BlockPos pos, BlockState state, CompoundTag nbt) {
            this.pos = pos;
            this.state = state;
            this.blockEntityNbt = nbt;
        }
    }

    private static class BrokenBlockInfo {
        final BlockPos pos;
        final BlockState state;
        final CompoundTag blockEntityNbt;
        final long restoreAtTick;
        final List<DependentBlockInfo> dependents;

        BrokenBlockInfo(BlockPos pos, BlockState state, CompoundTag nbt, long restoreTick, List<DependentBlockInfo> deps) {
            this.pos = pos;
            this.state = state;
            this.blockEntityNbt = nbt;
            this.restoreAtTick = restoreTick;
            this.dependents = deps != null ? deps : new ArrayList();
        }
    }
}

