/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESWALLFULLEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RevealWallDiggerProcedure {
    private static final double BASE_PROB = 0.0015;
    private static final double MAX_PROB = 0.003;
    private static final int LIGHT_THRESHOLD = 18;
    private static final int MIN_DIST = 2;
    private static final int MAX_DIST = 4;
    private static final int MIN_BREAK_INTERVAL = 5;
    private static final int MAX_BREAK_INTERVAL = 20;
    private static final int SIGHT_DELAY = 20;
    private static final int BLIND_TICKS = 100;
    private static final int FREEZE_DURATION = 40;
    private static final double FOLLOW_SPEED = 0.5;
    private static final double HIT_DISTANCE = 0.8;
    private static final double VISIBILITY_CHECK_RANGE = 32.0;
    private static final double SOUND_CHANCE = 0.007;
    private static final float SOUND_PITCH = 0.3f;
    private static final double MIN_BREAK_DISTANCE = 0.3;
    private static final double MAX_BREAK_DISTANCE = 1.0;

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent evt) {
        SoundEvent breakSound;
        Player player = evt.getPlayer();
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor.m_5776_()) {
            return;
        }
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase < 1 || phase > 2) {
            return;
        }
        BlockPos clickedPos = evt.getPos();
        if (serverLevel.m_45517_(LightLayer.BLOCK, clickedPos) >= 18) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(serverLevel, player, 0.0015, 0.003);
        if (Math.random() >= dynamicProb) {
            return;
        }
        RandomSource rand = serverLevel.m_213780_();
        double angle = rand.m_188500_() * Math.PI * 2.0;
        int distance = 2 + rand.m_188503_(3);
        int dx = (int)Math.round(Math.cos(angle) * (double)distance);
        int dz = (int)Math.round(Math.sin(angle) * (double)distance);
        int px = Mth.m_14107_((double)player.m_20185_());
        int pz = Mth.m_14107_((double)player.m_20189_());
        int playerY = Mth.m_14107_((double)player.m_20186_());
        BlockPos spawnBase = new BlockPos(px + dx, playerY, pz + dz);
        FROMTHECAVESWALLFULLEntity dummy = (FROMTHECAVESWALLFULLEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESWALLFULL.get()).m_20615_((Level)serverLevel);
        if (dummy == null) {
            return;
        }
        int eyeOffset = Mth.m_14143_((float)dummy.m_20192_());
        BlockPos upper = spawnBase.m_6630_(eyeOffset);
        BlockState feetSt = serverLevel.m_8055_(spawnBase);
        if (ProtectedBlocksProcedure.isProtected(feetSt)) {
            return;
        }
        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(serverLevel, spawnBase, true);
        BlockState headSt = serverLevel.m_8055_(upper);
        if (ProtectedBlocksProcedure.isProtected(headSt)) {
            return;
        }
        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(serverLevel, upper, false);
        dummy.m_7678_((double)spawnBase.m_123341_() + 0.5, spawnBase.m_123342_(), (double)spawnBase.m_123343_() + 0.5, 0.0f, 0.0f);
        serverLevel.m_7967_((Entity)dummy);
        CompoundTag nbt = dummy.getPersistentData();
        long now = serverLevel.m_46467_();
        nbt.m_128356_("spawnTick", now);
        nbt.m_128379_("isDigger", true);
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("sightedTick", 0L);
        nbt.m_128356_("freezeUntil", 0L);
        if (!nbt.m_128441_("nextBreakInterval")) {
            nbt.m_128405_("nextBreakInterval", 5 + serverLevel.f_46441_.m_188503_(16));
        }
        if ((breakSound = RevealWallDiggerProcedure.resolveSound(SoundEvents.f_12442_)) != null) {
            serverLevel.m_5594_(null, spawnBase, breakSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        long freezeUntil;
        long firstSight;
        SoundEvent scarySound;
        Player pMaybe;
        UUID targetId;
        LivingEntity e = ev.getEntity();
        if (!(e instanceof FROMTHECAVESWALLFULLEntity)) {
            return;
        }
        FROMTHECAVESWALLFULLEntity mob = (FROMTHECAVESWALLFULLEntity)e;
        Level level = mob.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase < 1 || phase > 2) {
            return;
        }
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("isDigger")) {
            return;
        }
        try {
            targetId = nbt.m_128342_("targetUUID");
        }
        catch (Exception ex) {
            targetId = null;
        }
        if (targetId == null) {
            ServerPlayer closest = null;
            double minDistSq = Double.MAX_VALUE;
            for (ServerPlayer p : serverLevel.m_6907_()) {
                double d2 = mob.m_20280_((Entity)p);
                if (!(d2 < minDistSq)) continue;
                minDistSq = d2;
                closest = p;
            }
            if (closest == null) {
                return;
            }
            targetId = closest.m_20148_();
            nbt.m_128362_("targetUUID", targetId);
        }
        if (!((pMaybe = serverLevel.m_46003_(targetId)) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer target = (ServerPlayer)pMaybe;
        long now = serverLevel.m_46467_();
        double distToPlayer = mob.m_20270_((Entity)target);
        if (distToPlayer <= 0.8) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
            SoundEvent cave = RevealWallDiggerProcedure.resolveSound(SoundEvents.f_11689_);
            if (cave != null) {
                serverLevel.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), cave, SoundSource.AMBIENT, 1.0f, 0.9f);
            }
            mob.m_146870_();
            return;
        }
        if (mob.f_19797_ % 2 == 0 && (double)serverLevel.f_46441_.m_188501_() < 0.007 && (scarySound = RevealWallDiggerProcedure.resolveSound(new ResourceLocation("fromthecaves", "it_10"))) != null) {
            serverLevel.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), scarySound, SoundSource.AMBIENT, 1.0f, 0.3f);
        }
        if ((firstSight = nbt.m_128454_("sightedTick")) == 0L && target.m_142582_((Entity)mob)) {
            nbt.m_128356_("sightedTick", now);
        }
        if (!nbt.m_128441_("nextBreakInterval")) {
            nbt.m_128405_("nextBreakInterval", 5 + serverLevel.f_46441_.m_188503_(16));
        }
        if (now < (freezeUntil = nbt.m_128454_("freezeUntil"))) {
            mob.m_20256_(Vec3.f_82478_);
            return;
        }
        int breakInterval = nbt.m_128451_("nextBreakInterval");
        if (mob.f_19797_ % breakInterval == 0) {
            RevealWallDiggerProcedure.breakBlocksInFront(serverLevel, mob, (Player)target);
            nbt.m_128405_("nextBreakInterval", 5 + serverLevel.f_46441_.m_188503_(16));
            if (!RevealWallDiggerProcedure.isVisibleToAnyPlayer(serverLevel, mob) && serverLevel.f_46441_.m_188501_() < 0.3f) {
                nbt.m_128356_("freezeUntil", now + 40L);
                return;
            }
        }
        if (firstSight <= 0L || now >= firstSight + 20L) {
            // empty if block
        }
        Vec3 diff = target.m_20182_().m_82546_(mob.m_20182_());
        float yaw = (float)Math.toDegrees(Math.atan2(diff.f_82481_, diff.f_82479_)) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20885_ = yaw;
        mob.f_20883_ = yaw;
        Vec3 vel = diff.m_82541_().m_82490_(0.5);
        mob.m_20334_(vel.f_82479_, mob.m_20184_().f_82480_, vel.f_82481_);
        mob.m_6478_(MoverType.SELF, mob.m_20184_());
    }

    private static void breakBlocksInFront(ServerLevel server, FROMTHECAVESWALLFULLEntity mob, Player player) {
        Vec3 lookVec = mob.m_20154_();
        BlockPos minerPos = mob.m_20183_();
        double minerY = mob.m_20186_();
        double playerY = player.m_20186_();
        ArrayList<BlockPos> positionsToBreak = new ArrayList<BlockPos>();
        boolean canBreakDown = minerY - playerY >= 1.0;
        for (double distance = 0.3; distance <= 1.0; distance += 0.7) {
            int forwardX = (int)Math.round(lookVec.f_82479_ * distance);
            int forwardZ = (int)Math.round(lookVec.f_82481_ * distance);
            BlockPos headLevel = minerPos.m_7918_(forwardX, 1, forwardZ);
            positionsToBreak.add(headLevel);
            if (!canBreakDown) continue;
            BlockPos feetLevel = minerPos.m_7918_(forwardX, 0, forwardZ);
            positionsToBreak.add(feetLevel);
            BlockPos belowFeet = minerPos.m_7918_(forwardX, -1, forwardZ);
            positionsToBreak.add(belowFeet);
        }
        BlockPos directFront = minerPos.m_7918_((int)Math.round(lookVec.f_82479_), 0, (int)Math.round(lookVec.f_82481_));
        positionsToBreak.add(directFront);
        positionsToBreak.add(directFront.m_7494_());
        for (BlockPos pos : positionsToBreak) {
            if (!RevealWallDiggerProcedure.isBreakableBlock(server, pos)) continue;
            RestoreBrokenBlocksManagerProcedure.destroyAndRecord(server, pos, false);
            SoundEvent breakSound = RevealWallDiggerProcedure.resolveSound(SoundEvents.f_12442_);
            if (breakSound == null) continue;
            server.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), breakSound, SoundSource.BLOCKS, 0.8f, 0.9f + server.f_46441_.m_188501_() * 0.2f);
        }
    }

    private static boolean isBreakableBlock(ServerLevel server, BlockPos pos) {
        BlockState state = server.m_8055_(pos);
        return !state.m_60795_() && state.m_60734_() != Blocks.f_50752_ && state.m_60800_((BlockGetter)server, pos) >= 0.0f && !ProtectedBlocksProcedure.isProtected(state);
    }

    private static boolean isVisibleToAnyPlayer(ServerLevel server, FROMTHECAVESWALLFULLEntity mob) {
        Vec3 minerEye = mob.m_146892_();
        for (Player player : server.m_6907_()) {
            ClipContext context;
            BlockHitResult result;
            Vec3 toMiner;
            if ((double)player.m_20270_((Entity)mob) > 32.0) continue;
            Vec3 playerEye = player.m_146892_();
            Vec3 lookVec = player.m_20154_();
            double dot = lookVec.m_82526_(toMiner = minerEye.m_82546_(playerEye).m_82541_());
            if (!(dot > 0.5) || (result = server.m_45547_(context = new ClipContext(playerEye, minerEye, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() != HitResult.Type.MISS) continue;
            return true;
        }
        return false;
    }

    private static SoundEvent resolveSound(Object soundConst) {
        Object res;
        Method m2;
        if (soundConst instanceof SoundEvent) {
            SoundEvent se = (SoundEvent)soundConst;
            return se;
        }
        try {
            m2 = soundConst.getClass().getMethod("value", new Class[0]);
            res = m2.invoke(soundConst, new Object[0]);
            if (res instanceof SoundEvent) {
                return (SoundEvent)res;
            }
        }
        catch (Exception m2) {
            // empty catch block
        }
        try {
            m2 = soundConst.getClass().getMethod("get", new Class[0]);
            res = m2.invoke(soundConst, new Object[0]);
            if (res instanceof SoundEvent) {
                return (SoundEvent)res;
            }
        }
        catch (Exception m3) {
            // empty catch block
        }
        try {
            m2 = soundConst.getClass().getMethod("orElse", Object.class);
            Object object = m2.invoke(soundConst, new Object[]{null});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

