/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESROOFEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModSounds;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoofMobBehaviorProcedure {
    private static final long BREAK_INTERVAL = 20L;
    private static final long LIFETIME_TICKS = 300L;
    private static final long BLINDNESS_DELAY = 40L;
    private static final int BLINDNESS_DURATION = 100;
    private static final long CLOSE_DESPAWN_DELAY = 20L;
    private static final long WOOD_SOUND_INTERVAL = 30L;
    private static final long SCRAPE_SOUND_INTERVAL = 45L;
    private static final long CHECK_CEILING_INTERVAL = 10L;
    private static final double LOOK_AT_THRESHOLD = 0.95;
    private static final double CLOSE_DISTANCE_SQ = 4.0;

    @SubscribeEvent
    public static void onRoofMobTick(LivingEvent.LivingTickEvent event) {
        LivingEntity ent = event.getEntity();
        if (!(ent instanceof FROMTHECAVESROOFEntity)) {
            return;
        }
        FROMTHECAVESROOFEntity roof = (FROMTHECAVESROOFEntity)ent;
        if (roof.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)roof.m_9236_();
        CompoundTag nbt = roof.getPersistentData();
        long now = server.m_46467_();
        Player target = RoofMobBehaviorProcedure.getTargetPlayer(roof, server, nbt);
        if (target == null) {
            roof.m_146870_();
            return;
        }
        if (RoofMobBehaviorProcedure.shouldDespawnWhenLookedAt(roof, target, server)) {
            return;
        }
        if (RoofMobBehaviorProcedure.shouldDespawnNoCeiling(roof, target, server, nbt, now)) {
            return;
        }
        RoofMobBehaviorProcedure.updateMobOrientation(roof, target);
        RoofMobBehaviorProcedure.processBlockBreaking(roof, target, server, nbt, now);
        RoofMobBehaviorProcedure.handleProximityDespawn(roof, target, nbt, now);
        RoofMobBehaviorProcedure.handleFirstSighting(roof, server, nbt, now);
        RoofMobBehaviorProcedure.applyBlindnessAndSound(roof, server, nbt, now);
        RoofMobBehaviorProcedure.playWoodFootstepSounds(roof, server, nbt, now);
        RoofMobBehaviorProcedure.playScrapingSounds(roof, server, nbt, now);
        RoofMobBehaviorProcedure.handleLifetimeDespawn(roof, nbt, now);
    }

    private static Player getTargetPlayer(FROMTHECAVESROOFEntity roof, ServerLevel server, CompoundTag nbt) {
        UUID targetUUID;
        if (!nbt.m_128441_("targetPlayerUUID")) {
            return null;
        }
        if (nbt.m_128423_("targetPlayerUUID") == null) {
            return null;
        }
        try {
            targetUUID = nbt.m_128342_("targetPlayerUUID");
        }
        catch (Throwable ex) {
            return null;
        }
        return server.m_46003_(targetUUID);
    }

    private static boolean shouldDespawnWhenLookedAt(FROMTHECAVESROOFEntity roof, Player target, ServerLevel server) {
        Vec3 toMobVec;
        Vec3 eyeVec = target.m_20154_().m_82541_();
        double dot = eyeVec.m_82526_(toMobVec = roof.m_20182_().m_82546_(target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0)).m_82541_());
        if (dot > 0.95 && target.m_142582_((Entity)roof)) {
            RoofMobBehaviorProcedure.stopHostileSounds(target);
            RoofMobBehaviorProcedure.playAppearSound(roof, server);
            roof.m_146870_();
            return true;
        }
        return false;
    }

    private static boolean shouldDespawnNoCeiling(FROMTHECAVESROOFEntity roof, Player target, ServerLevel server, CompoundTag nbt, long now) {
        long lastCeilingCheck = nbt.m_128454_("lastCeilingCheck");
        if (now - lastCeilingCheck < 10L) {
            return false;
        }
        nbt.m_128356_("lastCeilingCheck", now);
        int playerX = target.m_146903_();
        int playerZ = target.m_146907_();
        int playerY = target.m_146904_();
        int ceilingY = server.m_6924_(Heightmap.Types.MOTION_BLOCKING, playerX, playerZ);
        if (ceilingY <= playerY + 1) {
            roof.m_146870_();
            return true;
        }
        double verticalDist = Math.abs(roof.m_20186_() - (double)ceilingY);
        if (verticalDist > 3.0) {
            roof.m_6034_(roof.m_20185_(), (double)ceilingY + 0.5, roof.m_20189_());
        }
        return false;
    }

    private static void stopHostileSounds(Player target) {
        if (!(target instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)target;
        ResourceLocation appearRL = ForgeRegistries.SOUND_EVENTS.getKey((Object)((SoundEvent)FromTheCavesModSounds.APPEAR_1.get()));
        sp.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(appearRL, SoundSource.HOSTILE));
    }

    private static void playAppearSound(FROMTHECAVESROOFEntity roof, ServerLevel server) {
        server.m_5594_(null, roof.m_20183_(), (SoundEvent)FromTheCavesModSounds.APPEAR_1.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    private static void updateMobOrientation(FROMTHECAVESROOFEntity roof, Player target) {
        Vec3 dir = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0).m_82546_(roof.m_20182_().m_82520_(0.0, (double)roof.m_20192_(), 0.0)).m_82541_();
        float yaw = (float)(Math.atan2(dir.f_82481_, dir.f_82479_) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-Math.atan2(dir.f_82480_, Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 180.0 / Math.PI);
        roof.m_146922_(yaw);
        roof.f_20883_ = yaw;
        roof.f_20885_ = yaw;
        roof.m_146926_(pitch);
    }

    private static void processBlockBreaking(FROMTHECAVESROOFEntity roof, Player target, ServerLevel server, CompoundTag nbt, long now) {
        long lastBreak = nbt.m_128454_("lastBreakTick");
        if (lastBreak == 0L) {
            nbt.m_128356_("lastBreakTick", now);
            return;
        }
        if (now - lastBreak < 20L) {
            return;
        }
        double py = target.m_20186_();
        if (roof.m_20186_() <= py + 1.0 && roof.m_20186_() >= py - 1.0) {
            return;
        }
        BlockPos below = roof.m_20183_().m_7495_();
        if (server.m_46859_(below)) {
            nbt.m_128356_("lastBreakTick", now);
            return;
        }
        BlockState bs = server.m_8055_(below);
        if (ProtectedBlocksProcedure.isProtected(bs)) {
            nbt.m_128356_("lastBreakTick", now);
            return;
        }
        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(server, below, false);
        nbt.m_128356_("lastBreakTick", now);
    }

    private static void handleProximityDespawn(FROMTHECAVESROOFEntity roof, Player target, CompoundTag nbt, long now) {
        double dz;
        double dy;
        double dx = roof.m_20185_() - target.m_20185_();
        double distSq = dx * dx + (dy = roof.m_20186_() - target.m_20186_()) * dy + (dz = roof.m_20189_() - target.m_20189_()) * dz;
        if (distSq <= 4.0) {
            if (!nbt.m_128441_("closeTick")) {
                nbt.m_128356_("closeTick", now);
            } else {
                long closeTick = nbt.m_128454_("closeTick");
                if (now - closeTick >= 20L) {
                    roof.m_146870_();
                }
            }
        } else if (nbt.m_128441_("closeTick")) {
            nbt.m_128473_("closeTick");
        }
    }

    private static void handleFirstSighting(FROMTHECAVESROOFEntity roof, ServerLevel server, CompoundTag nbt, long now) {
        long seenTick = nbt.m_128454_("seenTick");
        if (seenTick != 0L) {
            return;
        }
        for (ServerPlayer p : server.m_6907_()) {
            if (!p.m_142582_((Entity)roof)) continue;
            nbt.m_128356_("seenTick", now);
            break;
        }
    }

    private static void applyBlindnessAndSound(FROMTHECAVESROOFEntity roof, ServerLevel server, CompoundTag nbt, long now) {
        long seenTick = nbt.m_128454_("seenTick");
        if (seenTick == 0L) {
            return;
        }
        if (now - seenTick != 40L) {
            return;
        }
        for (ServerPlayer p : server.m_6907_()) {
            if (!p.m_142582_((Entity)roof)) continue;
            p.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, false));
            SoundEvent ambient = (SoundEvent)SoundEvents.f_11689_.get();
            server.m_5594_(null, p.m_20183_(), ambient, SoundSource.AMBIENT, 1.0f, 0.75f);
        }
    }

    private static void playWoodFootstepSounds(FROMTHECAVESROOFEntity roof, ServerLevel server, CompoundTag nbt, long now) {
        long lastWoodSound = nbt.m_128454_("lastWoodSound");
        if (now - lastWoodSound < 30L) {
            return;
        }
        nbt.m_128356_("lastWoodSound", now);
        float pitch = 0.8f + server.f_46441_.m_188501_() * 0.4f;
        server.m_5594_(null, roof.m_20183_(), SoundEvents.f_12638_, SoundSource.HOSTILE, 0.6f, pitch);
    }

    private static void playScrapingSounds(FROMTHECAVESROOFEntity roof, ServerLevel server, CompoundTag nbt, long now) {
        long lastScrapeSound = nbt.m_128454_("lastScrapeSound");
        if (now - lastScrapeSound < 45L) {
            return;
        }
        nbt.m_128356_("lastScrapeSound", now);
        if (server.f_46441_.m_188500_() < 0.4) {
            float pitch = 0.7f + server.f_46441_.m_188501_() * 0.3f;
            server.m_5594_(null, roof.m_20183_(), SoundEvents.f_12442_, SoundSource.HOSTILE, 0.4f, pitch);
        }
    }

    private static void handleLifetimeDespawn(FROMTHECAVESROOFEntity roof, CompoundTag nbt, long now) {
        long spawnTick = nbt.m_128454_("spawnTick");
        if (now - spawnTick >= 300L) {
            roof.m_146870_();
        }
    }
}

