/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSTEPSEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModBlocks;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RBBSlowerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StepsAmbushProcedure {
    private static final double BASE_PROB = 2.0E-5;
    private static final double MAX_PROB = 3.5E-5;
    private static final double MIN_SPAWN_DIST = 6.0;
    private static final double MAX_SPAWN_DIST = 10.0;
    private static final int MAX_PLAYER_Y = 55;
    private static final double MIN_SPEED = 0.48;
    private static final double MAX_SPEED = 0.58;
    private static final long MIN_STEP_INTERVAL = 35L;
    private static final long MAX_STEP_INTERVAL = 20L;
    private static final double DESPAWN_RANGE = 2.0;
    private static final double SPEED_RAMP_DISTANCE = 10.0;
    private static final double BEHIND_DISTANCE = 3.0;
    private static final double BREAK_RANGE = 1.0;
    private static final double DIG_DOWN_SPEED = 0.35;
    private static final double LIGHT_FLICKER_CHANCE = 0.05;
    private static final double SUDDEN_APPROACH_CHANCE = 0.04;
    private static final double SCARY_SOUND_CHANCE = 0.05;
    private static final int BREAK_INTERVAL = 5;
    private static final Map<UUID, FROMTHECAVESSTEPSEntity> activeMobs = new HashMap<UUID, FROMTHECAVESSTEPSEntity>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_9236_().m_5776_()) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel world = (ServerLevel)player2.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)world);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (player2.m_20186_() > 55.0) {
            return;
        }
        UUID uid = player2.m_20148_();
        if (activeMobs.containsKey(uid)) {
            return;
        }
        double dynProb = ChunkTensionProcedure.getDynamicProbability(world, (Player)player2, 2.0E-5, 3.5E-5);
        if (world.f_46441_.m_188500_() >= dynProb) {
            return;
        }
        double angle = world.f_46441_.m_188500_() * Math.PI * 2.0;
        double dist = 6.0 + world.f_46441_.m_188500_() * 4.0;
        int dx = Mth.m_14107_((double)(Math.cos(angle) * dist));
        int dz = Mth.m_14107_((double)(Math.sin(angle) * dist));
        BlockPos spawnPos = player2.m_20183_().m_7918_(dx, 0, dz);
        FROMTHECAVESSTEPSEntity mob = (FROMTHECAVESSTEPSEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSTEPS.get()).m_20615_((Level)world);
        if (mob == null) {
            return;
        }
        mob.m_6842_(true);
        double speed = 0.48;
        CompoundTag data = mob.getPersistentData();
        data.m_128347_("FTC_Steps_Speed", speed);
        data.m_128356_("FTC_LastStepTick", world.m_46467_());
        data.m_128362_("FTC_Target", uid);
        data.m_128356_("FTC_LastHorrorEvent", world.m_46467_());
        data.m_128356_("FTC_NextSuddenApproach", world.m_46467_() + 200L);
        data.m_128405_("breakCounter", 0);
        mob.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, world.f_46441_.m_188501_() * 360.0f, 0.0f);
        world.m_7967_((Entity)mob);
        activeMobs.put(uid, mob);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent event) {
        PathNavigation nav;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof FROMTHECAVESSTEPSEntity)) {
            return;
        }
        FROMTHECAVESSTEPSEntity mob = (FROMTHECAVESSTEPSEntity)livingEntity;
        Level lvl = mob.m_9236_();
        if (lvl.m_5776_()) {
            return;
        }
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)lvl;
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128403_("FTC_Target")) {
            StepsAmbushProcedure.removeFromActive(mob);
            return;
        }
        Player target = world.m_46003_(data.m_128342_("FTC_Target"));
        if (!(target instanceof ServerPlayer)) {
            StepsAmbushProcedure.restoreBlocks(world, mob);
            mob.m_146870_();
            activeMobs.remove(data.m_128342_("FTC_Target"));
            return;
        }
        ServerPlayer player = (ServerPlayer)target;
        mob.m_21557_(false);
        double dxLook = player.m_20185_() - mob.m_20185_();
        double dzLook = player.m_20189_() - mob.m_20189_();
        float yaw = (float)(Math.atan2(dzLook, dxLook) * 180.0 / Math.PI) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_21563_().m_24960_((Entity)player, 10.0f, 10.0f);
        long now = world.m_46467_();
        StepsAmbushProcedure.triggerHorrorEvents(world, mob, player, data, now);
        double distanceToPlayer = mob.m_20270_((Entity)player);
        double speedFactor = Math.max(0.0, Math.min(1.0, (10.0 - distanceToPlayer) / 10.0));
        double currentSpeed = 0.48 + 0.09999999999999998 * speedFactor;
        long currentStepInterval = (long)(35.0 - 15.0 * speedFactor);
        Vec3 lookVec = player.m_20154_().m_82541_();
        Vec3 desired = player.m_20182_().m_82546_(lookVec.m_82490_(3.0));
        double desiredX = desired.f_82479_;
        double desiredY = desired.f_82480_;
        double desiredZ = desired.f_82481_;
        double speed = currentSpeed;
        long nextApproach = data.m_128454_("FTC_NextSuddenApproach");
        if (now >= nextApproach && world.f_46441_.m_188500_() < 0.04) {
            speed *= 2.5;
            data.m_128356_("FTC_NextSuddenApproach", now + 400L);
        }
        if ((nav = mob.m_21573_()) != null) {
            nav.m_26519_(desiredX, desiredY, desiredZ, speed);
        } else {
            double dz;
            double dx = desiredX - mob.m_20185_();
            double len = Math.hypot(dx, dz = desiredZ - mob.m_20189_());
            if (len > 1.0E-6) {
                double vx = dx / len * speed;
                double vz = dz / len * speed;
                mob.m_20334_(vx, mob.m_20184_().f_82480_, vz);
                mob.m_6478_(MoverType.SELF, mob.m_20184_());
            }
        }
        StepsAmbushProcedure.handleBlockBreaking(mob, world, data);
        long lastStep = data.m_128454_("FTC_LastStepTick");
        if (now >= lastStep + currentStepInterval) {
            data.m_128356_("FTC_LastStepTick", now);
            BlockPos under = mob.m_20183_();
            BlockState underState = world.m_8055_(under);
            if (!ProtectedBlocksProcedure.isProtected(underState) && underState.m_60734_() != FromTheCavesModBlocks.STEP.get()) {
                world.m_46597_(under, ((Block)FromTheCavesModBlocks.STEP.get()).m_49966_());
                StepsAmbushProcedure.saveBlockForRestoration(world, mob, under);
            }
            SoundType soundType = underState.getSoundType((LevelReader)world, under, (Entity)mob);
            SoundEvent stepSound = soundType.m_56776_();
            float volume = soundType.m_56773_();
            float pitch = soundType.m_56774_();
            world.m_5594_(null, under, stepSound, SoundSource.BLOCKS, volume, pitch);
        }
        if ((double)mob.m_20270_((Entity)player) <= 2.0) {
            StepsAmbushProcedure.triggerFinalEvent(world, mob, player);
            StepsAmbushProcedure.restoreBlocks(world, mob);
            mob.m_146870_();
            StepsAmbushProcedure.removeFromActive(mob);
        }
        if (mob.m_213877_()) {
            StepsAmbushProcedure.restoreBlocks(world, mob);
            StepsAmbushProcedure.removeFromActive(mob);
        }
    }

    private static void handleBlockBreaking(FROMTHECAVESSTEPSEntity mob, ServerLevel level, CompoundTag data) {
        int bc = data.m_128451_("breakCounter") + 1;
        if (bc >= 5) {
            BlockState headSt;
            BlockPos pos = mob.m_20183_();
            Direction facing = mob.m_6350_();
            BlockPos feet = pos.m_121945_(facing);
            BlockPos head = feet.m_7494_();
            BlockState feetSt = level.m_8055_(feet);
            if (!feetSt.m_60795_() && !ProtectedBlocksProcedure.isProtected(feetSt)) {
                RBBSlowerProcedure.destroyAndRecord(level, feet, false);
            }
            if (!(headSt = level.m_8055_(head)).m_60795_() && !ProtectedBlocksProcedure.isProtected(headSt)) {
                RBBSlowerProcedure.destroyAndRecord(level, head, false);
            }
            bc = 0;
        }
        data.m_128405_("breakCounter", bc);
    }

    private static void saveBlockForRestoration(ServerLevel world, FROMTHECAVESSTEPSEntity mob, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        CompoundTag mobNbt = mob.getPersistentData();
        ListTag brokenList = mobNbt.m_128425_("brokenBlocksList", 9) ? mobNbt.m_128437_("brokenBlocksList", 10) : new ListTag();
        CompoundTag blockData = new CompoundTag();
        blockData.m_128405_("x", pos.m_123341_());
        blockData.m_128405_("y", pos.m_123342_());
        blockData.m_128405_("z", pos.m_123343_());
        CompoundTag stateTag = new CompoundTag();
        stateTag.m_128359_("blockId", ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString());
        CompoundTag propertiesTag = new CompoundTag();
        state.m_61148_().forEach((property, value) -> propertiesTag.m_128359_(property.m_61708_(), value.toString()));
        stateTag.m_128365_("properties", (Tag)propertiesTag);
        blockData.m_128365_("state", (Tag)stateTag);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            CompoundTag beTag = blockEntity.m_187480_();
            blockData.m_128365_("blockEntity", (Tag)beTag);
        }
        brokenList.add((Object)blockData);
        mobNbt.m_128365_("brokenBlocksList", (Tag)brokenList);
    }

    private static void restoreBlocks(ServerLevel world, FROMTHECAVESSTEPSEntity mob) {
        CompoundTag mobNbt = mob.getPersistentData();
        if (!mobNbt.m_128425_("brokenBlocksList", 9)) {
            return;
        }
        ListTag brokenList = mobNbt.m_128437_("brokenBlocksList", 10);
        for (int i = 0; i < brokenList.size(); ++i) {
            CompoundTag blockData = brokenList.m_128728_(i);
            int x = blockData.m_128451_("x");
            int y = blockData.m_128451_("y");
            int z = blockData.m_128451_("z");
            BlockPos pos = new BlockPos(x, y, z);
            CompoundTag stateTag = blockData.m_128469_("state");
            String blockId = stateTag.m_128461_("blockId");
            BlockState state = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId))).m_49966_();
            world.m_7731_(pos, state, 3);
            if (!blockData.m_128441_("blockEntity")) continue;
            CompoundTag beTag = blockData.m_128469_("blockEntity");
            BlockEntity newBE = world.m_7702_(pos);
            if (newBE == null) continue;
            newBE.m_142466_(beTag);
            newBE.m_6596_();
        }
        mobNbt.m_128473_("brokenBlocksList");
    }

    private static void triggerHorrorEvents(ServerLevel world, FROMTHECAVESSTEPSEntity mob, ServerPlayer player, CompoundTag data, long now) {
        long lastEvent = data.m_128454_("FTC_LastHorrorEvent");
        if (now - lastEvent < 40L) {
            return;
        }
        double roll = world.f_46441_.m_188500_();
        if (roll < 0.05) {
            data.m_128356_("FTC_LastHorrorEvent", now);
            BlockPos playerPos = player.m_20183_();
            for (int dx = -3; dx <= 3; ++dx) {
                for (int dy = -2; dy <= 2; ++dy) {
                    for (int dz = -3; dz <= 3; ++dz) {
                        BlockPos pos = playerPos.m_7918_(dx, dy, dz);
                        BlockState state = world.m_8055_(pos);
                        if (state.m_60791_() <= 0 || !(world.f_46441_.m_188501_() < 0.3f)) continue;
                        world.m_7260_(pos, state, state, 3);
                    }
                }
            }
        } else if (roll < 0.1) {
            data.m_128356_("FTC_LastHorrorEvent", now);
            SoundEvent scarySound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", "it_18"));
            if (scarySound != null) {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), scarySound, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
        }
    }

    private static void triggerFinalEvent(ServerLevel world, FROMTHECAVESSTEPSEntity mob, ServerPlayer player) {
    }

    private static void removeFromActive(FROMTHECAVESSTEPSEntity mob) {
        CompoundTag data = mob.getPersistentData();
        if (data != null && data.m_128403_("FTC_Target")) {
            UUID u = data.m_128342_("FTC_Target");
            FROMTHECAVESSTEPSEntity cur = activeMobs.get(u);
            if (cur != null && cur.m_20148_().equals(mob.m_20148_())) {
                activeMobs.remove(u);
            }
        } else {
            activeMobs.values().removeIf(e -> e == mob);
        }
    }
}

